# SDOH and the Gravity Project - SDOH Clinical Care v3.0.0-ballot

## SDOH and the Gravity Project

### Why Social Determinants of Health Matter

The influence of social determinants on health outcomes is increasingly recognized in emerging payment reform programs, federal and state-based policies, and information technology initiatives. Social determinants of health (SDOH) are the conditions in the environments where people are born, live, learn, work, play, worship, and age that affect a wide range of health, functioning, and quality-of-life outcomes and risks[1](#fn:1).

The growing awareness around SDOH has contributed to efforts to address actionable social risks through the health care delivery system. Recommendations from national groups, including the [American Academy of Pediatrics](https://www.aap.org/), [American Academy of Family Physicians](https://www.aafp.org/), [Agency for Healthcare Research and Quality](https://www.ahrq.gov/), [National Quality Forum (NQF)](https://www.qualityforum.org/), and [Institute for Health Care Improvement](http://www.ihi.org/) underscore the various roles the health care system could play in helping to identify and address patients' social risks and needs.[2](#fn:2)

**Figure 1: What goes into your health? An illustration of the impact health care has on a person’s health versus non-healthcare factors.2**

There is growing awareness that social risks negatively impact health outcomes and that addressing social risks improves health outcomes. For example:

* Food insecurity correlates with higher levels of diabetes, hypertension, and heart failure
* Housing instability factors into lower treatment adherence
* Transportation barriers result in missed appointments, delayed care, and lower medication compliance

Addressing SDOH is a primary approach to achieving health equity. See National Center for HIV, Viral Hepatitis, STD, and TB Prevention (NCHHSTP) Social Determinants of Health, [Frequently Asked Questions](https://www.cdc.gov/health-disparities-hiv-std-tb-hepatitis/about/social-determinants-of-health.html?CDC_AAref_Val=https://www.cdc.gov/nchhstp/socialdeterminants/faq.html)

These national calls to action for health care systems have spurred innovations, including a wide range of social risk assessment instruments and practice-based interventions. Some of these innovations have helped to reduce social risks, improve outcomes, and lower costs. The experimentation in this area has been bolstered by new value-based payment models and accountable care organizations (ACOs), which together offer financial incentives to advance coordinated care between medical and social service organizations and other organizations directly connected to patients.

### Challenges of SDOH Data Interoperability

Challenges related to the systematic documentation and aggregation of SDOH data in EHRs and related systems include:

1. Capture of SDOH data in unstructured and non-standardized formats inhibits the ability to normalize, exchange, and aggregate the data regardless of the data source.
1. Gaps in and overlap between existing terminologies and codes available to represent SDOH-related activities undertaken in clinical delivery settings.
1. SDOH data is sensitive personal information with significant privacy and security considerations. As with all personal data, regulatory and policy considerations related to consent and exchange of this data should be adhered to.

Based on the growing collection of social risk data in health care systems, an immediate opportunity exists to support data collection, data aggregation, data sharing, quality measurement, benchmarking, and risk adjustment. Many assessment tools are currently in use, but the concepts addressed vary, and some tools merit further validation and testing across a variety of settings and clinical workflows. Health IT can play a critical, untapped role in enabling the seamless electronic exchange and use of this data. However, standardization and harmonization of SDOH concepts, regardless of the social risk assessment instrument used, requires a consensus-based approach to maximize buy-in, consistency of implementation, and usefulness of data collected.

### Gravity Project Overview

The [Gravity Project](https://thegravityproject.net/) was initiated by the [Social Interventions Research and Evaluation Network (SIREN)](https://chc.ucsf.edu/siren) with support from the [Robert Wood Johnson Foundation](https://www.rwjf.org/). The Gravity Project mission is to create and maintain a consensus-building community to expand available SDOH Core Data for Interoperability and accelerate standards-based information exchange by using HL7 FHIR. The Gravity Project aims to standardize SDOH-related codes to facilitate the use of social determinants of health-related data in patient care, care coordination between the health and human services sectors, population health management, value-based payment, and clinical research.

The Gravity Project currently has three workstreams as shown in the figure below. The [Terminology Workstream](https://confluence.hl7.org/spaces/GRAV/pages/91994234/Terminology+Workstream) develops terminology resources that are published via the [Value Set Authority Center (VSAC)](https://vsac.nlm.nih.gov/) that support capture of SDOH-related data. The [Technical Workstream](https://confluence.hl7.org/spaces/GRAV/pages/66922000/Technical+Workstream) developed this FHIR Implementation Guide (IG) and coordinates with other FHIR IG development projects.

The [Implementation Workstream](https://confluence.hl7.org/display/GRAV/Implementation+Workstream) works with partners to test and provide feedback on the Gravity-developed Terminology Resources and FHIR IG specifications.

**Figure 2: Gravity Project Workstreams**

For more information about Gravity see the Gravity Project [website](https://thegravityproject.net/) or [confluence site](https://confluence.hl7.org/display/GRAV/The+Gravity+Project).

-------

1. [Healthy People 2030](https://health.gov/healthypeople/priority-areas/social-determinants-health) [↩](#fnref:1)
1. Source: Institute for Clinical Systems Improvement. Going Beyond Clinical Walls. Solving Complex Problems (October 2014). The BridgeSpan Group. [↩](#fnref:2)

