# hl7.fhir.us.sdoh-clinicalcare#3.0.0-ballot: SDOH Clinical Care(en)

## Pages

* [IG Home](index.md)
* [Artifacts Index](artifacts.md)
* [Assessment Instrument Support](assessment_instrument_support.md)
* [Capacity Status](capacity.md)
* [Checking Task Status](checking_task_status.md)
* [Connecting Applications with API Data Sources](connecting_applications_with_api_data_sources.md)
* [Credits](credits.md)
* [Downloads](downloads.md)
* [Enrollment Status](enrollment.md)
* [Glossary](glossary.md)
* [Gravity Project Value Sets](gravity_terminology.md)
* [Must Support and Missing Data](mustsupport_and_missing_data.md)
* [Privacy and Security](privacy_and_security.md)
* [Referral Workflow](referral_workflow.md)
* [Referral for Further Assessment](rffa.md)
* [SDOH and the Gravity Project](sdoh_challenges_gravity.md)
* [Background](sdoh_clinical_care_scope.md)
* [Self-Referral](self_referral.md)
* [Specifications for Personal Characteristics](specifications_for_personal_characteristics.md)
* [STU2.1 Publication Changes](stu2_1_update_changes.md)
* [STU2.2 Publication Changes](stu2_2_update_changes.md)
* [STU2.3 Publication Changes](stu2_3_update_changes.md)
* [STU2 Ballot Changes](stu2_ballot_changes.md)
* [STU2 Publication Changes](stu2_publication_changes.md)
* [STU3 Ballot Changes](stu3_ballot_changes.md)
* [Technical Background](technical_background.md)

## Resources

### CodeSystems

* [SDOHCC CodeSystem Temporary Codes](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md)

### ValueSets

* [SDOHCC ValueSet Capacity Status](ValueSet-SDOHCC-ValueSetCapacityStatus.md)
* [SDOHCC ValueSet Program Enrollment Category](ValueSet-SDOHCC-ValueSetEnrollmentCategory.md)
* [SDOHCC ValueSet Program Enrollment Status](ValueSet-SDOHCC-ValueSetEnrollmentStatus.md)
* [SDOHCC ValueSet Healthcare Service Type](ValueSet-SDOHCC-ValueSetHealthcareServiceType.md)
* [SDOHCC ValueSet LOINC SNOMEDCT](ValueSet-SDOHCC-ValueSetLOINCSNOMEDCT.md)
* [SDOHCC ValueSet OMB Ethnicity Categories](ValueSet-SDOHCC-ValueSetOMBEthnicityCategories.md)
* [SDOHCC ValueSet OMB Race Categories](ValueSet-SDOHCC-ValueSetOMBRaceCategories.md)
* [SDOHCC ValueSet Observation DataAbsentReason](ValueSet-SDOHCC-ValueSetObservationDataAbsentReason.md)
* [SDOHCC ValueSet Observation DerivedFrom IdType](ValueSet-SDOHCC-ValueSetObservationDerivedFromIdType.md)
* [SDOHCC ValueSet Observation Method](ValueSet-SDOHCC-ValueSetObservationMethod.md)
* [SDOHCC ValueSet Observation Status](ValueSet-SDOHCC-ValueSetObservationStatus.md)
* [SDOHCC ValueSet Pronouns Value](ValueSet-SDOHCC-ValueSetPronounsValue.md)
* [SDOHCC ValueSet Referral Task Status](ValueSet-SDOHCC-ValueSetReferralTaskStatus.md)
* [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md)
* [SDOHCC ValueSet SDOH Questionnaire Category](ValueSet-SDOHCC-ValueSetSDOHQuestionnaireCategory.md)
* [SDOHCC ValueSet Service Category](ValueSet-SDOHCC-ValueSetServiceCategory.md)
* [SDOHCC ValueSet Task Code](ValueSet-SDOHCC-ValueSetTaskCode.md)
* [SDOHCC ValueSet Task Priority](ValueSet-SDOHCC-ValueSetTaskPriority.md)
* [SDOHCC ValueSet Task Status](ValueSet-SDOHCC-ValueSetTaskStatus.md)

### Resource Profiles

* [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md)
* [SDOHCC Consent](StructureDefinition-SDOHCC-Consent.md)
* [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md)
* [SDOHCC Group](StructureDefinition-SDOHCC-Group.md)
* [SDOHCC Healthcare Service](StructureDefinition-SDOHCC-HealthcareService.md)
* [SDOHCC Healthcare Service for Referral Management](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md)
* [SDOHCC Location](StructureDefinition-SDOHCC-Location.md)
* [SDOHCC Observation Assessment](StructureDefinition-SDOHCC-ObservationAssessment.md)
* [SDOHCC Observation Ethnicity OMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md)
* [SDOHCC Observation Gender Identity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md)
* [SDOHCC Observation Personal Characteristic](StructureDefinition-SDOHCC-ObservationPersonalCharacteristic.md)
* [SDOHCC Observation Personal Pronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md)
* [SDOHCC Observation Program Enrollment Status](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md)
* [SDOHCC Observation Race OMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md)
* [SDOHCC Observation Recorded Sex Gender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md)
* [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)
* [SDOHCC Observation Sexual Orientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md)
* [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md)
* [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)
* [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md)
* [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* [SDOHCC PractitionerRole](StructureDefinition-SDOHCC-practitionerrole.md)

### Extensions

* [SDOHCC Extension Condition Asserter](StructureDefinition-SDOHCC-ExtensionConditionAsserter.md)
* [SDOHCC Extension HealthcareService Capacity Status](StructureDefinition-SDOHCC-ExtensionHealthcareServiceCapacityStatus.md)
* [SDOHCC Extension HealthcareService Telecom Appointment](StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.md)

### CapabilityStatements

* [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md)
* [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md)
* [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md)
* [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md)
* [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

### ImplementationGuides

* [SDOH Clinical Care](ImplementationGuide-hl7.fhir.us.sdoh-clinicalcare.md)

### SearchParameters

* [ServiceRequestSupportingInfo](SearchParameter-ServiceRequest-supporting-info.md)
* [TaskOutputReference](SearchParameter-Task-output-reference.md)

### StructureMaps

* [SDOHCCHungerVitalSignMap](StructureMap-SDOHCC-StructureMapHungerVitalSign.md)
* [SDOHCCPRAPAREMap](StructureMap-SDOHCC-StructureMapPRAPARE.md)

### Examples

* [SDOHCC-ConditionAsserterDeviceExample (Condition)](Condition-SDOHCC-ConditionAsserterDeviceExample.md)
* [SDOHCC-ConditionFoodInsecurityExample (Condition)](Condition-SDOHCC-ConditionFoodInsecurityExample.md)
* [SDOHCC-ConditionHomelessExample (Condition)](Condition-SDOHCC-ConditionHomelessExample.md)
* [SDOHCC-ConditionProtectiveFactor (Condition)](Condition-SDOHCC-ConditionProtectiveFactor.md)
* [SDOHCC-ConditionUnemployedExample (Condition)](Condition-SDOHCC-ConditionUnemployedExample.md)
* [SDOHCC-ConsentInformationDisclosureExample (Consent)](Consent-SDOHCC-ConsentInformationDisclosureExample.md)
* [SDOHCC-DeviceSoftwareExample (Device)](Device-SDOHCC-DeviceSoftwareExample.md)
* [DocumentReferenceExample (DocumentReference)](DocumentReference-DocumentReferenceExample.md)
* [SDOHCC-GoalFoodSecurityExample (Goal)](Goal-SDOHCC-GoalFoodSecurityExample.md)
* [CDE payer's SDOH condition patients (Group)](Group-SDOHCC-GroupSDOHPatientsForPayerExample.md)
* [HACC (HealthcareService)](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md)
* [Family Counseling Services (HealthcareService)](HealthcareService-SDOHCC-HealthcareServiceTelecomAppointmentExample.md)
* [SDOHCC-ImmunizationChildhoodImmunizationsExample (Immunization)](Immunization-SDOHCC-ImmunizationChildhoodImmunizationsExample.md)
* [Family Counseling Services Deerland Clinic (Location)](Location-SDOHCC-LocationExample.md)
* [SDOHCC-LabObservationLeadLevelExample (Observation)](Observation-SDOHCC-LabObservationLeadLevelExample.md)
* [SDOHCC-ObservationAssessmentInadequateFoodIntakeExample (Observation)](Observation-SDOHCC-ObservationAssessmentInadequateFoodIntakeExample.md)
* [SDOHCC-ObservationAssessmentTransportTooExpensiveExample (Observation)](Observation-SDOHCC-ObservationAssessmentTransportTooExpensiveExample.md)
* [SDOHCC-ObservationEnrollmentStatusExample (Observation)](Observation-SDOHCC-ObservationEnrollmentStatusExample.md)
* [SDOHCC-ObservationEthnicityOMBExample (Observation)](Observation-SDOHCC-ObservationEthnicityOMBExample.md)
* [SDOHCC-ObservationGenderIdentityExample (Observation)](Observation-SDOHCC-ObservationGenderIdentityExample.md)
* [SDOHCC-ObservationPersonalPronounsExample (Observation)](Observation-SDOHCC-ObservationPersonalPronounsExample.md)
* [SDOHCC-ObservationRaceOMBExample (Observation)](Observation-SDOHCC-ObservationRaceOMBExample.md)
* [SDOHCC-ObservationRaceOMBMotherExample (Observation)](Observation-SDOHCC-ObservationRaceOMBMotherExample.md)
* [SDOHCC-ObservationRaceOMBPractitionerExample (Observation)](Observation-SDOHCC-ObservationRaceOMBPractitionerExample.md)
* [SDOHCC-ObservationRecordedSexGenderExample (Observation)](Observation-SDOHCC-ObservationRecordedSexGenderExample.md)
* [SDOHCC-ObservationResponseHungerVitalSignQuestion3Example (Observation)](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md)
* [SDOHCC-ObservationResponseNHANESGroupingExample (Observation)](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md)
* [SDOHCC-ObservationResponseNHANESQuestion1Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md)
* [SDOHCC-ObservationResponseNHANESQuestion2Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md)
* [SDOHCC-ObservationResponseNHANESQuestion3Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md)
* [SDOHCC-ObservationResponseNHANESQuestion4Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md)
* [SDOHCC-ObservationResponseNHANESQuestion5Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md)
* [SDOHCC-ObservationResponseNHANESQuestion6Example (Observation)](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md)
* [SDOHCC-ObservationResponsePRAPAREChildCareNeedExample (Observation)](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md)
* [SDOHCC-ObservationResponsePRAPAREClothingNeedExample (Observation)](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md)
* [SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample (Observation)](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md)
* [SDOHCC-ObservationResponsePRAPAREHousingStatusExample (Observation)](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md)
* [SDOHCC-ObservationSexualOrientationExample (Observation)](Observation-SDOHCC-ObservationSexualOrientationExample.md)
* [SDOHCC-VitalSignsHeightExample (Observation)](Observation-SDOHCC-VitalSignsHeightExample.md)
* [SDOHCC-VitalSignsWeightExample (Observation)](Observation-SDOHCC-VitalSignsWeightExample.md)
* [Better Health Clinic (Organization)](Organization-SDOHCC-OrganizationClinicExample.md)
* [ABC Coordination Platform (Organization)](Organization-SDOHCC-OrganizationCoordinationPlatformExample.md)
* [CDE Payer (Organization)](Organization-SDOHCC-OrganizationPayerExample.md)
* [Special Supplemental Nutrition Program for Women, Infants and Children (WIC) Office (Organization)](Organization-SDOHCC-OrganizationWICCommunityOrganizationExample.md)
* [SDOHCC-PatientBabyAbbas (Patient)](Patient-SDOHCC-PatientBabyAbbas.md)
* [pat-53234 (Patient)](Patient-pat-53234.md)
* [SDOHCC-PractitionerDrJanWaterExample (Practitioner)](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)
* [SDOHCC-PractitionerPatWilliamsMSWExample (Practitioner)](Practitioner-SDOHCC-PractitionerPatWilliamsMSWExample.md)
* [SDOHCC-PractitionerRoleDrJanWaterExample (PractitionerRole)](PractitionerRole-SDOHCC-PractitionerRoleDrJanWaterExample.md)
* [SDOHCC-ProcedureFoodPantryApplicationAssistanceExample (Procedure)](Procedure-SDOHCC-ProcedureFoodPantryApplicationAssistanceExample.md)
* [SDOHCC-ProcedureProvisionOfFoodExample (Procedure)](Procedure-SDOHCC-ProcedureProvisionOfFoodExample.md)
* [SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample (Procedure)](Procedure-SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample.md)
* [SDOHCC Questionnaire Hunger Vital Sign (Questionnaire)](Questionnaire-SDOHCC-QuestionnaireHungerVitalSign.md)
* [SDOHCC Questionnaire PRAPARE (Questionnaire)](Questionnaire-SDOHCC-QuestionnairePRAPARE.md)
* [SDOHCC-QuestionnaireResponseHungerVitalSignExample (QuestionnaireResponse)](QuestionnaireResponse-SDOHCC-QuestionnaireResponseHungerVitalSignExample.md)
* [SDOHCC-QuestionnaireResponsePRAPAREExample (QuestionnaireResponse)](QuestionnaireResponse-SDOHCC-QuestionnaireResponsePRAPAREExample.md)
* [SDOHCC-RelatedPersonMotherExample (RelatedPerson)](RelatedPerson-SDOHCC-RelatedPersonMotherExample.md)
* [SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample (ServiceRequest)](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md)
* [SDOHCC-ServiceRequestActiveWICReferralExample (ServiceRequest)](ServiceRequest-SDOHCC-ServiceRequestActiveWICReferralExample.md)
* [SDOHCC-ServiceRequestSubreferralGardenProgramExample (ServiceRequest)](ServiceRequest-SDOHCC-ServiceRequestSubreferralGardenProgramExample.md)
* [SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample (ServiceRequest)](ServiceRequest-SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample.md)
* [SDOHCC-TaskContentRichReferralWICExample (Task)](Task-SDOHCC-TaskContentRichReferralWICExample.md)
* [SDOHCC-TaskPatientInformationRequestCompletedExample (Task)](Task-SDOHCC-TaskPatientInformationRequestCompletedExample.md)
* [SDOHCC-TaskPatientMakeAppointmentCompletedExample (Task)](Task-SDOHCC-TaskPatientMakeAppointmentCompletedExample.md)
* [SDOHCC-TaskPatientReviewInformationCompletedExample (Task)](Task-SDOHCC-TaskPatientReviewInformationCompletedExample.md)
* [SDOHCC-TaskPatientRiskQuestionnaireCompletedExample (Task)](Task-SDOHCC-TaskPatientRiskQuestionnaireCompletedExample.md)
* [SDOHCC-TaskReferralForFurtherAssessmentExample (Task)](Task-SDOHCC-TaskReferralForFurtherAssessmentExample.md)
* [SDOHCC-TaskReferralManagementOrderFulfillmentAcceptedExample (Task)](Task-SDOHCC-TaskReferralManagementOrderFulfillmentAcceptedExample.md)
* [SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample (Task)](Task-SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample.md)
* [SDOHCC-TaskReferralManagementOrderSubtaskAcceptedExample (Task)](Task-SDOHCC-TaskReferralManagementOrderSubtaskAcceptedExample.md)
* [SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample (Task)](Task-SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample.md)
