# IG Home - SDOH Clinical Care v3.0.0-ballot

## IG Home

**NOTE: WE ARE ACTIVELY SEEKING FEEDBACK ON THE FHIR STRUCTURES AND NARRATIVE GUIDANCE SURROUNDING ALL OF OUR NEW ARTIFACTS, PARTICULARLY AROUND THE CAPACITY STATUS ([FHIR-53450](https://jira.hl7.org/browse/FHIR-53450)) AND ENROLLMENT STATUS ([FHIR-53446](https://jira.hl7.org/browse/FHIR-53446)) USE CASES. WE ENCOURAGE READERS TO REVIEW THE PROPOSED CHANGES AND SUBMIT BALLOT COMMENTS AGAINST THEM.**

The Gravity Project team has drafted a new STU3 version of the IG for balloters to review and submit feedback. Below are the requirements that we have worked through for this ballot and the associated updates to the IG:

* Capacity Status
* Enrollment Status
* Self-Referral
* Referral for Further Assessment
* Content-Rich Referral
* Protective Factors
* Personal Characteristics

### Overview

Social determinants of health (SDOH) are the conditions in the environments where people are born, live, learn, work, play, worship, and age that affect a wide range of health, functioning, and quality-of-life outcomes and risks[1](#fn:1). They are increasingly being recognized as essential factors that influence healthcare outcomes. This HL7 Implementation Guide (IG) defines how to exchange coded content using the HL7 FHIR Standard for the following SDOH-focused care activities: screening, clinical assessment/diagnosis, goal setting, and the planning and performing of interventions. This IG addresses the need to gather SDOH information in multiple settings, share that information between stakeholders, and exchange referrals between organizations to address specific social risks and needs, all with appropriate patient consent. In addition, the IG demonstrates how to share clinical data to support secondary purposes such as population health, quality, and research.

This IG was developed by the [Gravity Project](https://confluence.hl7.org/display/GRAV/The+Gravity+Project), which aims to build and promulgate consensus-driven social determinants of health (SDOH) data standards for health and social care interoperability and use among multiple stakeholders. The project and this implementation guide are focused on the U.S. environment. This IG leverages content from the [US Core Implementation Guide](http://hl7.org/fhir/us/core/STU7/index.html) and binds to US-specific terminology. However, the basic constructs and interaction patterns may well be applicable outside the U.S.

The IG supports the following use cases:

* Documenting SDOH data in conjunction with patient encounters with providers, payers, and community services
* Referring patients to address SDOH needs via an electronic workflow. The referral framework includes support for intermediary organizations to manage service delivery, closed loop feedback to the ordering provider and direct engagement with the patient and their caregivers.
* Identifying cohorts of individuals that have a common relationship to another entity (e.g., covered by the same payer)

**Figure 1: Conceptual Framework for SDOH Clinical Care**

This IG often refers to Community Based Organizations (CBOs) as synonymous with a referral target and clinicians as synonymous with the referring provider. There is nothing that prevents use of the IG for other referral sources and targets.

The activities supported by this IG include (see [Conceptual Framework](sdoh_clinical_care_scope.md) for more details)

* Screening: This refers to activities where social risk data from individuals are initially captured, whether through a self-administered, provider-administered, or health plan-administered questionnaire. These activities may also be repeated at certain intervals to monitor changes in social risks.
* Assessment/Diagnosis: These include activities where providers (clinical and community-based) and health plans analyze the data obtained through screening and interaction with the individual to determine their social risks and needs.
* Interventions: These refer to actions undertaken by providers (clinical and community-based) and health plans to help address identified social risks and needs. These include referrals, case management, care planning, counseling and education, and provision of services and orders.

Currently, this IG is intended to support Patient Applications, Provider's Electronic Health Record (EHR) systems, Coordination Platforms that intermediate between Providers, and Community Based Organizations that provide SDOH services. In the future payer systems and governmental systems will be supported. The IG establishes a framework for SDOH-related interventions including:

* capture of data from validated assessment instruments
* mapping the responses from assessments to observations, conditions, and goals using SDOH-specific value sets using established standards (see [Assessment Instrument Support](assessment_instrument_support.md#using-structuremap-to-generate-observations-or-conditions-from-questionnaireresponse))
* generating and monitoring referrals from providers and care coordinators for SDOH-related services provided by CBOs
* capturing the results of the referrals as procedures

### Dependencies

| | | |
| :--- | :--- | :--- |
| [Da Vinci Health Record Exchange (HRex)](http://hl7.org/fhir/us/davinci-hrex/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.us.davinci-hrex/1.1.0) | This guide links out to concept maps published in Da Vinci HRex for Provider Role codes. |
| [FHIR Extensions Pack](http://hl7.org/fhir/extensions/5.2.0) | [5.2.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.2.0) | Automatically added as a dependency - all IGs depend on the HL7 Extension Pack |
| [5.1.0](https://simplifier.net/packages/hl7.fhir.uv.extensions.r4/5.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [FHIR R4 package : Core](http://hl7.org/fhir/R4) | [4.0.1](https://simplifier.net/packages/hl7.fhir.r4.core/4.0.1) | Imported by FHIR Extensions Pack (and potentially others) |
| [HL7 Terminology (THO)](http://terminology.hl7.org/5.5.0) | [7.0.0](https://simplifier.net/packages/hl7.terminology.r4/7.0.0) |  |
| [6.1.0](https://simplifier.net/packages/hl7.terminology.r4/6.1.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [5.5.0](https://simplifier.net/packages/hl7.terminology.r4/5.5.0) | Imported by US Core (and potentially others) | |
| [5.0.0](https://simplifier.net/packages/hl7.terminology.r4/5.0.0) | Imported by Subscriptions R5 Backport (and potentially others) | |
| [Public Health Information Network Vocabulary Access and Distribution System (PHIN VADS)](http://fhir.org/packages/us.cdc.phinvads) | [0.12.0](https://simplifier.net/packages/us.cdc.phinvads/0.12.0) | Imported by US Core (and potentially others) |
| [SMART App Launch](http://hl7.org/fhir/smart-app-launch/STU2) | [2.0.0](https://simplifier.net/packages/hl7.fhir.uv.smart-app-launch/2.0.0) | Imported by US Core (and potentially others) |
| [Structured Data Capture](http://hl7.org/fhir/uv/sdc/STU3) | [3.0.0](https://simplifier.net/packages/hl7.fhir.uv.sdc/3.0.0) | SDC is the basis for mapping QuestionnaireResponses to Observations and Conditions. SDC also provides guidance around how questionnaires can be created with support for score calculation, conditional behavior, specific rendering expectations, etc. |
| [Subscriptions R5 Backport](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1) | [1.1.0](https://simplifier.net/packages/hl7.fhir.uv.subscriptions-backport.r4/1.1.0) | Subscriptions are recommended for monitoring completion of referrals. |
| [US Core](http://hl7.org/fhir/us/core/STU7) | [7.0.0](https://simplifier.net/packages/hl7.fhir.us.core/7.0.0) | All profiles in this IG are aligned with US Core 7.0.0. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations. |
| [6.1.0](https://simplifier.net/packages/hl7.fhir.us.core/6.1.0) | All profiles in this IG are aligned with US Core 6.1.0 as much as possible. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations. | |
| [3.1.1](https://simplifier.net/packages/hl7.fhir.us.core/3.1.1) | All profiles in this IG are aligned with US Core 3.1.1 as much as possible. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations. | |
| [Value Set Authority Center (VSAC)](http://fhir.org/packages/us.nlm.vsac) | [0.24.0](https://simplifier.net/packages/us.nlm.vsac/0.24.0) | Gravity Project social risk data elements are published in Value Set Authority Center (VSAC) value sets. The value sets can be identified by searching for "The Gravity Project" steward. You will need to create a free National Library of Medicine (NLM) account to access the value sets. Value sets will be updated bi-annually on June 30th and December 31st. |
| [0.19.0](https://simplifier.net/packages/us.nlm.vsac/0.19.0) | Imported by Da Vinci Health Record Exchange (HRex) (and potentially others) | |
| [0.18.0](https://simplifier.net/packages/us.nlm.vsac/0.18.0) | Imported by US Core (and potentially others) | |

The Gravity SDOH Clinical Care IG is dependent on the [US Core 3.1.1 (FHIR R4)](http://hl7.org/fhir/us/core/STU3.1.1), [US Core 6.1.0 (FHIR R4)](http://hl7.org/fhir/us/core/STU6.1) and [US Core 7.0.0 (FHIR R4)](http://hl7.org/fhir/us/core/STU7) implementation guides. US Core 3.1.1 is supported for those systems limited to [United States Core Data for Interoperability (USCDI) v1](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi) capabilities. US Core 6.1.0 is for upcoming regulatory requirements mandating support fo [USCDI v3](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v3). US Core 7.0.0 is to enable support for proposed regulations mandating support for [USCDI v4](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v4). The SDOHCC profiles can be used to create instances that are valid with all three US Core releases.

### Relationships to Other IGs

| | |
| :--- | :--- |
| [Bidirectional Service eReferral (BSeR)](http://hl7.org/fhir/us/bser/) | Whereas this IG orchestrates referrals using the FHIR query interface, BSeR bases referral management on the exchange of self-contained Bundles of FHIR resources. Gravity is working with BSeR to align referral approaches. |
| [Clinical Documentation Exchange (CDex)](http://hl7.org/fhir/us/davinci-cdex) | Allows payers to retrieve or solicit records from an EHR related to patients covered under their plans. May be used to allow payers retrieving SDOH-related information for quality measures or in support of contractual or other payment schemes. |
| [Data Exchange for Quality Measures Implementation Guide](https://hl7.org/fhir/us/davinci-deqm/) | SDOH-related services will inevitably be included in quality measurement programs |
| [DaVinci Prior Authorization Support](http://hl7.org/fhir/us/davinci-pas/)(PAS) | Together with CRD and DTR, these three IGs (collectively known as the Da Vinci Burden Reduction IGs) provide support for prior authorization and other documentation capture and could be relevant for SDOH-related services. |
| [DaVinci Coverage Requirements Discovery](http://hl7.org/fhir/us/davinci-crd/)(CRD) | Together with PAS and DTR, these three IGs (collectively known as the Da Vinci Burden Reduction IGs) provide support for prior authorization and other documentation capture and could be relevant for SDOH-related services. |
| [DaVinci Documentation Templates and Rules](http://hl7.org/fhir/us/davinci-dtr/)(DTR) | Together with PAS and CRD, these three IGs (collectively known as the Da Vinci Burden Reduction IGs) provide support for prior authorization and other documentation capture and could be relevant for SDOH-related services. |
| [Human Services Directory](https://hl7.org/fhir/us/hsds/FHIR-IG-Human-Services-Directory) | Can be used by a provider to identify referral targets for SDOH-related services |
| [IHE FHIR Audit Event Query and Feed to ATNA](https://wiki.ihe.net/index.php/Audit_Trail_and_Node_Authentication) | For systems wishing to maintain robust audit records of changes and access to patient records (always a good idea), this IG defines standards for using FHIR to do so. (Note that this standard is only really relevant if there's a need for electronic sharing of audit records.) |
| [National Healthcare Directory Exchange](https://hl7.org/fhir/us/ndh/2023Sep/) | A U.S. Office of the National Coordinator-sponsored IG supporting the exchange of directory information for a wide range of service providers and organizations |
| [PACIO Cognitive Status](http://hl7.org/fhir/us/pacio-cs) | Defines standards for sharing information about a patient's cognitive capabilities and limitations, which may influence decisions about appropriate SDOH interventions. |
| [PACIO Functional Status](http://hl7.org/fhir/us/pacio-fs) | Defines standards for sharing information about a patient's physical capabilities, which may influence decisions about appropriate SDOH interventions (e.g. with respect to transport). |
| [Patient Contributed Data](http://www.hl7.org/documentcenter/public/ballots/2022SEP/downloads/HL7_PCD_R1_I1_2022SEP.pdf) | Defines guidance for incorporation of patient and caregiver-collected information into clinical records. |
| [Physical Activity](https://hl7.org/fhir/us/physical-activity/) | This IG inherits functionality from the SDOH IG and uses a similar architectural approach to manage sharing of physical activity goals, referrals, and patient engagement. |
| [Quality Measure Implementation Guide](http://hl7.org/fhir/us/cqfmeasures) | Defines standards for sharing clinical quality measures electronically, allowing defining and sharing measures related to SDOH evaluation and interventions. |
| [SmartApp Launch](http://hl7.org/fhir/smart-app-launch) | Allows launching third party applications in the context of another system, including allowing the application to controlled access to patient information. |

### How to Read this IG

This IG contains a wealth of material targeting different audiences. Some sections provide more general or introductory content, while others provide detailed technical information targeted at implementors. The table below provides a listing of the key sections of the IG in the rough order that they should be read.

| | | | |
| :--- | :--- | :--- | :--- |
| Background | [SDOH and the Gravity Project](sdoh_challenges_gravity.md) | General background on the importance of collecting and standardizing social risk data, and the Gravity Project | General |
| Background | [SDOH Clinical Care Background](sdoh_clinical_care_scope.md) | A description of the clinical scope of this IG | General |
| Background | [Technical Background](technical_background.md) | Background material that should be understood prior to attempting to understand this IG | General/Introductory |
| Implementation Guidance | [Assessment Instrument Support](assessment_instrument_support.md) | A description of the importance of standard assessment instruments for the collection of social risk data, and how assessment instruments are mapped to SDOH Conditions, Observations and Goals | General |
| Implementation Guidance | [Referral Workflow](referral_workflow.md) | Provides a high-level description of the referral workflows and patient interactions supported by this IG, and then drills down to a detailed description of the FHIR API calls implementing the referral workflow | Introductory and Detailed Technical |
| Implementation Guidance | [Connecting Applications with API Data Sources](connecting_applications_with_api_data_sources.md) | Provides a description of establishing connections to enable the exchange of information supporting the[Referral Workflow](referral_workflow.md). | Detailed Technical |
| Specifications | [FHIR Artifacts](artifacts.md) | An index of the FHIR artifacts defined as part of this implementation guide | Detailed Technical |
| Specifications | [Must Support and Missing Data](mustsupport_and_missing_data.md) | Conformance requirements for must support and missing data | Detailed Technical |
| Specifications | [Privacy and Security](privacy_and_security.md) | Conformance requirements for privacy and security considerations | Detailed Technical |
| Specifications | [Specifications for Personal Characteristics](specifications_for_personal_characteristics.md) | Observation profiles supporting Personal Characteristics | Detailed Technical |
| Specifications | [Downloads](downloads.md) | Downloads | Detailed Technical |

### Key Technical Content of this IG

* [CapabilityStatements](artifacts.md#behavior-capability-statements): CapabilityStatements formally define the different types of systems that can comply with this implementation guide and set conformance expectations around what resources and behaviors they must support. This IG provides capability statements for Patient applications, referral sources and recipients, and coordination platform intermediaries.
* [Profiles](artifacts.md#structures-resource-profiles): Profiles describe constraints and extensions on resources and data types to reflect the requirements of the use cases in an implementation guide This IG provides Observation, Condition, Procedure, ServiceRequest, Task, Goal, Group, HealthcareService, Consent, and Location profiles. In addition, this implementation guide uses (and in some cases further profiles) profiles defined in US Core.
* [Value Sets](artifacts.md#terminology-value-sets): FHIR value sets specify a set of codes drawn from one or more code systems, intended for use in a particular context. The Gravity Project has worked intensively to develop value sets for SDOH-related content. This content is described where it is used. See the following profiles: [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md), [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md), [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md).
* [Examples](artifacts.md#example-example-instances): This IG provides contextually relevant examples of all profiles.
* [Referral Workflow](referral_workflow.md): The management of referrals by providers to community-based organizations with different levels of FHIR capability and the assignment of tasks to Patients is described in detail.
* [Specifications for Personal Characteristics](specifications_for_personal_characteristics.md): These profiles are included to test and promote their use and possible future incorporation into [US Core](http://hl7.org/fhir/us/core/STU7/index.html).

-------

1. [Healthy People 2030](https://health.gov/healthypeople/priority-areas/social-determinants-health) [↩](#fnref:1)

