# SDOHCC ValueSet Observation Method - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet Observation Method 

 
Codes that represent methods by which an individual's race or ethnicity information can be elicited. 

 **References** 

* [SDOHCC Observation Ethnicity OMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md)
* [SDOHCC Observation Gender Identity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md)
* [SDOHCC Observation Personal Pronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md)
* [SDOHCC Observation Race OMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md)
* [SDOHCC Observation Recorded Sex Gender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md)
* [SDOHCC Observation Sexual Orientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetObservationMethod",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationMethod",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetObservationMethod",
  "title" : "SDOHCC ValueSet Observation Method",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-12-14T04:01:34+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes that represent methods by which an individual's race or ethnicity information can be elicited.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "concept" : [
          {
            "code" : "self-reported",
            "display" : "Self Reported"
          },
          {
            "code" : "reported-by-related-person",
            "display" : "Reported By Related Person"
          },
          {
            "code" : "administrative",
            "display" : "Administrative"
          },
          {
            "code" : "derived-specify",
            "display" : "Derived Specify"
          },
          {
            "code" : "other-specify",
            "display" : "Other Specify"
          },
          {
            "code" : "observed",
            "display" : "Observed"
          }
        ]
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
        "version" : "3.0.0",
        "concept" : [
          {
            "code" : "UNK",
            "display" : "unknown"
          }
        ]
      }
    ]
  }
}

```
