# SDOHCC ValueSet OMB Race Categories - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet OMB Race Categories 

 
Codes for the five race categories - 'American Indian' or 'Alaska Native','Asian', 'Black or African American', 'Native Hawaiian or Other Pacific Islander', and 'White' - as defined by the[OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf). This value set was created (as opposed to using the US Core OMB Race Categories value set) to deliberately prevent inclusion of null flavors. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetOMBRaceCategories",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetOMBRaceCategories",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetOMBRaceCategories",
  "title" : "SDOHCC ValueSet OMB Race Categories",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the five race categories - 'American Indian' or 'Alaska Native','Asian', 'Black or African American', 'Native Hawaiian or Other Pacific Islander', and 'White' - as defined by the [OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf). This value set was created (as opposed to using the US Core OMB Race Categories value set) to deliberately prevent inclusion of null flavors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "urn:oid:2.16.840.1.113883.6.238",
        "version" : "3.1.1",
        "concept" : [
          {
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          },
          {
            "code" : "2028-9",
            "display" : "Asian"
          },
          {
            "code" : "2054-5",
            "display" : "Black or African American"
          },
          {
            "code" : "2076-8",
            "display" : "Native Hawaiian or Other Pacific Islander"
          },
          {
            "code" : "2106-3",
            "display" : "White"
          }
        ]
      }
    ]
  }
}

```
