# SDOHCC Task For Referral For Further Assessment Example - SDOH Clinical Care v3.0.0-ballot

## Example Task: SDOHCC Task For Referral For Further Assessment Example

Language: en

Profile: [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)

**status**: Completed

**intent**: order

**code**: Fulfill the focal request

**focus**: [ServiceRequest Assistance with application for food pantry program](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md)

**for**: [COLIN ABBAS](Patient-pat-53234.md)

**authoredOn**: 2020-10-15 10:30:00+0000

**requester**: [Dr Jan Water Family Medicine Physician](PractitionerRole-SDOHCC-PractitionerRoleDrJanWaterExample.md)

**owner**: [HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md)

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Additional Content | [Food Insecurity Condition](Condition-SDOHCC-ConditionFoodInsecurityExample.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "SDOHCC-TaskReferralForFurtherAssessmentExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill",
        "display" : "Fulfill the focal request"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample"
  },
  "for" : {
    "reference" : "Patient/pat-53234",
    "display" : "COLIN ABBAS"
  },
  "authoredOn" : "2020-10-15T10:30:00.000Z",
  "requester" : {
    "reference" : "PractitionerRole/SDOHCC-PractitionerRoleDrJanWaterExample",
    "display" : "Dr Jan Water Family Medicine Physician"
  },
  "owner" : {
    "reference" : "HealthcareService/SDOHCC-HealthcareServiceSocialCareProgram",
    "display" : "HACC"
  },
  "output" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "additional-content"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample",
        "display" : "Food Insecurity Condition"
      }
    }
  ]
}

```
