# SDOHCC Task Patient Make Appointment Completed Example - SDOH Clinical Care v3.0.0-ballot

## Example Task: SDOHCC Task Patient Make Appointment Completed Example

Language: en

Profile: [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md)

**status**: Completed

**intent**: order

**priority**: Routine

**code**: Make Contact

**description**: Please contact the clinic to schedule your appointment

**for**: [COLIN ABBAS](Patient-pat-53234.md)

**authoredOn**: 2020-09-12 21:56:54+0000

**requester**: [Organization Better Health Clinic](Organization-SDOHCC-OrganizationClinicExample.md)

**owner**: [COLIN ABBAS](Patient-pat-53234.md)

### Inputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Contact Entity | [HealthcareService Family Counseling Services](HealthcareService-SDOHCC-HealthcareServiceTelecomAppointmentExample.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "SDOHCC-TaskPatientMakeAppointmentCompletedExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "intent" : "order",
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "make-contact",
        "display" : "Make Contact"
      }
    ]
  },
  "description" : "Please contact the clinic to schedule your appointment",
  "for" : {
    "reference" : "Patient/pat-53234",
    "display" : "COLIN ABBAS"
  },
  "authoredOn" : "2020-09-12T21:56:54.671Z",
  "requester" : {
    "reference" : "Organization/SDOHCC-OrganizationClinicExample"
  },
  "owner" : {
    "reference" : "Patient/pat-53234",
    "display" : "COLIN ABBAS"
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "contact-entity",
            "display" : "Contact Entity"
          }
        ]
      },
      "valueReference" : {
        "reference" : "HealthcareService/SDOHCC-HealthcareServiceTelecomAppointmentExample"
      }
    }
  ]
}

```
