# SDOHCCHungerVitalSignMap - SDOH Clinical Care v3.0.0-ballot

## StructureMap: SDOHCCHungerVitalSignMap 

 
A StructureMap instance that represents the resource that transforms a specific question and answer from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9) into a corresponding Observation (SDOHCC Observation response Hunger Vital Sign Q3 Example) and derived Condition (SDOHCC Condition Food Insecurity Example) 

```
/// name = "SDOHCCHungerVitalSignMap"
/// status = draft
/// title = "SDOHCC StructureMap HungerVitalSign"
/// description = "A StructureMap instance that represents the resource that transforms a specific question and answer from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9) into a corresponding Observation (SDOHCC Observation response Hunger Vital Sign Q3 Example) and derived Condition (SDOHCC Condition Food Insecurity Example)."

map "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureMap/SDOHCC-StructureMapHungerVitalSign" = "SDOHCCHungerVitalSignMap"

uses "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse" alias questionnaireResponse as source
uses "http://hl7.org/fhir/StructureDefinition/Bundle" alias bundle as target
uses "http://hl7.org/fhir/StructureDefinition/Observation" alias observation as target
uses "http://hl7.org/fhir/StructureDefinition/Condition" alias sdohccCondition as target
uses "http://hl7.org/fhir/StructureDefinition/Observation" alias sdohccObservation as target

group sdohMapping(source src : questionnaireResponse, target bundle : Bundle) {
  //temporarily set id to human-readable id as example
  //src -> bundle.id = uuid();
  src -> bundle.id = 'SDOHCC-BundleHungerVitalSignExample' "bundleId";
  src -> bundle.type = 'transaction' "bundleType";

  //for each 'key' answer item in the questionnaireResponse, create an Observation
  src.item as answerItem3 where linkId = '/88124-3' -> bundle.entry as entry, entry.resource = create('Observation') as observation3 then 
    TransformObservation(src, answerItem3, observation3, entry); 

  //create condition if answer to third question is "At Risk"
  src.item as answerItem4 where linkId = '/88124-3' and answer.value.code ='LA19952-3' -> bundle.entry as entry, entry.resource = create('Condition') as condition then
    TransformCondition(src, bundle, condition, entry);
}

group TransformObservation(source src: questionnaireResponse, source answerItem, target observation: Observation, target entry)
{
  src -> entry.request as request then {
    src -> request.method = 'POST' "obsnRequestMethod";
    src -> request.url = 'Observation' "obsnRequestUrl";
  } "obsnEntryRequest";

  //temporarily set id to human-readable id as example
  //src -> observation.id = uuid() then
  //  SetObservationFullUrl(observation, entry);
  src -> observation.id = 'SDOHCC-ObservationResponseHungerVitalSignQuestion3Example' then
   	SetObservationFullUrl(observation, entry) "obsn3Id";

  src -> observation.meta = create('Meta') as newMeta then {
    src -> newMeta.profile = 'http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse' "obsnMetaProfile";
  } "obsnMeta";

  src -> observation.status = 'final' "obsnStatus";

  src -> observation.category = cc('http://terminology.hl7.org/CodeSystem/observation-category', 'social-history', 'Social History') "obsnCatSocialHist";
  src -> observation.category = cc('http://terminology.hl7.org/CodeSystem/observation-category', 'survey', 'Survey') "obsnCatSurvey";
  src -> observation.category = cc('http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes', 'food-insecurity', 'Food Insecurity') "obsnCatFoodInsecurity";  

  answerItem as i -> observation.code = cc('http://loinc.org', '88124-3') as code "obsn3Code";

  src.subject as qSubject -> observation.subject = create('Reference') as newReference then {
    qSubject.reference as qReference -> newReference.reference = qReference;
    qSubject.display as qDisplay -> newReference.display = qDisplay;
  };

  src.authored as authored -> observation.effective = authored, observation.issued = authored;

  answerItem.answer as answer -> observation.value = create('CodeableConcept') as newCC then {
    answer.value as coding -> newCC.coding = coding as newCoding;
  };

  src -> observation.derivedFrom = create('Reference') as newReference then {
    src.id as id -> newReference.reference = append('QuestionnaireResponse/', id);
  } "obsnDerivation";
}

group SetObservationFullUrl(source observation: Observation, target entry)
{
  observation.id as id -> entry.fullUrl = append('http://hl7.org/fhir/us/sdoh-clinicalcare/Observation/', id);
}

group TransformCondition(source src: QuestionnaireResponse, source bundle: Bundle, target condition: Condition, target entry)
{
  //temporarily set id to human-readable id as example
  //src -> condition.id = uuid() then
  src -> condition.id = 'SDOHCC-ConditionFoodInsecurityExample' then
    SetConditionFullUrl(condition, entry) "conditionId";
       
  src -> condition.meta = create('Meta') as newMeta then {
    src -> newMeta.profile = 'http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition' "conditionMetaProfile";
  } "conditionMeta";

  src -> condition.clinicalStatus = cc('http://terminology.hl7.org/CodeSystem/condition-clinical', 'active', 'Active') "conditionClinicalStatus";
  src -> condition.verificationStatus = cc('http://terminology.hl7.org/CodeSystem/condition-ver-status', 'unconfirmed', 'Unconfirmed') "conditionVeriStatus";
  src -> condition.category = create('CodeableConcept') as newCC then {
      src -> newCC.coding = create('Coding') as newCoding then {
        src -> newCoding.system = 'http://hl7.org/fhir/us/core/CodeSystem/condition-category' "conditionCatCodingSystemHealthConcern";
        src -> newCoding.code = 'health-concern' "conditionCatCodingCodeHealthConcern";
        src -> newCoding.display = 'Health Concern' "conditionCatCodingDisplayHealthConcern";
    } "conditionCatCodingHealthConcern";
  } "conditionCatHealthConcern";

  //Add sdoh category
  src -> condition.category = cc('http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes', 'food-insecurity', 'Food Insecurity') "conditionCatFoodInsecurity";

  src -> condition.code = create('CodeableConcept') as newCodeCC then {
      src -> newCodeCC.coding = create('Coding') as newCoding then {
        src -> newCoding.system = 'http://snomed.info/sct' "conditionCodeCodingSystemFoodInsecurity";
        src -> newCoding.code = '733423003' "conditionCodeCodingCodeFoodInsecurity";
        src -> newCoding.display = 'Food insecurity' "conditionCodeCodingDisplayFoodInsecurity";
    } "conditionCodeCodingFoodInsecurity";
    src -> newCodeCC.coding = create('Coding') as newCoding2 then {
        src -> newCoding2.system = 'http://hl7.org/fhir/sid/icd-10-cm' "conditionCodeCodingSystemLackOfFood";
        src -> newCoding2.code = 'Z59.4' "conditionCodeCodingCodeLackOfFood";
        src -> newCoding2.display = 'Lack of adequate food' "conditionCodeCodingDisplayLackOfFood";
    } "conditionCodeCodingLackOfFood";
  } "conditionCode";
      
  src.authored as authored -> condition.onset = create('Period') as period,
    period.start = authored;

  bundle.entry as entries -> condition.evidence as evidence, evidence.detail = create('Reference') as detailReference then {
  	entries.resource as obs3 where code.coding.code = '88124-3'-> detailReference.reference = reference(obs3); 
  };

  src.subject as qSubject -> condition.subject = create('Reference') as newReference then {
    qSubject.reference as qReference -> newReference.reference = qReference;
    qSubject.display as qDisplay -> newReference.display = qDisplay;
  };

  src -> entry.request as request then {
    src -> request.method = 'POST' "conditionRequestMethod";
    src -> request.url = 'Condition' "conditionRequestUrl";
  } "conditionEntryRequest";  
}

group SetConditionFullUrl(source condition: Condition, target entry)
{
  condition.id as id -> entry.fullUrl = append('http://hl7.org/fhir/us/sdoh-clinicalcare/Condition/', id);
}
```



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "SDOHCC-StructureMapHungerVitalSign",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureMap/SDOHCC-StructureMapHungerVitalSign",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCHungerVitalSignMap",
  "status" : "draft",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "A StructureMap instance that represents the resource that transforms a specific question and answer from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9) into a corresponding Observation (SDOHCC Observation response Hunger Vital Sign Q3 Example) and derived Condition (SDOHCC Condition Food Insecurity Example)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "structure" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
      "mode" : "source",
      "alias" : "questionnaireResponse"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Bundle",
      "mode" : "target",
      "alias" : "bundle"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "mode" : "target",
      "alias" : "observation"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Condition",
      "mode" : "target",
      "alias" : "sdohccCondition"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/Observation",
      "mode" : "target",
      "alias" : "sdohccObservation"
    }
  ],
  "group" : [
    {
      "name" : "sdohMapping",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "src",
          "type" : "questionnaireResponse",
          "mode" : "source"
        },
        {
          "name" : "bundle",
          "type" : "Bundle",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "bundleId",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "contextType" : "variable",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "SDOHCC-BundleHungerVitalSignExample"
                }
              ]
            }
          ]
        },
        {
          "name" : "bundleType",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "contextType" : "variable",
              "element" : "type",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "transaction"
                }
              ]
            }
          ]
        },
        {
          "name" : "item",
          "source" : [
            {
              "context" : "src",
              "element" : "item",
              "variable" : "answerItem3",
              "condition" : "linkId = '/88124-3'"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "contextType" : "variable",
              "element" : "entry",
              "variable" : "entry"
            },
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "resource",
              "variable" : "observation3",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Observation"
                }
              ]
            }
          ],
          "dependent" : [
            {
              "name" : "TransformObservation",
              "variable" : ["src", "answerItem3", "observation3", "entry"]
            }
          ]
        },
        {
          "name" : "item",
          "source" : [
            {
              "context" : "src",
              "element" : "item",
              "variable" : "answerItem4",
              "condition" : "(linkId = '/88124-3') and (answer.value.code = 'LA19952-3')"
            }
          ],
          "target" : [
            {
              "context" : "bundle",
              "contextType" : "variable",
              "element" : "entry",
              "variable" : "entry"
            },
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "resource",
              "variable" : "condition",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Condition"
                }
              ]
            }
          ],
          "dependent" : [
            {
              "name" : "TransformCondition",
              "variable" : ["src", "bundle", "condition", "entry"]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformObservation",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "src",
          "type" : "questionnaireResponse",
          "mode" : "source"
        },
        {
          "name" : "answerItem",
          "mode" : "source"
        },
        {
          "name" : "observation",
          "type" : "Observation",
          "mode" : "target"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "obsnEntryRequest",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "request",
              "variable" : "request"
            }
          ],
          "rule" : [
            {
              "name" : "obsnRequestMethod",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "contextType" : "variable",
                  "element" : "method",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "POST"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "obsnRequestUrl",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "contextType" : "variable",
                  "element" : "url",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Observation"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "obsn3Id",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "SDOHCC-ObservationResponseHungerVitalSignQuestion3Example"
                }
              ]
            }
          ],
          "dependent" : [
            {
              "name" : "SetObservationFullUrl",
              "variable" : ["observation", "entry"]
            }
          ]
        },
        {
          "name" : "obsnMeta",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "meta",
              "variable" : "newMeta",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Meta"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "obsnMetaProfile",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newMeta",
                  "contextType" : "variable",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "obsnStatus",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "status",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "final"
                }
              ]
            }
          ]
        },
        {
          "name" : "obsnCatSocialHist",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "category",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                },
                {
                  "valueString" : "social-history"
                },
                {
                  "valueString" : "Social History"
                }
              ]
            }
          ]
        },
        {
          "name" : "obsnCatSurvey",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "category",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/observation-category"
                },
                {
                  "valueString" : "survey"
                },
                {
                  "valueString" : "Survey"
                }
              ]
            }
          ]
        },
        {
          "name" : "obsnCatFoodInsecurity",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "category",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes"
                },
                {
                  "valueString" : "food-insecurity"
                },
                {
                  "valueString" : "Food Insecurity"
                }
              ]
            }
          ]
        },
        {
          "name" : "obsn3Code",
          "source" : [
            {
              "context" : "answerItem",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "code",
              "variable" : "code",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://loinc.org"
                },
                {
                  "valueString" : "88124-3"
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "qSubject"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "subject",
              "variable" : "newReference",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "reference",
              "source" : [
                {
                  "context" : "qSubject",
                  "element" : "reference",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newReference",
                  "contextType" : "variable",
                  "element" : "reference",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "qReference"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "qSubject",
                  "element" : "display",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newReference",
                  "contextType" : "variable",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "qDisplay"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "authored",
          "source" : [
            {
              "context" : "src",
              "element" : "authored",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "effective",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "authored"
                }
              ]
            },
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "issued",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "authored"
                }
              ]
            }
          ]
        },
        {
          "name" : "answer",
          "source" : [
            {
              "context" : "answerItem",
              "element" : "answer",
              "variable" : "answer"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "value",
              "variable" : "newCC",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "value",
              "source" : [
                {
                  "context" : "answer",
                  "element" : "value",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newCC",
                  "contextType" : "variable",
                  "element" : "coding",
                  "variable" : "newCoding",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "coding"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "obsnDerivation",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "observation",
              "contextType" : "variable",
              "element" : "derivedFrom",
              "variable" : "newReference",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "id",
              "source" : [
                {
                  "context" : "src",
                  "element" : "id",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newReference",
                  "contextType" : "variable",
                  "element" : "reference",
                  "transform" : "append",
                  "parameter" : [
                    {
                      "valueString" : "QuestionnaireResponse/"
                    },
                    {
                      "valueId" : "id"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SetObservationFullUrl",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "observation",
          "type" : "Observation",
          "mode" : "source"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "observation",
              "element" : "id",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "fullUrl",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/Observation/"
                },
                {
                  "valueId" : "id"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "TransformCondition",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "src",
          "type" : "QuestionnaireResponse",
          "mode" : "source"
        },
        {
          "name" : "bundle",
          "type" : "Bundle",
          "mode" : "source"
        },
        {
          "name" : "condition",
          "type" : "Condition",
          "mode" : "target"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "conditionId",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "id",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "SDOHCC-ConditionFoodInsecurityExample"
                }
              ]
            }
          ],
          "dependent" : [
            {
              "name" : "SetConditionFullUrl",
              "variable" : ["condition", "entry"]
            }
          ]
        },
        {
          "name" : "conditionMeta",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "meta",
              "variable" : "newMeta",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Meta"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "conditionMetaProfile",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newMeta",
                  "contextType" : "variable",
                  "element" : "profile",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionClinicalStatus",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "clinicalStatus",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/condition-clinical"
                },
                {
                  "valueString" : "active"
                },
                {
                  "valueString" : "Active"
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionVeriStatus",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "verificationStatus",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://terminology.hl7.org/CodeSystem/condition-ver-status"
                },
                {
                  "valueString" : "unconfirmed"
                },
                {
                  "valueString" : "Unconfirmed"
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionCatHealthConcern",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "category",
              "variable" : "newCC",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "conditionCatCodingHealthConcern",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newCC",
                  "contextType" : "variable",
                  "element" : "coding",
                  "variable" : "newCoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "conditionCatCodingSystemHealthConcern",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCatCodingCodeHealthConcern",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "health-concern"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCatCodingDisplayHealthConcern",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Health Concern"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionCatFoodInsecurity",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "category",
              "transform" : "cc",
              "parameter" : [
                {
                  "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes"
                },
                {
                  "valueString" : "food-insecurity"
                },
                {
                  "valueString" : "Food Insecurity"
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionCode",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "code",
              "variable" : "newCodeCC",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "CodeableConcept"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "conditionCodeCodingFoodInsecurity",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newCodeCC",
                  "contextType" : "variable",
                  "element" : "coding",
                  "variable" : "newCoding",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "conditionCodeCodingSystemFoodInsecurity",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "http://snomed.info/sct"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCodeCodingCodeFoodInsecurity",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "733423003"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCodeCodingDisplayFoodInsecurity",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding",
                      "contextType" : "variable",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Food insecurity"
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            {
              "name" : "conditionCodeCodingLackOfFood",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "newCodeCC",
                  "contextType" : "variable",
                  "element" : "coding",
                  "variable" : "newCoding2",
                  "transform" : "create",
                  "parameter" : [
                    {
                      "valueString" : "Coding"
                    }
                  ]
                }
              ],
              "rule" : [
                {
                  "name" : "conditionCodeCodingSystemLackOfFood",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding2",
                      "contextType" : "variable",
                      "element" : "system",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "http://hl7.org/fhir/sid/icd-10-cm"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCodeCodingCodeLackOfFood",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding2",
                      "contextType" : "variable",
                      "element" : "code",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Z59.4"
                        }
                      ]
                    }
                  ]
                },
                {
                  "name" : "conditionCodeCodingDisplayLackOfFood",
                  "source" : [
                    {
                      "context" : "src",
                      "variable" : "src"
                    }
                  ],
                  "target" : [
                    {
                      "context" : "newCoding2",
                      "contextType" : "variable",
                      "element" : "display",
                      "transform" : "copy",
                      "parameter" : [
                        {
                          "valueString" : "Lack of adequate food"
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "authored",
          "source" : [
            {
              "context" : "src",
              "element" : "authored",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "onset",
              "variable" : "period",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Period"
                }
              ]
            },
            {
              "context" : "period",
              "contextType" : "variable",
              "element" : "start",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "authored"
                }
              ]
            }
          ]
        },
        {
          "name" : "entry",
          "source" : [
            {
              "context" : "bundle",
              "element" : "entry",
              "variable" : "entries"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "evidence",
              "variable" : "evidence"
            },
            {
              "context" : "evidence",
              "contextType" : "variable",
              "element" : "detail",
              "variable" : "detailReference",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "resource",
              "source" : [
                {
                  "context" : "entries",
                  "element" : "resource",
                  "variable" : "obs3",
                  "condition" : "code.coding.code = '88124-3'"
                }
              ],
              "target" : [
                {
                  "context" : "detailReference",
                  "contextType" : "variable",
                  "element" : "reference",
                  "transform" : "reference",
                  "parameter" : [
                    {
                      "valueId" : "obs3"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "subject",
          "source" : [
            {
              "context" : "src",
              "element" : "subject",
              "variable" : "qSubject"
            }
          ],
          "target" : [
            {
              "context" : "condition",
              "contextType" : "variable",
              "element" : "subject",
              "variable" : "newReference",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Reference"
                }
              ]
            }
          ],
          "rule" : [
            {
              "name" : "reference",
              "source" : [
                {
                  "context" : "qSubject",
                  "element" : "reference",
                  "variable" : "qReference"
                }
              ],
              "target" : [
                {
                  "context" : "newReference",
                  "contextType" : "variable",
                  "element" : "reference",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "qReference"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "display",
              "source" : [
                {
                  "context" : "qSubject",
                  "element" : "display",
                  "variable" : "qDisplay"
                }
              ],
              "target" : [
                {
                  "context" : "newReference",
                  "contextType" : "variable",
                  "element" : "display",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueId" : "qDisplay"
                    }
                  ]
                }
              ]
            }
          ]
        },
        {
          "name" : "conditionEntryRequest",
          "source" : [
            {
              "context" : "src",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "request",
              "variable" : "request"
            }
          ],
          "rule" : [
            {
              "name" : "conditionRequestMethod",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "contextType" : "variable",
                  "element" : "method",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "POST"
                    }
                  ]
                }
              ]
            },
            {
              "name" : "conditionRequestUrl",
              "source" : [
                {
                  "context" : "src",
                  "variable" : "src"
                }
              ],
              "target" : [
                {
                  "context" : "request",
                  "contextType" : "variable",
                  "element" : "url",
                  "transform" : "copy",
                  "parameter" : [
                    {
                      "valueString" : "Condition"
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name" : "SetConditionFullUrl",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "condition",
          "type" : "Condition",
          "mode" : "source"
        },
        {
          "name" : "entry",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "id",
          "source" : [
            {
              "context" : "condition",
              "element" : "id",
              "variable" : "src"
            }
          ],
          "target" : [
            {
              "context" : "entry",
              "contextType" : "variable",
              "element" : "fullUrl",
              "transform" : "append",
              "parameter" : [
                {
                  "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/Condition/"
                },
                {
                  "valueId" : "id"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
