# SDOHCC Task For Patient - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Task For Patient 

 
Profile for SDOH-related tasks to be carried out by the patient or someone acting on their behalf. 

### Purpose

This profile is used to pass a Task authored by a Practitioner or Organization (`Task.requester` field) targeting a Patient or Related Person (`Task.owner` field) to the individual. These fields are required. The `Task.output` is used to return a response appropriate to the requested Task code.

### Usage

#### Types of Tasks

The table shows the types of tasks that can be assigned to the patient and the constraints imposed by each usage that are enforced through invariants:

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| Questionnaire (FHIR) | `complete-questionnaire` |   | questionnaire, questionnaire-category required | If present, questionnaire-response |   |
| Questionnaire (PDF) | `complete-questionnaire` |   | questionnaire-pdf, questionnaire-category required | If present, questionnaire-pdf-completed |   |
| Questionnaire (URL) | `complete-questionnaire` |   | questionnaire-url, questionnaire-category required |   |   |
| General Information | `general-information` | required |   | If present, general-information-response |   |
| Make Contact Directions | `make-contact` |   | at least one contact-entity is required | If present, chosen-contact |   |
| Review Material | `review-material` |   |   |   | DocumentReference required. |

#### Checking Task Status

See [Checking Task Status](checking_task_status.md).

#### Status Management

The status values constrain the Task to specific states that are required to support communication with a patient application.

The allowed state transitions are defined graphically in the state diagram below, and are described in the table below.

**Figure 1: Patient Task State Diagram**

| | | | |
| :--- | :--- | :--- | :--- |
| `ready` | Ready | The task is ready to be performed, but no action has been taken. Used in place of requested/received/accepted/rejected when request assignment and acceptance is given | Requester |
| `in-progress` | In Progress | The task has been started but is not yet complete | Patient App |
| `completed` | Completed | The task has been completed. | Patient App |
| `cancelled` | Cancelled | The task was not completed | Requester or Patient App |
| `on-hold` | On Hold | The task has been started but work has been paused. | Patient App |
| `failed` | Failed | The task was attempted but could not be completed due to some error. | Patient App |
| `entered-in-error` | Entered in Error | The task should never have existed and is retained only because of the possibility it may have been used | Requester |

### Modification of fields

In addition to a limited set of status values, the patient application is only permitted to modify a specific set of elements in responding to the task request. These elements include: .status, .statusReason, and .output. All other elements are outside of the scope of this IG. The patient application cannot modify the status of the referral task [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md), that can only be done by the requester and the performing or intermediary entity.

**Usages:**

* Refer to this Profile: [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md)
* Examples for this Profile: [Task/SDOHCC-TaskPatientInformationRequestCompletedExample](Task-SDOHCC-TaskPatientInformationRequestCompletedExample.md), [Task/SDOHCC-TaskPatientMakeAppointmentCompletedExample](Task-SDOHCC-TaskPatientMakeAppointmentCompletedExample.md), [Task/SDOHCC-TaskPatientReviewInformationCompletedExample](Task-SDOHCC-TaskPatientReviewInformationCompletedExample.md) and [Task/SDOHCC-TaskPatientRiskQuestionnaireCompletedExample](Task-SDOHCC-TaskPatientRiskQuestionnaireCompletedExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-TaskForPatient)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-TaskForPatient.csv), [Excel](../StructureDefinition-SDOHCC-TaskForPatient.xlsx), [Schematron](../StructureDefinition-SDOHCC-TaskForPatient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-TaskForPatient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCTaskForPatient",
  "title" : "SDOHCC Task For Patient",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for SDOH-related tasks to be carried out by the patient or someone acting on their behalf.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "short" : "A request to fulfill an SDOH questionnaire or service request",
        "constraint" : [
          {
            "key" : "SDOH-Task-1",
            "severity" : "error",
            "human" : "If Task.code is “complete-questionnaire”, then exactly one Task.input of either \"questionnaire\", \"questionnaire-pdf\", or \"questionnaire-url\" is required and Task.input \"questionnaire-category\" is required.",
            "expression" : "code.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='complete-questionnaire').exists() implies ((input.type.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='questionnaire').exists() xor input.type.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='questionnaire-pdf').exists() xor input.type.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='questionnaire-url').exists()) and input.type.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='questionnaire-category').exists())",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-2",
            "severity" : "error",
            "human" : "If Task.code is “general-information”, then Task.description is required and Task.output, if present, must be “general-information-response”.",
            "expression" : "code.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='general-information').exists() implies (description.exists() and (output.empty() or output.type.coding.all(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='general-information-response').exists()))",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-3",
            "severity" : "error",
            "human" : "If Task.code is \"review-material\", then Task.focus of DocumentReference is required.",
            "expression" : "code.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='review-material').exists() \n implies focus.resolve().all($this is DocumentReference)",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-4",
            "severity" : "error",
            "human" : "If Task.code is \"make-contact\", then Task.input of at least one \"contact-entity\" is required.",
            "expression" : "code.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='make-contact').exists() implies input.type.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='contact-entity').exists()",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-5",
            "severity" : "error",
            "human" : "If Task.input is \"questionnaire\", then Task.output, if present, must be \"questionnaire-response\".",
            "expression" : "input.type.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='questionnaire').exists() implies (output.type.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='questionnaire-response').exists() or output.empty())",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-6",
            "severity" : "error",
            "human" : "If Task.input is \"questionnaire-pdf\", then Task.output, if present, must be \"questionnaire-pdf-completed\".",
            "expression" : "input.type.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='questionnaire-pdf').exists() implies (output.type.coding.where(system='http://hl7.org/fhir/uv/sdc/CodeSystem/temp' and code='questionnaire-pdf-completed').exists() or output.empty())",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          },
          {
            "key" : "SDOH-Task-7",
            "severity" : "error",
            "human" : "If Task.code is \"make-contact\", then Task.description is required and Task.output, if present, must be \"chosen-contact\".",
            "expression" : "code.coding.where(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='make-contact').exists() implies (description.exists() and (output.empty() or output.type.coding.all(system='http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes' and code='chosen-contact').exists()))",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
          }
        ]
      },
      {
        "id" : "Task.partOf",
        "path" : "Task.partOf",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Task.partOf:SupportedPartOf",
        "path" : "Task.partOf",
        "sliceName" : "SupportedPartOf",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "comment" : "For further details on Task.status see [Checking Task Status](checking_task_status.html).",
        "requirements" : "These states enable coordination of task status with off-the-shelf workflow solutions that support automation of tasks. ",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetTaskStatus"
        }
      },
      {
        "id" : "Task.statusReason",
        "path" : "Task.statusReason",
        "definition" : "If the task is cancelled by the patient, an explanation as to why should be provided.",
        "comment" : "This applies to the current status.  Look at the history of the task to see reasons for past statuses. If the Task.status is cancelled, then Task.statusReason.text should be included.",
        "mustSupport" : true
      },
      {
        "id" : "Task.statusReason.text",
        "path" : "Task.statusReason.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "short" : "order",
        "definition" : "Indicates the \"level\" of actionability associated with the Task.",
        "comment" : "Patient tasks will always be orders.",
        "fixedCode" : "order"
      },
      {
        "id" : "Task.priority",
        "path" : "Task.priority",
        "short" : "routine | urgent",
        "definition" : "Indicates how quickly the Task should be addressed by the patient.",
        "requirements" : "Used to identify the level of priority assigned to this task. For tasks identified as urgent, the ability to deliver a related sevice may be dependent on task completion.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetTaskPriority"
        }
      },
      {
        "id" : "Task.code",
        "path" : "Task.code",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetTaskCode"
        }
      },
      {
        "id" : "Task.code.text",
        "path" : "Task.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Task.description",
        "path" : "Task.description",
        "comment" : "If Task.code is \"general-information\", Task.description should be displayed to the user with no other computable expectation other than allowing the patient to update the Task.status and optionally capture a free text response for Task.output.",
        "condition" : ["SDOH-Task-2", "SDOH-Task-7"],
        "mustSupport" : true
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "condition" : ["SDOH-Task-3"],
        "mustSupport" : true
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.input",
        "path" : "Task.input",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Task.input:Questionnaire",
        "path" : "Task.input",
        "sliceName" : "Questionnaire",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-1"],
        "mustSupport" : true
      },
      {
        "id" : "Task.input:Questionnaire.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/temp",
              "code" : "questionnaire"
            }
          ]
        },
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "TaskInputParameterType"
            }
          ],
          "strength" : "example",
          "description" : "Codes to identify types of input parameters. These will typically be specific to a particular workflow. The codes represent types of questionnaires that the patient might be asked to complete."
        }
      },
      {
        "id" : "Task.input:Questionnaire.value[x]",
        "path" : "Task.input.value[x]",
        "comment" : "This references the SDC Base Questionnaire profile to allow the use of questionnaires (e.g. a patient satisfaction questionnaire) that are not SDOH screening questionnaires. However, for questionnaires that are intended to produce FHIR resources (e.g., Observations or Conditions), the SDC Extractable Questionnaire - StructureMap should be used.",
        "type" : [
          {
            "code" : "canonical",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire"
            ]
          }
        ]
      },
      {
        "id" : "Task.input:QuestionnairePDF",
        "path" : "Task.input",
        "sliceName" : "QuestionnairePDF",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-1"],
        "mustSupport" : true
      },
      {
        "id" : "Task.input:QuestionnairePDF.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "questionnaire-pdf"
            }
          ]
        }
      },
      {
        "id" : "Task.input:QuestionnairePDF.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Task.input:QuestionnaireURL",
        "path" : "Task.input",
        "sliceName" : "QuestionnaireURL",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-1"],
        "mustSupport" : true
      },
      {
        "id" : "Task.input:QuestionnaireURL.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "questionnaire-url"
            }
          ]
        }
      },
      {
        "id" : "Task.input:QuestionnaireURL.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "Task.input:QuestionnaireCategory",
        "path" : "Task.input",
        "sliceName" : "QuestionnaireCategory",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-1"],
        "mustSupport" : true
      },
      {
        "id" : "Task.input:QuestionnaireCategory.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "questionnaire-category"
            }
          ]
        }
      },
      {
        "id" : "Task.input:QuestionnaireCategory.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "Types of Social Determinant of Health (SDOH) questionnaires that the patient might be asked to complete",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHQuestionnaireCategory"
        }
      },
      {
        "id" : "Task.input:Contact",
        "path" : "Task.input",
        "sliceName" : "Contact",
        "comment" : "If Task.code is \"make-contact\" and multiple Task.inputs are provided, the intent is that the task owner selects only one to contact. If more than one contact needs to be made, there should be separate Tasks.",
        "min" : 0,
        "max" : "*",
        "condition" : ["SDOH-Task-4"],
        "mustSupport" : true
      },
      {
        "id" : "Task.input:Contact.type",
        "path" : "Task.input.type",
        "comment" : "When Task.code is \"make-contact\", \"contact-entity\" is used for Task.input.type to indicate that the task owner should contact one of the healthcare services represented in Task.input.value.",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "contact-entity"
            }
          ]
        }
      },
      {
        "id" : "Task.input:Contact.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Task.output",
        "path" : "Task.output",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "condition" : ["SDOH-Task-2", "SDOH-Task-5", "SDOH-Task-6", "SDOH-Task-7"]
      },
      {
        "id" : "Task.output:QuestionnaireResponse",
        "path" : "Task.output",
        "sliceName" : "QuestionnaireResponse",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-5", "SDOH-Task-5", "SDOH-Task-6", "SDOH-Task-7"],
        "mustSupport" : true
      },
      {
        "id" : "Task.output:QuestionnaireResponse.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/sdc/CodeSystem/temp",
              "code" : "questionnaire-response"
            }
          ]
        }
      },
      {
        "id" : "Task.output:QuestionnaireResponse.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse"
            ]
          }
        ]
      },
      {
        "id" : "Task.output:QuestionnairePDFCompleted",
        "path" : "Task.output",
        "sliceName" : "QuestionnairePDFCompleted",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-6", "SDOH-Task-5", "SDOH-Task-6", "SDOH-Task-7"],
        "mustSupport" : true
      },
      {
        "id" : "Task.output:QuestionnairePDFCompleted.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "questionnaire-pdf-completed"
            }
          ]
        }
      },
      {
        "id" : "Task.output:QuestionnairePDFCompleted.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Task.output:GeneralInformationResponse",
        "path" : "Task.output",
        "sliceName" : "GeneralInformationResponse",
        "min" : 0,
        "max" : "*",
        "condition" : ["SDOH-Task-2", "SDOH-Task-7", "SDOH-Task-6", "SDOH-Task-7"],
        "mustSupport" : true
      },
      {
        "id" : "Task.output:GeneralInformationResponse.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "general-information-response"
            }
          ]
        }
      },
      {
        "id" : "Task.output:GeneralInformationResponse.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "markdown"
          }
        ]
      },
      {
        "id" : "Task.output:ChosenContact",
        "path" : "Task.output",
        "sliceName" : "ChosenContact",
        "comment" : "If Task.code is \"make-contact\" and multiple Task.inputs are provided, the intent is that the task owner selects only one to contact and can indicate the \"chosen-contact\".",
        "min" : 0,
        "max" : "1",
        "condition" : ["SDOH-Task-7", "SDOH-Task-5", "SDOH-Task-6", "SDOH-Task-7"],
        "mustSupport" : true
      },
      {
        "id" : "Task.output:ChosenContact.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "chosen-contact"
            }
          ]
        }
      },
      {
        "id" : "Task.output:ChosenContact.value[x]",
        "path" : "Task.output.value[x]",
        "type" : [
          {
            "code" : "markdown"
          }
        ]
      }
    ]
  }
}

```
