# SDOHCC Procedure - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Procedure 

 
Profile for interventions that address Social Determinants of Health. 

### Purpose

SDOHCC Procedure is generally intended to represent a procedure performed to address an identified social risk or need (e.g., [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Observation Assessment](StructureDefinition-SDOHCC-ObservationAssessment.md)). SDOHCC Procedure can be based on an [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md), pertain to an [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md), or be the output of an [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md). See the [Data Modeling Framework](sdoh_clinical_care_scope.md#data-modeling-framework) for more detail on the relationships between SDOHCC Procedure and the other profiles in this IG.

### Usage

`Procedure.code` has a binding to [US Core Procedure Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-procedure-code.html) ([required](http://hl7.org/fhir/R4/terminologies.html#required)). `Procedure.code` also has additional bindings to SDOH domain-specific value sets (e.g., for Food Insecurity) which are determined by the value selected for `Procedure.category`. When `Procedure.category` is a value from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity), `Procedure.code` **SHALL** be selected from the corresponding domain-specific value set found in Additional Bindings (i.e. [Food Insecurity Procedures](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.7/expansion/Latest)). If more than one value is selected from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity and financial-insecurity) for `Procedure.category`, then `Procedure.code` **SHALL** be selected from at least one of the corresponding domain-specific value sets found in Additional Bindings (e.g. [Food Insecurity Procedures](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.7/expansion/Latest)).

Of note, Gravity Project is continuously developing terminology for new SDOH domains. For new SDOH domains where the Gravity terminology development cycle is in progress, domain-specific value sets may not yet be available in VSAC. If a domain-specific value set is not yet available in VSAC, the Additional Binding is the default binding for the profile element. Additionally, sometimes a domain-specific value set for a new domain is available in VSAC but does not yet include all standardized codes identified during the domain’s terminology development cycle. In this case, the value set’s “Description” tab in VSAC will state, “In progress”. If a domain-specific value set is available in VSAC but does not yet include all standardized codes identified during the domain’s terminology development cycle, the value set’s VSAC “Description” tab will state, “In progress”. Additional information related to Gravity value sets is provided on the [Social Risk Terminology Value Sets](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets) page on the Gravity Project Confluence site.

Additionally, some SDOH domains may not yet be represented in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Procedure.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used so that the Procedure instance can still be categorized as SDOH-related. If desired, category.text can also be used to further specify the domain. For example, at the time of publication of this IG, “disability-status” is not yet included in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Procedure.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used along with category.text: Disability Status. For `Procedure.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified), there will not be domain-specific value sets and Additional Bindings for `Procedure.code` will designate the default binding to [US Core Procedure Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-procedure-code.html) ([required](http://hl7.org/fhir/R4/terminologies.html#required)).

For more information on the correlation between `Procedure.category` and the domain-specific value sets in Additional Bindings for `Procedure.code`, see [Gravity Project Value Sets](gravity_terminology.md#gravity-project-value-sets).

**Usages:**

* Refer to this Profile: [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* Examples for this Profile: [Procedure/SDOHCC-ProcedureFoodPantryApplicationAssistanceExample](Procedure-SDOHCC-ProcedureFoodPantryApplicationAssistanceExample.md), [Procedure/SDOHCC-ProcedureProvisionOfFoodExample](Procedure-SDOHCC-ProcedureProvisionOfFoodExample.md) and [Procedure/SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample](Procedure-SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-Procedure)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-Procedure.csv), [Excel](../StructureDefinition-SDOHCC-Procedure.xlsx), [Schematron](../StructureDefinition-SDOHCC-Procedure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-Procedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCProcedure",
  "title" : "SDOHCC Procedure",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for interventions that address Social Determinants of Health.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "constraint" : [
          {
            "key" : "us-core-7",
            "severity" : "error",
            "human" : "Performed SHALL be present if the status is 'completed' or 'in-progress'",
            "expression" : "(status='completed' or status='in-progress') implies performed.exists()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
          }
        ]
      },
      {
        "id" : "Procedure.extension",
        "path" : "Procedure.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Procedure.extension:pertainsToGoal",
        "path" : "Procedure.extension",
        "sliceName" : "pertainsToGoal",
        "short" : "Pertains to SDOH goal",
        "definition" : "Indicates that the resource is related to either the measurement, achievement or progress towards the referenced goal.  For example, a Procedure to provide food vouchers pertainsToGoal of achieving food security.",
        "requirements" : "Indicates that the procedure is related to the referenced SDOHCC Goal.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal|5.2.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.extension:pertainsToGoal.value[x]",
        "path" : "Procedure.extension.value[x]",
        "definition" : "Value of extension must reference a Goal resource.",
        "requirements" : "Indicates that the procedure is related to the referenced SDOHCC Goal.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.basedOn",
        "path" : "Procedure.basedOn",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Procedure.basedOn:SupportedBasedOn",
        "path" : "Procedure.basedOn",
        "sliceName" : "SupportedBasedOn",
        "short" : "An SDOH service request or US Core Care Plan for this procedure",
        "definition" : "A reference to an SDOHCC service request or US Core Care Plan that contains details of the request for this procedure.",
        "requirements" : "When a procedure is based on an SDOH ServiceRequest, Procedure.basedOn should reference instances that comply with the SDOHCC ServiceRequest profile and when a procedure is based on a SDOH Care Plan, Procedure.basedOn should reference instances that comply with the US Core Care Plan profile. However, references to other instance types are also possible.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.status",
        "path" : "Procedure.status",
        "condition" : ["us-core-7"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-status"
        }
      },
      {
        "id" : "Procedure.category",
        "path" : "Procedure.category",
        "definition" : "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Social service procedure\")."
      },
      {
        "id" : "Procedure.category.coding",
        "path" : "Procedure.category.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Procedure.category.coding:SDOHCC",
        "path" : "Procedure.category.coding",
        "sliceName" : "SDOHCC",
        "short" : "e.g., food-insecurity | transportation-insecurity",
        "definition" : "An SDOH category assigned to the procedure.",
        "requirements" : "Allows for alternative encodings within a code system, and translations to other code systems.  \r\nCodes from this value set can be used to assign an SDOH category (e.g., food-insecurity, transportation-insecurity, etc.) to a procedure. It is recommended that SDOH category codes be used to facilitate searching for SDOH procedures that address SDOH conditions, observations, service requests, or goals.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for high-level SDOH categories.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        }
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "definition" : "The specific procedure that is performed. Use text if the exact nature of the procedure cannot be coded.",
        "requirements" : "Code is required and must be selected from the bound value set.",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.235|20240615"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-access"
                        }
                      ],
                      "text" : "digital-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.226|20240628"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-literacy"
                        }
                      ],
                      "text" : "digital-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "educational-attainment"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.56|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "educational-attainment"
                        }
                      ],
                      "text" : "educational-attainment"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "elder-abuse"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.67|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "elder-abuse"
                        }
                      ],
                      "text" : "elder-abuse"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "employment-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.59|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "employment-status"
                        }
                      ],
                      "text" : "employment-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "financial-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.32|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "financial-insecurity"
                        }
                      ],
                      "text" : "financial-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "food-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.7|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "food-insecurity"
                        }
                      ],
                      "text" : "food-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "health-insurance-coverage-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.125|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "health-insurance-coverage-status"
                        }
                      ],
                      "text" : "health-insurance-coverage-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "homelessness"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.20|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "homelessness"
                        }
                      ],
                      "text" : "homelessness"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "housing-instability"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.44|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "housing-instability"
                        }
                      ],
                      "text" : "housing-instability"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "inadequate-housing"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.52|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "inadequate-housing"
                        }
                      ],
                      "text" : "inadequate-housing"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "incarceration-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.260"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "incarceration-status"
                        }
                      ],
                      "text" : "incarceration-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "intimate-partner-violence"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.97|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "intimate-partner-violence"
                        }
                      ],
                      "text" : "intimate-partner-violence"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "language-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.268"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "language-access"
                        }
                      ],
                      "text" : "language-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "material-hardship"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.39|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "material-hardship"
                        }
                      ],
                      "text" : "material-hardship"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "medical-cost-burden"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.122|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "medical-cost-burden"
                        }
                      ],
                      "text" : "medical-cost-burden"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "personal-health-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.118|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "personal-health-literacy"
                        }
                      ],
                      "text" : "personal-health-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "social-connection"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.94|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "social-connection"
                        }
                      ],
                      "text" : "social-connection"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "stress"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.87|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "stress"
                        }
                      ],
                      "text" : "stress"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "transportation-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.27|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "transportation-insecurity"
                        }
                      ],
                      "text" : "transportation-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "utility-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.247|20240524"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "utility-insecurity"
                        }
                      ],
                      "text" : "utility-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "veteran-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.90|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "veteran-status"
                        }
                      ],
                      "text" : "veteran-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "sdoh-category-unspecified"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "required"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code|7.0.0"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure",
                      "code" : "Procedure.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "sdoh-category-unspecified"
                        }
                      ],
                      "text" : "sdoh-category-unspecified"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code|7.0.0"
        }
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.encounter",
        "path" : "Procedure.encounter",
        "short" : "Encounter associated with the procedure",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Range"
          }
        ],
        "condition" : ["us-core-7"],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.reasonCode",
        "path" : "Procedure.reasonCode",
        "comment" : "Procedure.reasonCode and Procedure.reasonReference are not meant to be duplicative.  For a single reason, either Procedure.reasonCode or Procedure.reasonReference can be used. Procedure.reasonCode may be a summary code, or Procedure.reasonReference may be used to reference a very precise definition of the reason using Condition | Observation | Procedure | DiagnosticReport | DocumentReference.  Both Procedure.reasonCode and Procedure.reasonReference can be used if they are describing different reasons for the procedure.\r\n\r\nInformation represented by Procedure.reasonCode may overlap significantly with information represented by Procedure.reasonReference. Multiple approaches to representing the same information may negatively impact interoperability. Therefore, where similar information could be provided by either Procedure.reasonCode or Procedure.reasonReference, it is recommended that Procedure.reasonReference be used to provide a reason for why a procedure was performed.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code|7.0.0"
        }
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "comment" : "Procedure.reasonCode and Procedure.reasonReference are not meant to be duplicative.  For a single reason, either Procedure.reasonCode or Procedure.reasonReference can be used.  Procedure.reasonCode may be a summary code, or Procedure.reasonReference may be used to reference a very precise definition of the reason using Condition | Observation | Procedure | DiagnosticReport | DocumentReference.  Both Procedure.reasonCode and Procedure.reasonReference can be used if they are describing different reasons for the procedure.\r\n\r\nAdditionally, see Comments for reasonCode."
      },
      {
        "id" : "Procedure.reasonReference:SupportedReasonReference",
        "path" : "Procedure.reasonReference",
        "sliceName" : "SupportedReasonReference",
        "comment" : "Procedure.reasonCode and Procedure.reasonReference are not meant to be duplicative.  For a single reason, either Procedure.reasonCode or Procedure.reasonReference can be used.  Procedure.reasonCode may be a summary code, or Procedure.reasonReference may be used to reference a very precise definition of the reason using Condition | Observation | Procedure | DiagnosticReport | DocumentReference.  Both Procedure.reasonCode and Procedure.reasonReference can be used if they are describing different reasons for the procedure.",
        "requirements" : "When a procedure is justified by one or more SDOH conditions or observations, Procedure.reasonReference should reference instances that comply with the SDOHCC Condition profile, or one of the SDOHCC Observation profiles. However, references to other instance types are also possible.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
