# SDOHCC Observation Screening Response - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Observation Screening Response 

 
Profile for observations that represent question and answer pairs from Social Determinants of Health (SDOH) screening instruments. 

### Purpose

SDOHCC Observation Screening Response (OSR) is intended to represent question-answer pairs from Social Determinants of Health (SDOH) assessment instruments. An OSR that identifies a social risk or need can be referenced as evidence for an [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md). Additionally, an OSR may be addressed by, or be the outcome of, an [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md), or the reason for an [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md) or [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md). See the [Data Modeling Framework](sdoh_clinical_care_scope.md#data-modeling-framework) for more detail on the relationships between OSR and other profiles in this IG.

This IG focuses on a workflow where completed assessment instruments are captured using QuestionnaireResponse. To facilitate querying and searching, individual question-answer pairs from a QuestionnaireResponse can be converted into Observations. The decision as to which responses from a QuestionnaireResponse to convert into Observations will generally be driven by the usage need. For more information on this topic see [Representing Assessment Instrument Data in a FHIR Format](assessment_instrument_support.md#representing-assessment-instrument-data-in-a-fhir-format).

In the future, for standardized assessment instruments, a StructureMap instance would ideally be provided by a Questionnaire steward to ensure consistency in the Observations and Conditions (i.e., unconfirmed health concerns) generated from the assessment instrument. For more information on this topic, see [Using StructureMap to Generate Observations or Conditions from QuestionnaireResponse](assessment_instrument_support.md#using-structuremap-to-generate-observations-or-conditions-from-questionnaireresponse).

### Usage

`Observation.code` has bindings to [US Core Survey Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-survey-codes.html) ([required](http://hl7.org/fhir/R4/terminologies.html#required)) and `Observation.value` has bindings to [LOINCCodes](http://hl7.org/fhir/R4/valueset-observation-codes.html) ([preferred](http://hl7.org/fhir/R4/terminologies.html#preferred)). `Observation.code` and `Observation.value` also have additional bindings to SDOH domain-specific value sets (e.g., for Food Insecurity, Inadequate Housing, etc.) which are determined by the value selected for `Observation.category`. If `Observation.category` references only one value from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity), `Observation.code` and `Observation.value` **SHALL** be selected from the corresponding domain-specific value set found in Additional Bindings. If more than one value is selected from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity and financial-insecurity) for `Observation.category`, then `Observation.code` and `Observation.value` **SHALL** be selected from one of the corresponding domain-specific value sets found in Additional Bindings (e.g. [Food Insecurity Screening Assessments And Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.194/expansion/Latest) for `Observation.code` and [Food Insecurity Screening Assessments Answers](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.174/expansion/Latest) for `Observation.value`).

Occasionally, questions that are reused across different assessment instruments are represented by the same LOINC code, but the question’s allowed answer set may vary on different assessment instruments. Therefore, the allowed answer set (for `Observation.value`) for a question (`Observation.code`) is determined by the assessment instrument. For this reason, Gravity provides downloadable Assessment Instrument Spreadsheets that link Gravity-vetted questions to the assessment instruments from which they were chosen and their allowed answer sets. For access to the Spreadsheets and more information on this topic, see [Social Risk Terminology Value Sets](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets) on the Gravity Confluence site and specifically the [Assessment Instruments Spreadsheet Guidance](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets?preview=/97463504/161062739/Assessment_Instruments_Spreadsheet_Guidance_V1.pdf) document.

Of note, Gravity Project is continuously developing terminology for new SDOH domains. Sometimes a new SDOH domain may already be represented by a category code in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md), but a domain-specific value set may not yet be available in VSAC. In this case, the Additional Binding for the new SDOH domain/category is the default binding for the profile element. Additionally, sometimes a domain-specific value set for a new domain is available in VSAC but does not yet include all standardized codes identified during the domain’s terminology development cycle. In this case, the value set’s “Description” tab in VSAC will state, “In progress”. If a domain-specific value set is available in VSAC but does not yet include all standardized codes identified during the domain’s terminology development cycle, the value set’s VSAC “Description” tab will state, “In progress”. Additional information related to Gravity value sets is provided on the [Social Risk Terminology Value Sets](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets) page on the Gravity Project Confluence site.

Additionally, some SDOH domains may not yet be represented in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Observation.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used and, if desired, `Observation.category.text` can also be used to further specify the domain. For example, at the time of publication of this IG, “disability-status” is not yet included in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Observation.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used along with `Observation.category.text`: Disability Status. For `Observation.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified), there will not be domain-specific value sets and Additional Bindings for `Observation.code` and `Observation.value` will be the default bindings to [US Core Survey Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-survey-codes.html) ([required](http://hl7.org/fhir/R4/terminologies.html#required)) and [LOINCCodes](http://hl7.org/fhir/R4/valueset-observation-codes.html) ([preferred](http://hl7.org/fhir/R4/terminologies.html#preferred)) respectively.

For more information on the correlation between `Observation.category` and the domain-specific value sets in Additional Bindings for `Observation.code` and `Observation.value`, see [Gravity Project Value Sets](gravity_terminology.md#gravity-project-value-sets).

When `Observation.category` is used to tag Observations by SDOH domain (e.g., Food Insecurity, Housing Instability), `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) (Positive) can be used to flag Observations that might represent a health-related social need (HRSN) in the specified SDOH domain(s) (see [SDOHCC Observation Response Hunger Vital Sign Question 3 Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md#root)). For more information on the use of `Observation.category` and `Observation.interpretation` and their interplay when used with OSR, see [Additional Guidance on SDOHCC Observation Screening Response Elements](assessment_instrument_support.md#additional-guidance-on-sdohcc-observation-screening-response-elements).

Observation can also reference other artifacts. For example:

* If a question-answer pair is not answered directly on an assessment instrument (e.g., when a score or value is based on other question-answer pairs), OSR can reference one or more other OSRs via `Observation.derivedFrom` (see [SDOHCC Observation Response NHANES Question 6 Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md)).
* If assessment instrument context is needed, Observations generated from a QuestionnaireResponse can reference QuestionnaireResponse via `Observation.derivedFrom`.
* In addition to representing instances of question-answer pairs, SDOHCC Observation Screening Response can be used as an Observation Grouping that, via `Observation.member`, references the OSR instances that result from a completed assessment instrument. For this reason, in addition to codes that represent questions, the value sets bound to `Observation.code` include codes that represent assessment instruments (LOINC panel codes). For an Observation Grouping, `Observation.code` **SHALL** be a LOINC panel code and `Observation.member` **SHALL** reference the OSR instances generated from that LOINC panel (assessment instrument). Observation Grouping is most useful when additional assessment instrument context is needed and a QuestionnaireResponse has not been created. For more information on Observation Grouping, see [Using Observation Screening Response to Group Observations](assessment_instrument_support.md#using-observation-screening-response-to-group-observations).

**Usages:**

* Refer to this Profile: [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md), [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md)...Show 2 more,[SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)and[SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* Examples for this Profile: [Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md), [Observation/SDOHCC-ObservationResponseNHANESGroupingExample](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md), [Observation/SDOHCC-ObservationResponseNHANESQuestion1Example](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md), [Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md)...Show 8 more,[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion5Example](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion6Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md),[Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md)and[Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ObservationScreeningResponse)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ObservationScreeningResponse.csv), [Excel](../StructureDefinition-SDOHCC-ObservationScreeningResponse.xlsx), [Schematron](../StructureDefinition-SDOHCC-ObservationScreeningResponse.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ObservationScreeningResponse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCObservationScreeningResponse",
  "title" : "SDOHCC Observation Screening Response",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for observations that represent question and answer pairs from Social Determinants of Health (SDOH) screening instruments.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "SDOH screening questionnaire observations",
        "definition" : "For Observations derived from SDOH screening surveys/questionnaires.",
        "comment" : "Used for simple observations such as education status, food insecurity observations, etc.  \r\nThis profile allows the representation of SDOH observations based on SDOH screening questionnaire responses (which can also be represented using SDC QuestionnaireResponse). \r\n\r\nMany of the SDOHCC profiles reference one another. One flow supported by this IG is that QuestionnaireResponses result in Observations that can be used as evidence for Conditions that can lead to Goals, ServiceRequests and Procedures. However, alternatives paths are also possible.",
        "constraint" : [
          {
            "key" : "SDOH-Obs-4",
            "severity" : "error",
            "human" : "At least one Observation.category SHALL be sdoh",
            "expression" : "category.where(coding.where(system = 'http://hl7.org/fhir/us/core/CodeSystem/us-core-category' and code='sdoh').exists()).exists()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "final | corrected | entered-in-error | unknown",
        "definition" : "The status of the observation value.",
        "requirements" : "Further constrained to values that are relevant for SDOH.",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationStatus"
        }
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "min" : 2
      },
      {
        "id" : "Observation.category:screening-assessment",
        "path" : "Observation.category",
        "sliceName" : "screening-assessment",
        "short" : "Requires at least a category code 'sdoh'",
        "min" : 1,
        "condition" : ["SDOH-Obs-4"]
      },
      {
        "id" : "Observation.category:SDOHCC",
        "path" : "Observation.category",
        "sliceName" : "SDOHCC",
        "short" : "e.g., food-insecurity | transportation-insecurity",
        "definition" : "An SDOH category assigned to the observation.",
        "requirements" : "Codes from this value set can be used to assign one or more SDOH categories (e.g., food-insecurity, transportation-insecurity, etc.) to an observation. It is recommended that SDOH category codes be used to facilitate searching for SDOH observations.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for high-level SDOH categories.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "requirements" : "Knowing what kind of observation is being made is essential to understanding the observation.\r\n\r\nThe Gravity implemenation guide restricts questionnaire/survey observations to LOINC to move the industry to the use of LOINC panels/surveys (structures that are not available in other terminology systems) to standardize the coding of SDOH related risk assessment instruments. In addition, USCDI and US Core have standardized on the use of LOINC to represent Observations in general.",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCode"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.240"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-access"
                        }
                      ],
                      "text" : "digital-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "required"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes|7.0.0"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-literacy"
                        }
                      ],
                      "text" : "digital-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "educational-attainment"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.199"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "educational-attainment"
                        }
                      ],
                      "text" : "educational-attainment"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "elder-abuse"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.191"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "elder-abuse"
                        }
                      ],
                      "text" : "elder-abuse"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "employment-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.205"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "employment-status"
                        }
                      ],
                      "text" : "employment-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "financial-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.193"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "financial-insecurity"
                        }
                      ],
                      "text" : "financial-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "food-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.194"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "food-insecurity"
                        }
                      ],
                      "text" : "food-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "health-insurance-coverage-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.3519"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "health-insurance-coverage-status"
                        }
                      ],
                      "text" : "health-insurance-coverage-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "homelessness"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.196"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "homelessness"
                        }
                      ],
                      "text" : "homelessness"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "housing-instability"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.197"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "housing-instability"
                        }
                      ],
                      "text" : "housing-instability"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "inadequate-housing"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1196.3520"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "inadequate-housing"
                        }
                      ],
                      "text" : "inadequate-housing"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "incarceration-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "required"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes|7.0.0"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "incarceration-status"
                        }
                      ],
                      "text" : "incarceration-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "intimate-partner-violence"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.198"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "intimate-partner-violence"
                        }
                      ],
                      "text" : "intimate-partner-violence"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "language-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.272"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "language-access"
                        }
                      ],
                      "text" : "language-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "material-hardship"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.200"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "material-hardship"
                        }
                      ],
                      "text" : "material-hardship"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "medical-cost-burden"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.201"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "medical-cost-burden"
                        }
                      ],
                      "text" : "medical-cost-burden"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "personal-health-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.195"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "personal-health-literacy"
                        }
                      ],
                      "text" : "personal-health-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "social-connection"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.202"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "social-connection"
                        }
                      ],
                      "text" : "social-connection"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "stress"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.203"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "stress"
                        }
                      ],
                      "text" : "stress"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "transportation-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.204"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "transportation-insecurity"
                        }
                      ],
                      "text" : "transportation-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "utility-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.251"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "utility-insecurity"
                        }
                      ],
                      "text" : "utility-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "veteran-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.192"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "veteran-status"
                        }
                      ],
                      "text" : "veteran-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "sdoh-category-unspecified"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "required"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes|7.0.0"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "sdoh-category-unspecified"
                        }
                      ],
                      "text" : "sdoh-category-unspecified"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "required",
          "description" : "Codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-survey-codes|7.0.0"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "comment" : "Cardinality is 1..1.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "definition" : "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\".",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "requirements" : "Some questions on an SDOH screening questionnaire are not answered directly (e.g., asserted) by the individual completing the questionnaire. Rather, the answer to some questions (e.g., the Hunger Vital Sign 88124-3 “Food insecurity risk”) may be derived from answers to one or more other questions. For an Observation Screening Response  that is derived, as opposed to answered directly, Observation.performer should not be specified.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|7.0.0",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "comment" : "An observation exists to have a value, though it might not if it is in error, if it represents a group of observations, or if a reason for its omission is captured by Observation.dataAbsentReason.",
        "requirements" : "An observation exists to have a value, though it might not if it is in error, if it represents a group of observations, or if it a reason for its omission is captured by Observation.dataAbsentReason."
      },
      {
        "id" : "Observation.value[x]:valueQuantity",
        "path" : "Observation.value[x]",
        "sliceName" : "valueQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "This is the entire UCUM code set.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-UnitsOfMeasureCaseSensitive|3.0.0"
        }
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "comment" : "The allowed set of codes will be determined by Observation.code. A CodeableConcept with just a text would be used instead of a string if the field was usually coded, or if the type associated with the Observation.code defines a coded value.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.239"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-access"
                        }
                      ],
                      "text" : "digital-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "preferred"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/ValueSet/observation-codes"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-literacy"
                        }
                      ],
                      "text" : "digital-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "educational-attainment"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.179"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "educational-attainment"
                        }
                      ],
                      "text" : "educational-attainment"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "elder-abuse"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.190"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "elder-abuse"
                        }
                      ],
                      "text" : "elder-abuse"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "employment-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.183"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "employment-status"
                        }
                      ],
                      "text" : "employment-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "financial-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.173"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "financial-insecurity"
                        }
                      ],
                      "text" : "financial-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "food-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.174|20241214"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "food-insecurity"
                        }
                      ],
                      "text" : "food-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "health-insurance-coverage-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.185"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "health-insurance-coverage-status"
                        }
                      ],
                      "text" : "health-insurance-coverage-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "homelessness"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.176"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "homelessness"
                        }
                      ],
                      "text" : "homelessness"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "housing-instability"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.177"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "housing-instability"
                        }
                      ],
                      "text" : "housing-instability"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "inadequate-housing"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.178|20241214"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "inadequate-housing"
                        }
                      ],
                      "text" : "inadequate-housing"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "incarceration-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "preferred"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/ValueSet/observation-codes"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "incarceration-status"
                        }
                      ],
                      "text" : "incarceration-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "intimate-partner-violence"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.209"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "intimate-partner-violence"
                        }
                      ],
                      "text" : "intimate-partner-violence"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "language-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.271"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "language-access"
                        }
                      ],
                      "text" : "language-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "material-hardship"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.180"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "material-hardship"
                        }
                      ],
                      "text" : "material-hardship"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "medical-cost-burden"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.187"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "medical-cost-burden"
                        }
                      ],
                      "text" : "medical-cost-burden"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "personal-health-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.175|20241214"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "personal-health-literacy"
                        }
                      ],
                      "text" : "personal-health-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "social-connection"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.210|20250701"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "social-connection"
                        }
                      ],
                      "text" : "social-connection"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "stress"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.181"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "stress"
                        }
                      ],
                      "text" : "stress"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "transportation-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.182|20250701"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "transportation-insecurity"
                        }
                      ],
                      "text" : "transportation-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "utility-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.250|20240524"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "utility-insecurity"
                        }
                      ],
                      "text" : "utility-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "veteran-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.184"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "veteran-status"
                        }
                      ],
                      "text" : "veteran-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "sdoh-category-unspecified"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "preferred"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/ValueSet/observation-codes"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
                      "code" : "Observation.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "sdoh-category-unspecified"
                        }
                      ],
                      "text" : "sdoh-category-unspecified"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "This value set includes all LOINC codes",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.bodySite",
        "path" : "Observation.bodySite",
        "max" : "0"
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "max" : "0"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this.resolve()"
            }
          ],
          "description" : "Slicing based on profile conformance of the referenced resource.",
          "rules" : "open"
        },
        "short" : "References the child observations of a grouping observation"
      },
      {
        "id" : "Observation.hasMember:SupportedHasMember",
        "path" : "Observation.hasMember",
        "sliceName" : "SupportedHasMember",
        "short" : "For an Observation Grouping, the Observations generated from an assessment instrument",
        "definition" : "This is the set of child observations that are expected to be supported by SDOH implementations.",
        "comment" : "Other types of observations or resources can still be sent, but SDOH systems aren't required to pay attention to them.",
        "requirements" : "Provides context to the child observations of \"in what instrument/panel was this information collected\", which is critical in situations where the child observations do not have derivedFrom relationships to a QuestionnaireResponse.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "$this.resolve()"
            }
          ],
          "description" : "Slicing based on profile conformance of the referenced resource.",
          "rules" : "open"
        },
        "short" : "ADDITIONAL USCDI: Related Observation(s) or other resource the observation is made from",
        "definition" : "The target resource represents a QuestionnaireResponse or other Observation from which the value of this Observation was inferred or calculated.",
        "comment" : "All the reference choices that are listed in this element can represent clinical observations and other measurements that may be the source for a derived value.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|7.0.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment|7.0.0"
            ],
            "_targetProfile" : [
              null,
              null,
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom:SupportedDerivedFrom",
        "path" : "Observation.derivedFrom",
        "sliceName" : "SupportedDerivedFrom",
        "short" : "Related questionnaire responses or observations that the observation is made from",
        "definition" : "The types of 'derivedFrom' resources that must be supported by implementations conforming to this IG",
        "comment" : "Additional derivation targets (as supported by the underlying Observation resource) are allowed, but there is no expectation that implementers of this IG will pay attention to them.",
        "requirements" : "Allows traceability (and context) for Observations derived from a QuestionnaireResponse and also establishes links for observations that were calculated or inferred based on other Observations (e.g. for calculated scores).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
