# SDOHCC Observation Program Enrollment Status - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Observation Program Enrollment Status 

 
For observations about an individual's enrollment status in a social care program. See[Enrollment Status](enrollment.md)for more additional guidance. 

**NOTE: WE ARE ACTIVELY SEEKING FEEDBACK ON THE FHIR STRUCTURES AND NARRATIVE GUIDANCE SURROUNDING THE ENROLLMENT STATUS ([FHIR-53446](https://jira.hl7.org/browse/FHIR-53446)) USE CASE. WE ENCOURAGE READERS TO REVIEW THE PROPOSED CHANGES AND SUBMIT BALLOT COMMENTS AGAINST THEM.**

**Usages:**

* Refer to this Profile: [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* Examples for this Profile: [Observation/SDOHCC-ObservationEnrollmentStatusExample](Observation-SDOHCC-ObservationEnrollmentStatusExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.csv), [Excel](../StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.xlsx), [Schematron](../StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ObservationProgramEnrollmentStatus",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCObservationProgramEnrollmentStatus",
  "title" : "SDOHCC Observation Program Enrollment Status",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "For observations about an individual's enrollment status in a social care program. See [Enrollment Status](enrollment.html) for more additional guidance.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "definition" : "For observations about an individual's enrollment status in a social care program.",
        "comment" : "For observations about an individual's enrollment status in a social care program."
      },
      {
        "id" : "Observation.category:us-core",
        "path" : "Observation.category",
        "sliceName" : "us-core",
        "short" : "Requires at least a category code 'sdoh'",
        "min" : 1,
        "condition" : ["SDOH-Obs-4"]
      },
      {
        "id" : "Observation.category:enrollment",
        "path" : "Observation.category",
        "sliceName" : "enrollment",
        "min" : 0,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "program-enrollment"
            }
          ]
        }
      },
      {
        "id" : "Observation.category:SDOHCC",
        "path" : "Observation.category",
        "sliceName" : "SDOHCC",
        "short" : "e.g., food-insecurity | transportation-insecurity",
        "definition" : "An SDOH category assigned to the observation.",
        "requirements" : "Codes from this value set can be used to assign one or more SDOH categories (e.g., food-insecurity, transportation-insecurity, etc.) to an observation. It is recommended that SDOH category codes be used to facilitate searching for SDOH observations.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for high-level SDOH categories.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.312"
        }
      },
      {
        "id" : "Observation.focus",
        "path" : "Observation.focus",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "definition" : "For program enrollment status, a single effective date indicates the date of program  enrollment and a period indicates the duration of the program enrollment."
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "description" : "Codes for enrollment status",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetEnrollmentStatus"
        }
      }
    ]
  }
}

```
