# SDOHCC Healthcare Service for Referral Management - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Healthcare Service for Referral Management 

 
Profile that extends SDOHCC HealthcareService to support capacity status queries, allowing referral sources to determine if a CBO has capacity before initiating a referral. Includes the capacity-status extension and elements for describing services, programs, and contact information. 

**Usages:**

* Examples for this Profile: [HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-HealthcareServiceForReferralManagement)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.csv), [Excel](../StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.xlsx), [Schematron](../StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-HealthcareServiceForReferralManagement",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareServiceForReferralManagement",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCHealthcareServiceForReferralManagement",
  "title" : "SDOHCC Healthcare Service for Referral Management",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile that extends SDOHCC HealthcareService to support capacity status queries, allowing referral sources to determine if a CBO has capacity before initiating a referral. Includes the capacity-status extension and elements for describing services, programs, and contact information.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "HealthcareService",
  "baseDefinition" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HealthcareService",
        "path" : "HealthcareService"
      },
      {
        "id" : "HealthcareService.extension",
        "path" : "HealthcareService.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "HealthcareService.extension:capacity-status",
        "path" : "HealthcareService.extension",
        "sliceName" : "capacity-status",
        "short" : "Is the service currently at capacity?",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceCapacityStatus"
            ]
          }
        ]
      },
      {
        "id" : "HealthcareService.category",
        "path" : "HealthcareService.category",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.category.coding",
        "path" : "HealthcareService.category.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.category.coding:ServiceCategory",
        "path" : "HealthcareService.category.coding",
        "sliceName" : "ServiceCategory",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetServiceCategory"
        }
      },
      {
        "id" : "HealthcareService.category.coding:SDOHCC",
        "path" : "HealthcareService.category.coding",
        "sliceName" : "SDOHCC",
        "short" : "e.g., food-insecurity | transportation-insecurity",
        "definition" : "An SDOH category assigned to the service.",
        "requirements" : "Allows for alternative encodings within a code system, and translations to other code systems.  \r\nCodes from this value set can be used to assign an SDOH category (e.g., food-insecurity, transportation-insecurity, etc.) to a service. It is recommended that SDOH category codes be used to facilitate searching for SDOH healthcare services.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for high-level SDOH categories.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        }
      },
      {
        "id" : "HealthcareService.type",
        "path" : "HealthcareService.type",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.name",
        "path" : "HealthcareService.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.program",
        "path" : "HealthcareService.program",
        "mustSupport" : true
      }
    ]
  }
}

```
