# SDOHCC Group - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Group 

 
Profile for identifying groups of patients who have a Social Determinants of Health (SDOH) condition and are members of a specific payer organization. 

### Purpose

SDOHCC Group is intended to support identification of cohorts of individuals who have conditions in the same SDOH category (domain) AND are members of the same specific payer organization. (See [Gravity Use Case Package Use Case 3](https://confluence.hl7.org/pages/viewpage.action?pageId=51227176#GravityUseCasePackage-GravityUseCases) which involves aggregation and analysis of individual-level social risk and need data to support clinical, system, and community activities.) The two required slices on Group.characteristic can be used to identify a cohort of subjects who have coverage through a specific payer organization AND a condition that falls into a specified SDOH category/domain.

**Usages:**

* Examples for this Profile: [CDE payer's SDOH condition patients](Group-SDOHCC-GroupSDOHPatientsForPayerExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-Group)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-Group.csv), [Excel](../StructureDefinition-SDOHCC-Group.xlsx), [Schematron](../StructureDefinition-SDOHCC-Group.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-Group",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Group",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCGroup",
  "title" : "SDOHCC Group",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for identifying groups of patients who have a Social Determinants of Health (SDOH) condition and are members of a specific payer organization.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Group",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Group",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Group",
        "path" : "Group",
        "short" : "Group of SDOH patients for a payer",
        "definition" : "For aggregation of individuals with a common set of characteristics (i.e., the same payer and and any condition in the specified SDOH categories) to enable organizations with the appropriate permissions to easily retrieve information related to the cohort of individuals for which they have a common responsibility."
      },
      {
        "id" : "Group.active",
        "path" : "Group.active",
        "min" : 1,
        "fixedBoolean" : true
      },
      {
        "id" : "Group.type",
        "path" : "Group.type",
        "short" : "person",
        "definition" : "Identifies that this is a group of persons.",
        "requirements" : "For this IG use case, this will only be used for a group of persons.",
        "fixedCode" : "person"
      },
      {
        "id" : "Group.actual",
        "path" : "Group.actual",
        "requirements" : "Refers only to a specific group of real individuals.",
        "fixedBoolean" : true
      },
      {
        "id" : "Group.characteristic",
        "path" : "Group.characteristic",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "Group.characteristic:HasSDOHCondition",
        "path" : "Group.characteristic",
        "sliceName" : "HasSDOHCondition",
        "requirements" : "To identify members who have an active instance of a condition with any Condition.category in the value set referenced by Group.characteristic.value[x] (i.e., SDOH conditions).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasSDOHCondition.code",
        "path" : "Group.characteristic.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "sdoh-condition-category"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasSDOHCondition.value[x]",
        "path" : "Group.characteristic.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/ValueSet"]
          }
        ],
        "patternReference" : {
          "reference" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        },
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasSDOHCondition.exclude",
        "path" : "Group.characteristic.exclude",
        "fixedBoolean" : false,
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasSDOHCondition.period",
        "path" : "Group.characteristic.period",
        "max" : "0"
      },
      {
        "id" : "Group.characteristic:HasPayer",
        "path" : "Group.characteristic",
        "sliceName" : "HasPayer",
        "definition" : "Identifies traits whose presence or absence is shared by members of the group.",
        "requirements" : "To identify members who are covered by a payer referenced by Group.characteristic.value[x].",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasPayer.code",
        "path" : "Group.characteristic.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "payer-coverage"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasPayer.value[x]",
        "path" : "Group.characteristic.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasPayer.exclude",
        "path" : "Group.characteristic.exclude",
        "fixedBoolean" : false,
        "mustSupport" : true
      },
      {
        "id" : "Group.characteristic:HasPayer.period",
        "path" : "Group.characteristic.period",
        "max" : "0"
      },
      {
        "id" : "Group.member",
        "path" : "Group.member",
        "mustSupport" : true
      },
      {
        "id" : "Group.member.entity",
        "path" : "Group.member.entity",
        "mustSupport" : true
      }
    ]
  }
}

```
