# SDOHCC Consent - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Consent 

 
Profile for consent related to the release of Social Determinants of Health (SDOH) information to non-HIPAA covered organizations. 

### Purpose

SDOH data is sensitive personal information with significant privacy and security considerations. The SDOHCC Consent profile is intended for authorizing disclosure of the subject of care’s information between a HIPAA covered entity and a non-HIPAA covered entity (e.g., exchanged between a [Covered Entity](https://www.hhs.gov/hipaa/for-professionals/covered-entities/index.html)) and a [Business Associate](https://www.hhs.gov/hipaa/for-professionals/privacy/guidance/business-associates/index.html) (BA). This profile is not a complete treatment of the issues related to consent; it is a starting point to test the viability of exchanging consent information.

### Usage

See also [Patient Privacy and Consent](privacy_and_security.md#patient-privacy-and-consent).

The consent can be provided as either an attachment or a reference.

**Usages:**

* Refer to this Profile: [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)
* Examples for this Profile: [Consent/SDOHCC-ConsentInformationDisclosureExample](Consent-SDOHCC-ConsentInformationDisclosureExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-Consent)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-Consent.csv), [Excel](../StructureDefinition-SDOHCC-Consent.xlsx), [Schematron](../StructureDefinition-SDOHCC-Consent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-Consent",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Consent",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCConsent",
  "title" : "SDOHCC Consent",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for consent related to the release of Social Determinants of Health (SDOH) information to non-HIPAA covered organizations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent",
        "definition" : "A record of a healthcare consumer’s choices related to the release of SDOH information to non-HIPAA covered organizations.",
        "comment" : "Providers should consider including standard language to inform the patient that disclosure of their information to entities which are not HIPAA covered entities are no longer protected under the HIPAA Privacy Rule but may be protected by FTC Consumer Protection rules."
      },
      {
        "id" : "Consent.status",
        "path" : "Consent.status",
        "comment" : "This element is labeled as a modifier because the status contains the codes rejected and entered-in-error that mark the Consent as not currently valid. \r\n\r\nIn general, when being exchanged with a community-based organization, Consent.status should reference the value “active”.",
        "mustSupport" : true
      },
      {
        "id" : "Consent.scope",
        "path" : "Consent.scope",
        "comment" : "The primary use for this element in the context of this implementation guide will be \"patient-privacy\" (Privacy Consent).",
        "mustSupport" : true
      },
      {
        "id" : "Consent.category",
        "path" : "Consent.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Consent.category:IDSCL",
        "path" : "Consent.category",
        "sliceName" : "IDSCL",
        "requirements" : "The base resource requires category. For consent related to SDOH, ISCDL was the best choice of the required options.",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
              "code" : "IDSCL"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Consent.patient",
        "path" : "Consent.patient",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Consent.dateTime",
        "path" : "Consent.dateTime",
        "requirements" : "This is Must Support to allow a recipient to determine the \"order\" of multiple consents.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Consent.performer",
        "path" : "Consent.performer",
        "requirements" : "This element is not mandatory . There is not a use case that Performer be computable since it will normally be present in the consent \"form\".",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Organization",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole",
              "http://hl7.org/fhir/StructureDefinition/Patient"
            ]
          }
        ]
      },
      {
        "id" : "Consent.organization",
        "path" : "Consent.organization",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Consent.source[x]",
        "path" : "Consent.source[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Attachment"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Consent",
              "http://hl7.org/fhir/StructureDefinition/Contract",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|7.0.0",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
