# SDOHCC ServiceRequest Active WIC Referral Example - SDOH Clinical Care v3.0.0-ballot

## Example ServiceRequest: SDOHCC ServiceRequest Active WIC Referral Example

Language: en

Profile: [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)

**status**: Active

**intent**: Order

**category**: Social service procedure, Food Insecurity

**code**: Assistance with application for food pantry program

**subject**: [BABY ABBAS Male, DoB: 2023-06-15 ( Medical Record Number: 65313516351 (use: usual, ))](Patient-SDOHCC-PatientBabyAbbas.md)

**reasonReference**: [Condition Food insecurity](Condition-SDOHCC-ConditionFoodInsecurityExample.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "SDOHCC-ServiceRequestActiveWICReferralExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
    ]
  },
  "language" : "en",
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "410606002",
          "display" : "Social service procedure"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "food-insecurity",
          "display" : "Food Insecurity"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "467771000124109",
        "display" : "Assistance with application for food pantry program"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
    }
  ]
}

```
