# SDOHCC ServiceRequest Active Food Pantry Application Assist Example - SDOH Clinical Care v3.0.0-ballot

## Example ServiceRequest: SDOHCC ServiceRequest Active Food Pantry Application Assist Example

Language: en

Profile: [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)

**status**: Active

**intent**: Order

**category**: Social service procedure, Food Insecurity

**code**: Assistance with application for food pantry program

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**reasonReference**: [Condition Food insecurity](Condition-SDOHCC-ConditionFoodInsecurityExample.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
    ]
  },
  "language" : "en",
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "410606002",
          "display" : "Social service procedure"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "food-insecurity",
          "display" : "Food Insecurity"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "467771000124109",
        "display" : "Assistance with application for food pantry program"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
    }
  ]
}

```
