# SDOHCC Practitioner Role Dr Jan Water Example - SDOH Clinical Care v3.0.0-ballot

## Example PractitionerRole: SDOHCC Practitioner Role Dr Jan Water Example

Language: en

Profile: [SDOHCC PractitionerRole](StructureDefinition-SDOHCC-practitionerrole.md)

**identifier**: `http://www.deerland.org/practitioners`/2424

**active**: true

**practitioner**: [Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)

**organization**: [Better Health Clinic](Organization-SDOHCC-OrganizationClinicExample.md)

**code**: Family Medicine Physician

**telecom**: ph: 639 442 6719(Work), [jan.water@deerland.org](mailto:jan.water@deerland.org)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "SDOHCC-PractitionerRoleDrJanWaterExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://www.deerland.org/practitioners",
      "value" : "2424"
    }
  ],
  "active" : true,
  "practitioner" : {
    "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample",
    "display" : "Dr Jan Water"
  },
  "organization" : {
    "reference" : "Organization/SDOHCC-OrganizationClinicExample",
    "display" : "Better Health Clinic"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://nucc.org/provider-taxonomy",
          "code" : "207Q00000X",
          "display" : "Family Medicine Physician"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "62247001",
          "display" : "Family medicine specialist (occupation)"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "639 442 6719",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "jan.water@deerland.org",
      "use" : "work"
    }
  ]
}

```
