# SDOHCC Practitioner Pat Williams Example - SDOH Clinical Care v3.0.0-ballot

## Example Practitioner: SDOHCC Practitioner Pat Williams Example

Language: en

Profile: [US Core Practitioner Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-practitioner.html)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/6.1.0/NamingSystem-npi.html)/1234567893, `http://www.deerland.org/practitioners`/24243

**active**: true

**name**: Pat Williams

**address**: 4312 Friendly Dr., Deerland IL 62223 (home)



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "SDOHCC-PractitionerPatWilliamsMSWExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    },
    {
      "system" : "http://www.deerland.org/practitioners",
      "value" : "24243"
    }
  ],
  "active" : true,
  "name" : [
    {
      "text" : "Pat Williams",
      "family" : "Williams",
      "given" : ["Pat"]
    }
  ],
  "address" : [
    {
      "use" : "home",
      "line" : ["4312 Friendly Dr.,"],
      "city" : "Deerland",
      "state" : "IL",
      "postalCode" : "62223"
    }
  ]
}

```
