# SDOHCC Vital Signs WIC Eligibility Example - Weight - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Vital Signs WIC Eligibility Example - Weight

Language: en

Profile: [US Core Body Weight Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-weight.html)

**status**: Final

**category**: Vital Signs

**code**: Body weight

**subject**: [BABY ABBAS Male, DoB: 2023-06-15 ( Medical Record Number: 65313516351 (use: usual, ))](Patient-SDOHCC-PatientBabyAbbas.md)

**effective**: 2025-05-21

**performer**: [Practitioner Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)

**value**: 10.5 kg(Details: UCUM codekg = 'kg')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-VitalSignsWeightExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|7.0.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "29463-7",
        "display" : "Body weight"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas"
  },
  "effectiveDateTime" : "2025-05-21",
  "performer" : [
    {
      "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample"
    }
  ],
  "valueQuantity" : {
    "value" : 10.5,
    "unit" : "kg",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg"
  }
}

```
