# SDOHCC Vital Signs WIC Eligibility Example - Height - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Vital Signs WIC Eligibility Example - Height

Language: en

Profile: [US Core Body Height Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-height.html)

**status**: Final

**category**: Vital Signs

**code**: Body height

**subject**: [BABY ABBAS Male, DoB: 2023-06-15 ( Medical Record Number: 65313516351 (use: usual, ))](Patient-SDOHCC-PatientBabyAbbas.md)

**effective**: 2025-05-21

**performer**: [Practitioner Dr Jan Water](Practitioner-SDOHCC-PractitionerDrJanWaterExample.md)

**value**: 85 cm(Details: UCUM codecm = 'cm')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-VitalSignsHeightExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|7.0.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8302-2",
        "display" : "Body height"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas"
  },
  "effectiveDateTime" : "2025-05-21",
  "performer" : [
    {
      "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample"
    }
  ],
  "valueQuantity" : {
    "value" : 85,
    "unit" : "cm",
    "system" : "http://unitsofmeasure.org",
    "code" : "cm"
  }
}

```
