# SDOHCC-Observation Race OMB Mother Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC-Observation Race OMB Mother Example

Language: en

Profile: [SDOHCC Observation Race OMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md)

**status**: Final

**category**: Personal Characteristic

**code**: Race OMB.1997

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**focus**: [Eve Everywoman](RelatedPerson-SDOHCC-RelatedPersonMotherExample.md)

**effective**: 2022-04-10 23:56:54+0000

**performer**: [COLIN ABBAS](Patient-pat-53234.md)

**method**: Reported By Related Person

> **component****code**:Race OMB.1997**value**:American Indian or Alaska Native

> **component****code**:Race OMB.1997**value**:Cheyenne

> **component****code**:Race OMB.1997**value**:Cherokee

> **component****code**:Race OMB.1997**value**: Cherokee and Cheyenne



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationRaceOMBMotherExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "personal-characteristic"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72826-1"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "focus" : [
    {
      "reference" : "RelatedPerson/SDOHCC-RelatedPersonMotherExample",
      "display" : "Eve Everywoman"
    }
  ],
  "effectiveDateTime" : "2022-04-10T23:56:54.671Z",
  "performer" : [
    {
      "reference" : "Patient/pat-53234",
      "display" : "COLIN ABBAS"
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "reported-by-related-person",
        "display" : "Reported By Related Person"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "72826-1",
            "display" : "Race OMB.1997"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "72826-1",
            "display" : "Race OMB.1997"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1102-3",
            "display" : "Cheyenne"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "72826-1",
            "display" : "Race OMB.1997"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1088-4",
            "display" : "Cherokee"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "72826-1",
            "display" : "Race OMB.1997"
          }
        ]
      },
      "valueString" : "Cherokee and Cheyenne"
    }
  ]
}

```
