# SDOHCC Observation Ethnicity OMB Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Ethnicity OMB Example

Language: en

Profile: [SDOHCC Observation Ethnicity OMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md)

**status**: Final

**category**: Personal Characteristic

**code**: Ethnicity OMB.1997

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**effective**: 2022-04-10 23:56:54+0000

**performer**: [COLIN ABBAS](Patient-pat-53234.md)

**method**: Self Reported

> **component****code**:Ethnicity OMB.1997**value**:Cuban

> **component****code**:Ethnicity OMB.1997**value**:Nicaraguan

> **component****code**:Ethnicity OMB.1997**value**:Hispanic or Latino

> **component****code**:Ethnicity OMB.1997**value**: Hispanic, Cuban on my mom's side and Nicaraguan on my dad's side



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationEthnicityOMBExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationEthnicityOMB"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "personal-characteristic"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "69490-1"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "effectiveDateTime" : "2022-04-10T23:56:54.671Z",
  "performer" : [
    {
      "reference" : "Patient/pat-53234",
      "display" : "COLIN ABBAS"
    }
  ],
  "method" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "self-reported",
        "display" : "Self Reported"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69490-1"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2182-4",
            "display" : "Cuban"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69490-1"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2159-2",
            "display" : "Nicaraguan"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69490-1"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2135-2",
            "display" : "Hispanic or Latino"
          }
        ]
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "69490-1"
          }
        ]
      },
      "valueString" : "Hispanic, Cuban on my mom's side and Nicaraguan on my dad's side"
    }
  ]
}

```
