# SDOH Clinical Care ImplementationGuide Resource - SDOH Clinical Care v3.0.0-ballot

## SDOH Clinical Care ImplementationGuide Resource

| | |
| :--- | :--- |
| **Official URL**: | **Version**: |
| **NPM package name**: | **ComputableName**: |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License |   |

* [XML](ImplementationGuide-hl7.fhir.us.sdoh-clinicalcare.xml)
* [JSON](ImplementationGuide-hl7.fhir.us.sdoh-clinicalcare.json)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.sdoh-clinicalcare.r4)](../package.r4.tgz) and [R4B (hl7.fhir.us.sdoh-clinicalcare.r4b)](../package.r4b.tgz) are available. 

### IG Dependencies

This IG Contains the following dependencies on other IGs.












### Global Profiles

*There are no Global profiles defined*

### Copyrights

This publication includes IP covered under the following statements.

* (c) 2020 HL7.org

* [SDOHCC CodeSystem Temporary Codes](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md): [CDE payer's SDOH condition patients](Group-SDOHCC-GroupSDOHPatientsForPayerExample.md), [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md)...Show 70 more,[Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md),[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md),[Goal/SDOHCC-GoalFoodSecurityExample](Goal-SDOHCC-GoalFoodSecurityExample.md),[HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md),[Observation/SDOHCC-ObservationAssessmentInadequateFoodIntakeExample](Observation-SDOHCC-ObservationAssessmentInadequateFoodIntakeExample.md),[Observation/SDOHCC-ObservationAssessmentTransportTooExpensiveExample](Observation-SDOHCC-ObservationAssessmentTransportTooExpensiveExample.md),[Observation/SDOHCC-ObservationEnrollmentStatusExample](Observation-SDOHCC-ObservationEnrollmentStatusExample.md),[Observation/SDOHCC-ObservationEthnicityOMBExample](Observation-SDOHCC-ObservationEthnicityOMBExample.md),[Observation/SDOHCC-ObservationGenderIdentityExample](Observation-SDOHCC-ObservationGenderIdentityExample.md),[Observation/SDOHCC-ObservationPersonalPronounsExample](Observation-SDOHCC-ObservationPersonalPronounsExample.md),[Observation/SDOHCC-ObservationRaceOMBExample](Observation-SDOHCC-ObservationRaceOMBExample.md),[Observation/SDOHCC-ObservationRaceOMBMotherExample](Observation-SDOHCC-ObservationRaceOMBMotherExample.md),[Observation/SDOHCC-ObservationRaceOMBPractitionerExample](Observation-SDOHCC-ObservationRaceOMBPractitionerExample.md),[Observation/SDOHCC-ObservationRecordedSexGenderExample](Observation-SDOHCC-ObservationRecordedSexGenderExample.md),[Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESGroupingExample](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion1Example](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion5Example](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion6Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md),[Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md),[Observation/SDOHCC-ObservationSexualOrientationExample](Observation-SDOHCC-ObservationSexualOrientationExample.md),[Procedure/SDOHCC-ProcedureFoodPantryApplicationAssistanceExample](Procedure-SDOHCC-ProcedureFoodPantryApplicationAssistanceExample.md),[Procedure/SDOHCC-ProcedureProvisionOfFoodExample](Procedure-SDOHCC-ProcedureProvisionOfFoodExample.md),[Procedure/SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample](Procedure-SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample.md),[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md),[SDOHCCExtensionHealthcareServiceCapacityStatus](StructureDefinition-SDOHCC-ExtensionHealthcareServiceCapacityStatus.md),[SDOHCCGoal](StructureDefinition-SDOHCC-Goal.md),[SDOHCCGroup](StructureDefinition-SDOHCC-Group.md),[SDOHCCHealthcareServiceForReferralManagement](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md),[SDOHCCObservationAssessment](StructureDefinition-SDOHCC-ObservationAssessment.md),[SDOHCCObservationEthnicityOMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md),[SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md),[SDOHCCObservationPersonalCharacteristic](StructureDefinition-SDOHCC-ObservationPersonalCharacteristic.md),[SDOHCCObservationPersonalPronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md),[SDOHCCObservationProgramEnrollmentStatus](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md),[SDOHCCObservationRaceOMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md),[SDOHCCObservationRecordedSexGender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md),[SDOHCCObservationScreeningResponse](StructureDefinition-SDOHCC-ObservationScreeningResponse.md),[SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md),[SDOHCCProcedure](StructureDefinition-SDOHCC-Procedure.md),[SDOHCCServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md),[SDOHCCTaskForPatient](StructureDefinition-SDOHCC-TaskForPatient.md),[SDOHCCTaskForReferralManagement](StructureDefinition-SDOHCC-TaskForReferralManagement.md),[SDOHCCValueSetCapacityStatus](ValueSet-SDOHCC-ValueSetCapacityStatus.md),[SDOHCCValueSetObservationMethod](ValueSet-SDOHCC-ValueSetObservationMethod.md),[SDOHCCValueSetProgramEnrollmentCategory](ValueSet-SDOHCC-ValueSetEnrollmentCategory.md),[SDOHCCValueSetProgramEnrollmentStatus](ValueSet-SDOHCC-ValueSetEnrollmentStatus.md),[SDOHCCValueSetSDOHCategory](ValueSet-SDOHCC-ValueSetSDOHCategory.md),[SDOHCCValueSetSDOHQuestionnaireCategory](ValueSet-SDOHCC-ValueSetSDOHQuestionnaireCategory.md),[SDOHCCValueSetTaskCode](ValueSet-SDOHCC-ValueSetTaskCode.md),[ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md),[ServiceRequest/SDOHCC-ServiceRequestActiveWICReferralExample](ServiceRequest-SDOHCC-ServiceRequestActiveWICReferralExample.md),[ServiceRequest/SDOHCC-ServiceRequestSubreferralGardenProgramExample](ServiceRequest-SDOHCC-ServiceRequestSubreferralGardenProgramExample.md),[ServiceRequest/SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample](ServiceRequest-SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample.md),[Task/SDOHCC-TaskContentRichReferralWICExample](Task-SDOHCC-TaskContentRichReferralWICExample.md),[Task/SDOHCC-TaskPatientInformationRequestCompletedExample](Task-SDOHCC-TaskPatientInformationRequestCompletedExample.md),[Task/SDOHCC-TaskPatientMakeAppointmentCompletedExample](Task-SDOHCC-TaskPatientMakeAppointmentCompletedExample.md),[Task/SDOHCC-TaskPatientReviewInformationCompletedExample](Task-SDOHCC-TaskPatientReviewInformationCompletedExample.md),[Task/SDOHCC-TaskPatientRiskQuestionnaireCompletedExample](Task-SDOHCC-TaskPatientRiskQuestionnaireCompletedExample.md),[Task/SDOHCC-TaskReferralForFurtherAssessmentExample](Task-SDOHCC-TaskReferralForFurtherAssessmentExample.md),[Task/SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample](Task-SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample.md)and[Task/SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample](Task-SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.1.0/CodeSystem-ISO3166Part1.html): [SDOHCCCodeSystemTemporaryCodes](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md), [SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md)...Show 55 more,[SDOHCCConsent](StructureDefinition-SDOHCC-Consent.md),[SDOHCCExtensionConditionAsserter](StructureDefinition-SDOHCC-ExtensionConditionAsserter.md),[SDOHCCExtensionHealthcareServiceCapacityStatus](StructureDefinition-SDOHCC-ExtensionHealthcareServiceCapacityStatus.md),[SDOHCCExtensionHealthcareServiceTelecomAppointment](StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.md),[SDOHCCGoal](StructureDefinition-SDOHCC-Goal.md),[SDOHCCGroup](StructureDefinition-SDOHCC-Group.md),[SDOHCCHealthcareService](StructureDefinition-SDOHCC-HealthcareService.md),[SDOHCCHealthcareServiceForReferralManagement](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md),[SDOHCCHungerVitalSignMap](StructureMap-SDOHCC-StructureMapHungerVitalSign.md),[SDOHCCLocation](StructureDefinition-SDOHCC-Location.md),[SDOHCCObservationAssessment](StructureDefinition-SDOHCC-ObservationAssessment.md),[SDOHCCObservationEthnicityOMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md),[SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md),[SDOHCCObservationPersonalCharacteristic](StructureDefinition-SDOHCC-ObservationPersonalCharacteristic.md),[SDOHCCObservationPersonalPronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md),[SDOHCCObservationProgramEnrollmentStatus](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md),[SDOHCCObservationRaceOMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md),[SDOHCCObservationRecordedSexGender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md),[SDOHCCObservationScreeningResponse](StructureDefinition-SDOHCC-ObservationScreeningResponse.md),[SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md),[SDOHCCPRAPAREMap](StructureMap-SDOHCC-StructureMapPRAPARE.md),[SDOHCCPractitionerRole](StructureDefinition-SDOHCC-practitionerrole.md),[SDOHCCProcedure](StructureDefinition-SDOHCC-Procedure.md),[SDOHCCQuestionnaireHungerVitalSign](Questionnaire-SDOHCC-QuestionnaireHungerVitalSign.md),[SDOHCCQuestionnairePRAPARE](Questionnaire-SDOHCC-QuestionnairePRAPARE.md),[SDOHCCServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md),[SDOHCCTaskForPatient](StructureDefinition-SDOHCC-TaskForPatient.md),[SDOHCCTaskForReferralManagement](StructureDefinition-SDOHCC-TaskForReferralManagement.md),[SDOHCCValueSetCapacityStatus](ValueSet-SDOHCC-ValueSetCapacityStatus.md),[SDOHCCValueSetHealthcareServiceType](ValueSet-SDOHCC-ValueSetHealthcareServiceType.md),[SDOHCCValueSetLOINCSNOMEDCT](ValueSet-SDOHCC-ValueSetLOINCSNOMEDCT.md),[SDOHCCValueSetOMBEthnicityCategories](ValueSet-SDOHCC-ValueSetOMBEthnicityCategories.md),[SDOHCCValueSetOMBRaceCategories](ValueSet-SDOHCC-ValueSetOMBRaceCategories.md),[SDOHCCValueSetObservationDataAbsentReason](ValueSet-SDOHCC-ValueSetObservationDataAbsentReason.md),[SDOHCCValueSetObservationDerivedFromIdType](ValueSet-SDOHCC-ValueSetObservationDerivedFromIdType.md),[SDOHCCValueSetObservationMethod](ValueSet-SDOHCC-ValueSetObservationMethod.md),[SDOHCCValueSetObservationStatus](ValueSet-SDOHCC-ValueSetObservationStatus.md),[SDOHCCValueSetProgramEnrollmentCategory](ValueSet-SDOHCC-ValueSetEnrollmentCategory.md),[SDOHCCValueSetProgramEnrollmentStatus](ValueSet-SDOHCC-ValueSetEnrollmentStatus.md),[SDOHCCValueSetPronounsValue](ValueSet-SDOHCC-ValueSetPronounsValue.md),[SDOHCCValueSetReferralTaskStatus](ValueSet-SDOHCC-ValueSetReferralTaskStatus.md),[SDOHCCValueSetSDOHCategory](ValueSet-SDOHCC-ValueSetSDOHCategory.md),[SDOHCCValueSetSDOHQuestionnaireCategory](ValueSet-SDOHCC-ValueSetSDOHQuestionnaireCategory.md),[SDOHCCValueSetServiceCategory](ValueSet-SDOHCC-ValueSetServiceCategory.md),[SDOHCCValueSetTaskCode](ValueSet-SDOHCC-ValueSetTaskCode.md),[SDOHCCValueSetTaskPriority](ValueSet-SDOHCC-ValueSetTaskPriority.md),[SDOHCCValueSetTaskStatus](ValueSet-SDOHCC-ValueSetTaskStatus.md),[SDOHCC_CoordinationPlatform](CapabilityStatement-SDOHCC-CoordinationPlatform.md),[SDOHCC_PatientApp](CapabilityStatement-SDOHCC-PatientApp.md),[SDOHCC_ReferralRecipient](CapabilityStatement-SDOHCC-ReferralRecipient.md),[SDOHCC_ReferralRecipientLight](CapabilityStatement-SDOHCC-ReferralRecipientLight.md),[SDOHCC_ReferralSource](CapabilityStatement-SDOHCC-ReferralSource.md),[Sdohclinicalcare](index.md),[ServiceRequestSupportingInfo](SearchParameter-ServiceRequest-supporting-info.md)and[TaskOutputReference](SearchParameter-Task-output-reference.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/6.1.0/CodeSystem-CVX.html): [Immunization/SDOHCC-ImmunizationChildhoodImmunizationsExample](Immunization-SDOHCC-ImmunizationChildhoodImmunizationsExample.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.1.0/CodeSystem-v3-ucum.html): [Observation/SDOHCC-LabObservationLeadLevelExample](Observation-SDOHCC-LabObservationLeadLevelExample.md), [Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md)...Show 6 more,[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-VitalSignsHeightExample](Observation-SDOHCC-VitalSignsHeightExample.md),[Observation/SDOHCC-VitalSignsWeightExample](Observation-SDOHCC-VitalSignsWeightExample.md),[SDOHCCObservationScreeningResponse](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)and[SDOHCCQuestionnairePRAPARE](Questionnaire-SDOHCC-QuestionnairePRAPARE.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.1.0/CodeSystem-v3-loinc.html): [Goal/SDOHCC-GoalFoodSecurityExample](Goal-SDOHCC-GoalFoodSecurityExample.md), [Observation/SDOHCC-LabObservationLeadLevelExample](Observation-SDOHCC-LabObservationLeadLevelExample.md)...Show 41 more,[Observation/SDOHCC-ObservationEthnicityOMBExample](Observation-SDOHCC-ObservationEthnicityOMBExample.md),[Observation/SDOHCC-ObservationGenderIdentityExample](Observation-SDOHCC-ObservationGenderIdentityExample.md),[Observation/SDOHCC-ObservationPersonalPronounsExample](Observation-SDOHCC-ObservationPersonalPronounsExample.md),[Observation/SDOHCC-ObservationRaceOMBExample](Observation-SDOHCC-ObservationRaceOMBExample.md),[Observation/SDOHCC-ObservationRaceOMBMotherExample](Observation-SDOHCC-ObservationRaceOMBMotherExample.md),[Observation/SDOHCC-ObservationRaceOMBPractitionerExample](Observation-SDOHCC-ObservationRaceOMBPractitionerExample.md),[Observation/SDOHCC-ObservationRecordedSexGenderExample](Observation-SDOHCC-ObservationRecordedSexGenderExample.md),[Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESGroupingExample](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion1Example](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion5Example](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion6Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md),[Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md),[Observation/SDOHCC-ObservationSexualOrientationExample](Observation-SDOHCC-ObservationSexualOrientationExample.md),[Observation/SDOHCC-VitalSignsHeightExample](Observation-SDOHCC-VitalSignsHeightExample.md),[Observation/SDOHCC-VitalSignsWeightExample](Observation-SDOHCC-VitalSignsWeightExample.md),[QuestionnaireResponse/SDOHCC-QuestionnaireResponseHungerVitalSignExample](QuestionnaireResponse-SDOHCC-QuestionnaireResponseHungerVitalSignExample.md),[QuestionnaireResponse/SDOHCC-QuestionnaireResponsePRAPAREExample](QuestionnaireResponse-SDOHCC-QuestionnaireResponsePRAPAREExample.md),[SDOHCCGoal](StructureDefinition-SDOHCC-Goal.md),[SDOHCCObservationAssessment](StructureDefinition-SDOHCC-ObservationAssessment.md),[SDOHCCObservationEthnicityOMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md),[SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md),[SDOHCCObservationPersonalCharacteristic](StructureDefinition-SDOHCC-ObservationPersonalCharacteristic.md),[SDOHCCObservationPersonalPronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md),[SDOHCCObservationRaceOMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md),[SDOHCCObservationRecordedSexGender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md),[SDOHCCObservationScreeningResponse](StructureDefinition-SDOHCC-ObservationScreeningResponse.md),[SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md),[SDOHCCProcedure](StructureDefinition-SDOHCC-Procedure.md),[SDOHCCQuestionnaireHungerVitalSign](Questionnaire-SDOHCC-QuestionnaireHungerVitalSign.md),[SDOHCCQuestionnairePRAPARE](Questionnaire-SDOHCC-QuestionnairePRAPARE.md),[SDOHCCServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md),[SDOHCCTaskForReferralManagement](StructureDefinition-SDOHCC-TaskForReferralManagement.md),[SDOHCCValueSetLOINCSNOMEDCT](ValueSet-SDOHCC-ValueSetLOINCSNOMEDCT.md)and[SDOHCCValueSetPronounsValue](ValueSet-SDOHCC-ValueSetPronounsValue.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md), [Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md)...Show 30 more,[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md),[Device/SDOHCC-DeviceSoftwareExample](Device-SDOHCC-DeviceSoftwareExample.md),[Goal/SDOHCC-GoalFoodSecurityExample](Goal-SDOHCC-GoalFoodSecurityExample.md),[Immunization/SDOHCC-ImmunizationChildhoodImmunizationsExample](Immunization-SDOHCC-ImmunizationChildhoodImmunizationsExample.md),[Observation/SDOHCC-ObservationAssessmentInadequateFoodIntakeExample](Observation-SDOHCC-ObservationAssessmentInadequateFoodIntakeExample.md),[Observation/SDOHCC-ObservationAssessmentTransportTooExpensiveExample](Observation-SDOHCC-ObservationAssessmentTransportTooExpensiveExample.md),[Observation/SDOHCC-ObservationEnrollmentStatusExample](Observation-SDOHCC-ObservationEnrollmentStatusExample.md),[Observation/SDOHCC-ObservationGenderIdentityExample](Observation-SDOHCC-ObservationGenderIdentityExample.md),[PractitionerRole/SDOHCC-PractitionerRoleDrJanWaterExample](PractitionerRole-SDOHCC-PractitionerRoleDrJanWaterExample.md),[Procedure/SDOHCC-ProcedureFoodPantryApplicationAssistanceExample](Procedure-SDOHCC-ProcedureFoodPantryApplicationAssistanceExample.md),[Procedure/SDOHCC-ProcedureProvisionOfFoodExample](Procedure-SDOHCC-ProcedureProvisionOfFoodExample.md),[Procedure/SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample](Procedure-SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample.md),[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md),[SDOHCCGoal](StructureDefinition-SDOHCC-Goal.md),[SDOHCCHealthcareService](StructureDefinition-SDOHCC-HealthcareService.md),[SDOHCCObservationAssessment](StructureDefinition-SDOHCC-ObservationAssessment.md),[SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md),[SDOHCCObservationProgramEnrollmentStatus](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md),[SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md),[SDOHCCPractitionerRole](StructureDefinition-SDOHCC-practitionerrole.md),[SDOHCCProcedure](StructureDefinition-SDOHCC-Procedure.md),[SDOHCCServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md),[SDOHCCTaskForReferralManagement](StructureDefinition-SDOHCC-TaskForReferralManagement.md),[SDOHCCValueSetLOINCSNOMEDCT](ValueSet-SDOHCC-ValueSetLOINCSNOMEDCT.md),[ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md),[ServiceRequest/SDOHCC-ServiceRequestActiveWICReferralExample](ServiceRequest-SDOHCC-ServiceRequestActiveWICReferralExample.md),[ServiceRequest/SDOHCC-ServiceRequestSubreferralGardenProgramExample](ServiceRequest-SDOHCC-ServiceRequestSubreferralGardenProgramExample.md)and[ServiceRequest/SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample](ServiceRequest-SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Condition Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-category.html): [SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.0/CodeSystem-condition-clinical.html): [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md), [Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md)...Show 4 more,[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md)and[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.0/CodeSystem-condition-ver-status.html): [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md), [Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md)...Show 4 more,[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md)and[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md)
* [Consent PolicyRule Codes](http://terminology.hl7.org/7.0.0/CodeSystem-consentpolicycodes.html): [Consent/SDOHCC-ConsentInformationDisclosureExample](Consent-SDOHCC-ConsentInformationDisclosureExample.md)
* [Consent Scope Codes](http://terminology.hl7.org/7.0.0/CodeSystem-consentscope.html): [Consent/SDOHCC-ConsentInformationDisclosureExample](Consent-SDOHCC-ConsentInformationDisclosureExample.md)
* [DataAbsentReason](http://terminology.hl7.org/7.0.0/CodeSystem-data-absent-reason.html): [SDOHCCObservationEthnicityOMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md), [SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md), [SDOHCCObservationRaceOMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md), [SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md) and [SDOHCCValueSetObservationDataAbsentReason](ValueSet-SDOHCC-ValueSetObservationDataAbsentReason.md)
* [Goal achievement status](http://terminology.hl7.org/7.0.0/CodeSystem-goal-achievement.html): [Goal/SDOHCC-GoalFoodSecurityExample](Goal-SDOHCC-GoalFoodSecurityExample.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.0/CodeSystem-observation-category.html): [Observation/SDOHCC-LabObservationLeadLevelExample](Observation-SDOHCC-LabObservationLeadLevelExample.md), [Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md)...Show 14 more,[Observation/SDOHCC-ObservationResponseNHANESGroupingExample](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion1Example](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion5Example](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion6Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md),[Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md),[Observation/SDOHCC-VitalSignsHeightExample](Observation-SDOHCC-VitalSignsHeightExample.md),[Observation/SDOHCC-VitalSignsWeightExample](Observation-SDOHCC-VitalSignsWeightExample.md)and[SDOHCCObservationScreeningResponse](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)
* [Program](http://terminology.hl7.org/7.0.0/CodeSystem-program.html): [HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md)
* [Service type](http://terminology.hl7.org/7.0.0/CodeSystem-service-type.html): [HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md), [SDOHCCHealthcareService](StructureDefinition-SDOHCC-HealthcareService.md) and [SDOHCCValueSetHealthcareServiceType](ValueSet-SDOHCC-ValueSetHealthcareServiceType.md)
* [identifierType](http://terminology.hl7.org/7.0.0/CodeSystem-v2-0203.html): [Observation/SDOHCC-ObservationRecordedSexGenderExample](Observation-SDOHCC-ObservationRecordedSexGenderExample.md), [Patient/SDOHCC-PatientBabyAbbas](Patient-SDOHCC-PatientBabyAbbas.md), [Patient/pat-53234](Patient-pat-53234.md), [SDOHCCObservationRecordedSexGender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md) and [SDOHCCValueSetObservationDerivedFromIdType](ValueSet-SDOHCC-ValueSetObservationDerivedFromIdType.md)
* [ActCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ActCode.html): [Consent/SDOHCC-ConsentInformationDisclosureExample](Consent-SDOHCC-ConsentInformationDisclosureExample.md) and [SDOHCCConsent](StructureDefinition-SDOHCC-Consent.md)
* [NullFlavor](http://terminology.hl7.org/7.0.0/CodeSystem-v3-NullFlavor.html): [SDOHCCObservationEthnicityOMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md), [SDOHCCObservationGenderIdentity](StructureDefinition-SDOHCC-ObservationGenderIdentity.md)...Show 6 more,[SDOHCCObservationPersonalPronouns](StructureDefinition-SDOHCC-ObservationPersonalPronouns.md),[SDOHCCObservationRaceOMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md),[SDOHCCObservationRecordedSexGender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md),[SDOHCCObservationSexualOrientation](StructureDefinition-SDOHCC-ObservationSexualOrientation.md),[SDOHCCValueSetObservationMethod](ValueSet-SDOHCC-ValueSetObservationMethod.md)and[SDOHCCValueSetPronounsValue](ValueSet-SDOHCC-ValueSetPronounsValue.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ObservationInterpretation.html): [Observation/SDOHCC-LabObservationLeadLevelExample](Observation-SDOHCC-LabObservationLeadLevelExample.md) and [Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md)
* [ParticipationFunction](http://terminology.hl7.org/7.0.0/CodeSystem-v3-ParticipationFunction.html): [SDOHCCPractitionerRole](StructureDefinition-SDOHCC-practitionerrole.md)
* [RoleCode](http://terminology.hl7.org/7.0.0/CodeSystem-v3-RoleCode.html): [RelatedPerson/SDOHCC-RelatedPersonMotherExample](RelatedPerson-SDOHCC-RelatedPersonMotherExample.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core Condition Category Extension Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-condition-category.html): [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md), [Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md)...Show 4 more,[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md)and[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md)
* [US Core Category](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-category.html): [Condition/SDOHCC-ConditionAsserterDeviceExample](Condition-SDOHCC-ConditionAsserterDeviceExample.md), [Condition/SDOHCC-ConditionFoodInsecurityExample](Condition-SDOHCC-ConditionFoodInsecurityExample.md)...Show 22 more,[Condition/SDOHCC-ConditionHomelessExample](Condition-SDOHCC-ConditionHomelessExample.md),[Condition/SDOHCC-ConditionProtectiveFactor](Condition-SDOHCC-ConditionProtectiveFactor.md),[Condition/SDOHCC-ConditionUnemployedExample](Condition-SDOHCC-ConditionUnemployedExample.md),[HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md),[Observation/SDOHCC-ObservationAssessmentInadequateFoodIntakeExample](Observation-SDOHCC-ObservationAssessmentInadequateFoodIntakeExample.md),[Observation/SDOHCC-ObservationAssessmentTransportTooExpensiveExample](Observation-SDOHCC-ObservationAssessmentTransportTooExpensiveExample.md),[Observation/SDOHCC-ObservationEnrollmentStatusExample](Observation-SDOHCC-ObservationEnrollmentStatusExample.md),[Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESGroupingExample](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion1Example](Observation-SDOHCC-ObservationResponseNHANESQuestion1Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion2Example](Observation-SDOHCC-ObservationResponseNHANESQuestion2Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion3Example](Observation-SDOHCC-ObservationResponseNHANESQuestion3Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion4Example](Observation-SDOHCC-ObservationResponseNHANESQuestion4Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion5Example](Observation-SDOHCC-ObservationResponseNHANESQuestion5Example.md),[Observation/SDOHCC-ObservationResponseNHANESQuestion6Example](Observation-SDOHCC-ObservationResponseNHANESQuestion6Example.md),[Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md),[Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md),[SDOHCCCondition](StructureDefinition-SDOHCC-Condition.md),[SDOHCCHealthcareServiceForReferralManagement](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md)and[SDOHCCValueSetServiceCategory](ValueSet-SDOHCC-ValueSetServiceCategory.md)


### Parameter Settings

The following [IG Parameters](https://confluence.hl7.org/display/FHIR/Implementation+Guide+Parameters) are set for this Implementation Guide:

### Expansion Parameters

In HL7 FHIR, expansion parameters are special query parameters that you can pass to a ValueSet $expand operation to control and customize how the ValueSet is expanded (i.e., how the full list of codes/concepts is generated from the ValueSet definition). Gravity SDOH Clinical Care uses the following parameters.

* Parameter: system-version
  * Value: SNOMED CT[US]



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.sdoh-clinicalcare",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare",
  "version" : "3.0.0-ballot",
  "name" : "Sdohclinicalcare",
  "title" : "SDOH Clinical Care",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "This HL7 Implementation Guide (IG) defines how to exchange Social Determinants of Health (SDOH) content defined by the Gravity Project using the HL7 FHIR standard..",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.sdoh-clinicalcare",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "uscore",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "All profiles in this IG are aligned with US Core 7.0.0. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations.\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    },
    {
      "id" : "uscore6",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "All profiles in this IG are aligned with US Core 6.1.0 as much as possible. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations.\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v610/ImplementationGuide/hl7.fhir.us.core.v610",
      "packageId" : "hl7.fhir.us.core.v610",
      "version" : "6.1.0"
    },
    {
      "id" : "uscore3",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "All profiles in this IG are aligned with US Core 3.1.1 as much as possible. U.S. Core also sets expectations for a variety of referenced resources and establishes baseline conformance expectations.    \n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/core/v311/ImplementationGuide/hl7.fhir.us.core.v311",
      "packageId" : "hl7.fhir.us.core.v311",
      "version" : "3.1.1"
    },
    {
      "id" : "sdc",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "SDC is the basis for mapping QuestionnaireResponses to Observations and Conditions. SDC also provides guidance around how questionnaires can be created with support for score calculation, conditional behavior, specific rendering expectations, etc.\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/uv/sdc/ImplementationGuide/hl7.fhir.uv.sdc",
      "packageId" : "hl7.fhir.uv.sdc",
      "version" : "3.0.0"
    },
    {
      "id" : "sdohsub",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Subscriptions are recommended for monitoring completion of referrals.\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/uv/subscriptions-backport/ImplementationGuide/hl7.fhir.uv.subscriptions-backport",
      "packageId" : "hl7.fhir.uv.subscriptions-backport.r4",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_terminology_r4",
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hrex",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "This guide links out to concept maps published in Da Vinci HRex for Provider Role codes.\n"
        }
      ],
      "uri" : "http://hl7.org/fhir/us/davinci-hrex/ImplementationGuide/hl7.fhir.us.davinci-hrex",
      "packageId" : "hl7.fhir.us.davinci-hrex",
      "version" : "1.1.0"
    },
    {
      "id" : "vsac",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-ImplementationGuide.dependsOn.reason",
          "valueMarkdown" : "Gravity Project social risk data elements are published in Value Set Authority Center (VSAC) value sets. The value sets can be identified by searching for \"The Gravity Project\" steward. You will need to create a free National Library of Medicine (NLM) account to access the value sets. Value sets will be updated bi-annually on June 30th and December 31st.  \n"
        }
      ],
      "uri" : "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac",
      "packageId" : "us.nlm.vsac",
      "version" : "0.24.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 3 Ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "jira-code"
          },
          {
            "url" : "value",
            "valueString" : "sdoh-cc"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "en"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2021+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 3 Ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "jira-code"
          },
          {
            "url" : "value",
            "valueString" : "sdoh-cc"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/sdoh-clinicalcare/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "i18n-default-lang"
          },
          {
            "url" : "value",
            "valueString" : "en"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/pat-53234"
        },
        "name" : "Patient Colin Abbas Example",
        "description" : "An example of a patient. This example is used as the referenced patient in other examples in this IG.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/SDOHCC-CodeSystemTemporaryCodes"
        },
        "name" : "SDOHCC CodeSystem Temporary Codes",
        "description" : "A local code system defined within the context of the SDOH-CC IG.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Condition"
        },
        "name" : "SDOHCC Condition",
        "description" : "Profile for Social Determinants of Health (SDOH) conditions.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/SDOHCC-ConditionAsserterDeviceExample"
        },
        "name" : "SDOHCC Condition Asserter Device Example",
        "description" : "An example of a food insecurity Condition that references, as evidence, Observations derived from the LOINC Hunger Vital Sign [HVS] questionnaire (88121-9) and uses an extension on Condition.asserter to reference the software device that uses the answers to HVS questions 1 and 2 to derive the answer to HVS question 3 (at risk for food insecurity).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
        },
        "name" : "SDOHCC Condition Food Insecurity Example",
        "description" : "An example of a food insecurity Condition (a health concern) that references, as evidence, Observations derived from the LOINC Hunger Vital Sign [HVS] questionnaire (88121-9).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/SDOHCC-ConditionHomelessExample"
        },
        "name" : "SDOHCC Condition Homeless Example",
        "description" : "An example of a homelessness Condition (a health concern) that is based on an Observation related to housing status that is derived from a QuestionnaireResponse to PRAPARE (represented in LOINC).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/SDOHCC-ConditionProtectiveFactor"
        },
        "name" : "SDOHCC Condition Protective Factor Example",
        "description" : "An example of a Condition (a health concern) that is based on an Observation related to a protective factor.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/SDOHCC-ConditionUnemployedExample"
        },
        "name" : "SDOHCC Condition Unemployed Example",
        "description" : "An example of a Condition (a health concern) that is based on an Observation related to employment status that is derived from a QuestionnaireResponse to PRAPARE (represented in LOINC).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Consent"
        },
        "name" : "SDOHCC Consent",
        "description" : "Profile for consent related to the release of Social Determinants of Health (SDOH) information to non-HIPAA covered organizations.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/SDOHCC-ConsentInformationDisclosureExample"
        },
        "name" : "SDOHCC Consent Information Disclosure Example",
        "description" : "An example of a Consent for information disclosure related to SDOH information.   A [PDF](ExampleConsent.pdf) is attached to this consent.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Consent"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDOHCC-CoordinationPlatform"
        },
        "name" : "SDOHCC Coordination Platform Capability Statement",
        "description" : "This resource describes the required and desired behavior of systems acting as SDOH clinical care 'coordination platforms' (CPs).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/SDOHCC-DeviceSoftwareExample"
        },
        "name" : "SDOHCC Device Software Example",
        "description" : "An example of a software device. This example is used as the referenced device in other SDOHCC examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/DocumentReferenceExample"
        },
        "name" : "SDOHCC DocumentReference Diabetes Handout Example",
        "description" : "Document Reference for a Diabetes Handout. An example of a DocumentReference for a diabetes handout. This example is used as the referenced document in other IG examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ExtensionConditionAsserter"
        },
        "name" : "SDOHCC Extension Condition Asserter",
        "description" : "Extension for allowing the asserter of a condition to be Device (that was used to perform an operation to arrive at the condition).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ExtensionHealthcareServiceCapacityStatus"
        },
        "name" : "SDOHCC Extension HealthcareService Capacity Status",
        "description" : "Extension for determining the capacity status of a health care service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment"
        },
        "name" : "SDOHCC Extension HealthcareService Telecom Appointment",
        "description" : "Extension for flagging a HealthcareService.telecom as one the patient can use to make an appointment.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Goal"
        },
        "name" : "SDOHCC Goal",
        "description" : "Profile for goals that address Social Determinants of Health (SDOH).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/SDOHCC-GoalFoodSecurityExample"
        },
        "name" : "SDOHCC Goal Food Security Example",
        "description" : "An example of a food security Goal that addresses a food insecurity Condition.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Group"
        },
        "name" : "SDOHCC Group",
        "description" : "Profile for identifying groups of patients who have a Social Determinants of Health (SDOH) condition and are members of a specific payer organization.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Group"
          }
        ],
        "reference" : {
          "reference" : "Group/SDOHCC-GroupSDOHPatientsForPayerExample"
        },
        "name" : "SDOHCC Group SDOH Patients For Payer Example",
        "description" : "An example of Group for patients that have any SDOH condition and are members of a specific payer organization.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-HealthcareService"
        },
        "name" : "SDOHCC Healthcare Service",
        "description" : "Profile that describes the means by which a healthcare service can be contacted.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-HealthcareServiceForReferralManagement"
        },
        "name" : "SDOHCC Healthcare Service for Referral Management",
        "description" : "Profile that extends SDOHCC HealthcareService to support capacity status queries, allowing referral sources to determine if a CBO has capacity before initiating a referral. Includes the capacity-status extension and elements for describing services, programs, and contact information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/SDOHCC-HealthcareServiceSocialCareProgram"
        },
        "name" : "SDOHCC HealthcareService Social Care Program Example",
        "description" : "An example of a HealthcareService with information about a social care program.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareServiceForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/SDOHCC-HealthcareServiceTelecomAppointmentExample"
        },
        "name" : "SDOHCC HealthcareService Telecom Appointment Example",
        "description" : "An example of a HealthcareService with telecom(s) that can be used to make an appointment flagged. This example is used as the referenced healthcare service in other IG examples.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/SDOHCC-ImmunizationChildhoodImmunizationsExample"
        },
        "name" : "SDOHCC Immunization Childhood Immunizations Example",
        "description" : "An example of an immunization record for childhood immunizations.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-LabObservationLeadLevelExample"
        },
        "name" : "SDOHCC Lab Observation Lead Level Example",
        "description" : "An example of a laboratory result observation for lead level.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Location"
        },
        "name" : "SDOHCC Location",
        "description" : "Profile that describes address information for a healthcare service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/SDOHCC-LocationExample"
        },
        "name" : "SDOHCC Location Example",
        "description" : "An example of a Location for a HealthcareService that the patient might want to schedule an appointment at. This example is used as the referenced location in other IG examples.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationAssessment"
        },
        "name" : "SDOHCC Observation Assessment",
        "description" : "Profile for Social Determinants of Health (SDOH) observations that involve assessment (e.g., by a provider, payer, etc.) as opposed to being derived only from screening surveys (as is the case for the SDOHCC Screening Response Observation).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationAssessmentInadequateFoodIntakeExample"
        },
        "name" : "SDOHCC Observation Assessment Inadequate Food Intake Example",
        "description" : "An example of an inadequate food intake Observation that is not necessarily derived only from a screening survey. This observation involves additional assessment (e.g., by a provider, payer, etc.).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationAssessmentTransportTooExpensiveExample"
        },
        "name" : "SDOHCC Observation Assessment Transport Too Expensive Example",
        "description" : "An example of a transportation Observation that is not necessarily derived only from a screening survey. This observation involves additional assessment (e.g., by a provider, payer, etc.). This example also includes an Observation.category (i.e., Transportation Insecurity) that is included in the “SDOHCC ValueSet SDOH Category”. Additionally, a subcategory of Transportation Insecurity (i.e., Transportation Insecurity Financial) is included to illustrate that it is possible to further subcategorize a “SDOHCC ValueSet SDOH Category” code with a code that is not in the ValueSet.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationEnrollmentStatusExample"
        },
        "name" : "SDOHCC Observation Enrollment Status Example",
        "description" : "An example of a capturing the enrollment status of an individual for a social care program.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationEthnicityOMB"
        },
        "name" : "SDOHCC Observation Ethnicity OMB",
        "description" : "Profile for ethnicity observations that use Office of Management and Budget (OMB) ethnicity category codes and CDC ethnicity codes. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationEthnicityOMBExample"
        },
        "name" : "SDOHCC Observation Ethnicity OMB Example",
        "description" : "An example of an ethnicity Observation where the subject self-reports as Hispanic or Latino with detailed ethnicity information that highlights elements and repetitions.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationEthnicityOMB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationGenderIdentity"
        },
        "name" : "SDOHCC Observation Gender Identity",
        "description" : "Profile for gender identity observations which are based on a person’s inner sense of being a girl/woman/female/feminine, boy/man/male/masculine, nonbinary, something else, or having no gender. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationGenderIdentityExample"
        },
        "name" : "SDOHCC Observation Gender Identity Example",
        "description" : "An example of a gender identity Observation where the subject self-reports their gender identity as male.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationGenderIdentity"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationPersonalCharacteristic"
        },
        "name" : "SDOHCC Observation Personal Characteristic",
        "description" : "Defines constraints that represent the minimum requirement for personal characteristic observations which are observations that are usually self-attested but may be attested to on behalf of the subject and are generally only verifiable by the source of attestation (e.g., race, ethnicity, sexual orientation, gender identity and personal pronouns), but may sometimes be verifiable by someone other than the source of attestation (e.g., recorded sex). For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationPersonalPronouns"
        },
        "name" : "SDOHCC Observation Personal Pronouns",
        "description" : "Profile for observations about the pronouns and possessive adjectives a person wishes to be addressed by. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationPersonalPronounsExample"
        },
        "name" : "SDOHCC Observation Personal Pronouns Example",
        "description" : "An example of a personal pronoun Observation where the subject self-reports their pronoun preference.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationPersonalPronouns"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus"
        },
        "name" : "SDOHCC Observation Program Enrollment Status",
        "description" : "For observations about an individual's enrollment status in a social care program. See [Enrollment Status](enrollment.html) for more additional guidance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationRaceOMB"
        },
        "name" : "SDOHCC Observation Race OMB",
        "description" : "Profile for race observations that use Office of Management and Budget (OMB) race category codes and CDC race codes. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationRaceOMBExample"
        },
        "name" : "SDOHCC Observation Race OMB Example",
        "description" : "An example of a race Observation where the subject self-reports as more than one race with detailed race information that highlights elements and repetitions.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationRaceOMBPractitionerExample"
        },
        "name" : "SDOHCC Observation Race OMB Practitioner Example",
        "description" : "An example of a race Observation that uses a FHIR extension on Observation.subject to make an Observation about the practitioner’s race.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationRecordedSexGender"
        },
        "name" : "SDOHCC Observation Recorded Sex Gender",
        "description" : "Profile for observations about \"recorded sex and gender\" which, in the past, were often used interchangeably. In this context, sex is a biological construct and pertains to a person’s genetics, hormones, and anatomy. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationRecordedSexGenderExample"
        },
        "name" : "SDOHCC Observation Recorded Sex Gender Example",
        "description" : "An example of a recorded sex or gender Observation where a clinic has derived the designation M (male) from the subject’s driver’s license.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRecordedSexGender"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example"
        },
        "name" : "SDOHCC Observation Response Hunger Vital Sign Question 3 Example",
        "description" : "An example of a screening response Observation that represents Food insecurity risk [HVS] (LOINC code 88124-3) from the Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9). The Food insecurity risk [HVS] Observation is not answered directly. Rather, it is determined by the responses to the 2 questions on the Hunger Vital Sign [HVS] questionnaire. For this reason, this Observation does not have an Observation.performer. Additionally, this Observation demonstrates the use of “Observation.interpretation: POS” to indicate a possible Health-Related Social Need or risk in the Food Insecurity domain.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESGroupingExample"
        },
        "name" : "SDOHCC Observation Response NHANES Grouping Example",
        "description" : "An example of an Observation grouping that uses hasMember to group 6 Observations from the LOINC Social connection and isolation panel (LOINC code 76506-5)\nbecause QuestionnaireResponse is not referenced by the 6 individual Observations created from the panel. In the absence of the references to QuestionnaireResponse,\nthis example illustrates how the 6 Observations from the panel can be linked in an Observation grouping.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion1Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 1 Example",
        "description" : "An example of a screening response Observation that represents the first question from the NHANES assessment instrument represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion2Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 2 Example",
        "description" : "An example of a screening response Observation that represents the second question from the NHANES assessment instrument represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion3Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 3 Example",
        "description" : "An example of a screening response Observation that represents the third question from the NHANES assessment instrument represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion4Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 4 Example",
        "description" : "An example of a screening response Observation that represents the fourth question from the NHANES assessment instrument represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion5Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 5 Example",
        "description" : "An example of a screening response Observation that represents the fifth question from the NHANES assessment instrument represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponseNHANESQuestion6Example"
        },
        "name" : "SDOHCC Observation Response NHANES Question 6 Example",
        "description" : "An example of a screening response Observation that represents the score from the NHANES assessment instrument represented in LOINC.  This result is derived from the\nresults of the 5 questions.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponsePRAPAREChildCareNeedExample"
        },
        "name" : "SDOHCC Observation Response PRAPARE Child Care Need Example",
        "description" : "An example of a screening response Observation that represents a question and answer related to unmet child care needs from the PRAPARE questionnaire represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponsePRAPAREClothingNeedExample"
        },
        "name" : "SDOHCC Observation Response PRAPARE Clothing Need Example",
        "description" : "An example of a screening response Observation that represents a question and answer related to unmet clothing needs from the PRAPARE questionnaire represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample"
        },
        "name" : "SDOHCC Observation Response PRAPARE Employment Status Example",
        "description" : "An example of a screening response Observation that represents a question and answer related to employment status from the PRAPARE questionnaire represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationResponsePRAPAREHousingStatusExample"
        },
        "name" : "SDOHCC Observation Response PRAPARE Housing Status Example",
        "description" : "An example of a screening response Observation that represents a question and answer related to housing status from the PRAPARE questionnaire represented in LOINC.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationScreeningResponse"
        },
        "name" : "SDOHCC Observation Screening Response",
        "description" : "Profile for observations that represent question and answer pairs from Social Determinants of Health (SDOH) screening instruments.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ObservationSexualOrientation"
        },
        "name" : "SDOHCC Observation Sexual Orientation",
        "description" : "Profile for observations about the sexual orientation of an individual. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationSexualOrientationExample"
        },
        "name" : "SDOHCC Observation Sexual Orientation Example",
        "description" : "An example of a sexual orientation Observation where the subject self-reports as homosexual.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationSexualOrientation"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SDOHCC-OrganizationClinicExample"
        },
        "name" : "SDOHCC Organization Clinic Example",
        "description" : "An example of a clinic Organization. This example is used as the referenced organization in other IG examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SDOHCC-OrganizationCoordinationPlatformExample"
        },
        "name" : "SDOHCC Organization Coordination Platform Example",
        "description" : "An example of a coordination platform Organization. This example is used as the referenced organization in other IG examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SDOHCC-OrganizationPayerExample"
        },
        "name" : "SDOHCC Organization Payer Example",
        "description" : "An example of a payer organization. This example is used as the referenced organization in other SDOHCC examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/SDOHCC-OrganizationWICCommunityOrganizationExample"
        },
        "name" : "SDOHCC Organization WIC Community Organization Example",
        "description" : "An example organization representing a WIC community organization.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDOHCC-PatientApp"
        },
        "name" : "SDOHCC Patient Application",
        "description" : "This resource describes the required and desired behavior of systems acting as apps for patients and care-givers who need to monitor progress on SDOH referrals and may need to take actions such as filling out forms, booking appointments, etc.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/SDOHCC-PatientBabyAbbas"
        },
        "name" : "SDOHCC Patient Baby Abbas",
        "description" : "An example patient representing Baby Abbas, a 2 year old infant.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/SDOHCC-PractitionerDrJanWaterExample"
        },
        "name" : "SDOHCC Practitioner Dr Jan Water Example",
        "description" : "An example of a Practitioner. This example is used as the referenced practitioner in other IG examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/SDOHCC-PractitionerPatWilliamsMSWExample"
        },
        "name" : "SDOHCC Practitioner Pat Williams Example",
        "description" : "An example of a Practitioner. This example is used as the referenced practitioner in other IG examples.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/SDOHCC-PractitionerRoleDrJanWaterExample"
        },
        "name" : "SDOHCC Practitioner Role Dr Jan Water Example",
        "description" : "An example of a family medicine physician PractitionerRole. This example is used as the referenced practitioner role in other IG examples. Note that this example supports both US Core 3.1.1 and US Core 6.1.0 by providing a `code.coding` with an NUCC code (for US Core 3.1.1) and a SNOMED CT code (for US Core 6.1.0). This is the preferred approach to ensure maximum compliance and usability across systems that may support different versions of US Core.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-practitionerrole"
        },
        "name" : "SDOHCC PractitionerRole",
        "description" : "Profile for practitioner roles that address Social Determinants of Health (SDOH).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-Procedure"
        },
        "name" : "SDOHCC Procedure",
        "description" : "Profile for interventions that address Social Determinants of Health.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/SDOHCC-ProcedureFoodPantryApplicationAssistanceExample"
        },
        "name" : "SDOHCC Procedure Food Pantry Application Assistance Example",
        "description" : "An example of a completed Procedure for assistance with applying to a food pantry that is based on a ServiceRequest and references as its reason a food insecurity Condition.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/SDOHCC-ProcedureProvisionOfFoodExample"
        },
        "name" : "SDOHCC Procedure Provision Of Food Example",
        "description" : "An example of a completed Procedure for provision of food.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/SDOHCC-ProcedureSummerFoodProgramApplicationAssistanceExample"
        },
        "name" : "SDOHCC Procedure Summer Food Program Application Assistance Example",
        "description" : "An example of a completed Procedure for assistance with applying to a summer food program that is based on a ServiceRequest and references as its reason a food insecurity Condition.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/SDOHCC-QuestionnaireHungerVitalSign"
        },
        "name" : "SDOHCC Questionnaire Hunger Vital Sign",
        "description" : "A Questionnaire instance that represents the questions and answers from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9).",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Questionnaire"
          }
        ],
        "reference" : {
          "reference" : "Questionnaire/SDOHCC-QuestionnairePRAPARE"
        },
        "name" : "SDOHCC Questionnaire PRAPARE",
        "description" : "A Questionnaire instance that represents the questions and answers from the PRAPARE questionnaire represented in LOINC (code 93025-5).",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/SDOHCC-QuestionnaireResponseHungerVitalSignExample"
        },
        "name" : "SDOHCC QuestionnaireResponse Hunger Vital Sign Example",
        "description" : "An example of an SDC QuestionnaireResponse that represents questions and selected answers from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9). The example is generated using the LHC-Forms SDC Questionnaire App.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/SDOHCC-QuestionnaireResponsePRAPAREExample"
        },
        "name" : "SDOHCC QuestionnaireResponse PRAPARE Example",
        "description" : "An example of an SDC QuestionnaireResponse that represents questions and selected answers from the PRAPARE questionnaire represented in LOINC (code 93025-5). The example is generated using the LHC-Forms SDC Questionnaire App.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDOHCC-ReferralRecipientLight"
        },
        "name" : "SDOHCC Referral Recipient - Light Capability Statement",
        "description" : "This resource describes the required and desired behavior of systems acting as 'light-weight' SDOH clinical care 'referral recipients'.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDOHCC-ReferralRecipient"
        },
        "name" : "SDOHCC Referral Recipient Capability Statement",
        "description" : "This resource describes the required and desired behavior of systems acting as SDOH clinical care 'referral recipients'.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/SDOHCC-ReferralSource"
        },
        "name" : "SDOHCC Referral Source Capability Statement",
        "description" : "This resource describes the required and desired behavior of systems acting as SDOH clinical care 'referral sources'.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/SDOHCC-RelatedPersonMotherExample"
        },
        "name" : "SDOHCC Related Person Mother Example",
        "description" : "An example of a Related Person who is the mother of the subject/patient (Colin Abbas).",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-ServiceRequest"
        },
        "name" : "SDOHCC ServiceRequest",
        "description" : "Profile for service requests that address Social Determinants of Health.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample"
        },
        "name" : "SDOHCC ServiceRequest Active Food Pantry Application Assist Example",
        "description" : "An example of an active ServiceRequest for assistance with applying to a food pantry that references as its reason a food insecurity Condition.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveWICReferralExample"
        },
        "name" : "SDOHCC ServiceRequest Active WIC Referral Example",
        "description" : "An example of an active ServiceRequest for a referral to the WIC program.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/SDOHCC-ServiceRequestSubreferralGardenProgramExample"
        },
        "name" : "SDOHCC ServiceRequest Subreferral Garden Program Example",
        "description" : "An example of a completed, original-order ServiceRequest (i.e., SDOHCC Service Request Active Food Pantry Application Assist Example) that is based on a Service Request to an intermediary organization (e.g., a Coordination Platform) that then created this Service Request (i.e., Assistance with application for garden program) to be fulfilled by a Community Based Organization.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample"
        },
        "name" : "SDOHCC ServiceRequest Subreferral Summer Food Program Example",
        "description" : "An example of a completed, original-order ServiceRequest (i.e., SDOHCC Service Request Active Food Pantry Application Assist Example) that is based on a Service Request to an intermediary organization (e.g., a Coordination Platform) that then created this Service Request (i.e., Assistance with application for Summer Food Service Program) to be fulfilled by a Community Based Organization.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskContentRichReferralWICExample"
        },
        "name" : "SDOHCC Task Content Rich Referral WIC Example",
        "description" : "An example of an SDOHCC Task For Referral Management that has uses Task.input to provide rich content about a WIC referral.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-TaskForPatient"
        },
        "name" : "SDOHCC Task For Patient",
        "description" : "Profile for SDOH-related tasks to be carried out by the patient or someone acting on their behalf.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskReferralForFurtherAssessmentExample"
        },
        "name" : "SDOHCC Task For Referral For Further Assessment Example",
        "description" : "An example of a Task resource representing a referral for further assessment.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SDOHCC-TaskForReferralManagement"
        },
        "name" : "SDOHCC Task For Referral Management",
        "description" : "Profile for tasks requesting fulfillment of an SDOHCC ServiceRequest (i.e. referral for service) and subsequently tracking and managing the fulfillment of that referral.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskPatientInformationRequestCompletedExample"
        },
        "name" : "SDOHCC Task Patient Information Request Completed Example",
        "description" : "An example of a completed Task For Patient where the task was a request for information.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskPatientMakeAppointmentCompletedExample"
        },
        "name" : "SDOHCC Task Patient Make Appointment Completed Example",
        "description" : "An example of a completed Task For Patient where the task was to make an appointment.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskPatientReviewInformationCompletedExample"
        },
        "name" : "SDOHCC Task Patient Review Information Completed Example",
        "description" : "An example of a completed Task For Patient where the task was to review material.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskPatientRiskQuestionnaireCompletedExample"
        },
        "name" : "SDOHCC Task Patient Risk Questionnaire Completed Example",
        "description" : "An example of a completed Task For Patient where the task was to complete a Hunger Vital Signs questionnaire (a questionnaire of the category ‘risk questionnaire’).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForPatient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskReferralManagementOrderFulfillmentAcceptedExample"
        },
        "name" : "SDOHCC Task Referral Management Order Fulfillment Accepted Example",
        "description" : "An example of an accepted Task For Referral Management that has as the Task.focus a ServiceRequest for assistance with applying to a food pantry.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample"
        },
        "name" : "SDOHCC Task Referral Management Order Fulfillment Completed Example",
        "description" : "An example of a completed Task For Referral Management that has a ServiceRequest for assistance with applying to a food pantry as the Task.focus and a Procedure for assistance with applying to a food pantry as the Task.output.",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskReferralManagementOrderSubtaskAcceptedExample"
        },
        "name" : "SDOHCC Task Referral Management Order Subtask Accepted Example",
        "description" : "An example of an accepted Task For Referral Management that delegates responsibility to fulfill a referral from an intermediary organization to another organization (e.g., when a Coordination Platform receives a Task from a referral source and passes it on to a Community Based Organization).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample"
        },
        "name" : "SDOHCC Task Referral Management Order Subtask Completed Example",
        "description" : "An example of a completed Task For Referral Management that delegates responsibility to fulfill a referral from an intermediary organization to another organization (e.g., when a Coordination Platform receives a Task from a referral source and passes it on to a Community Based Organization).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetCapacityStatus"
        },
        "name" : "SDOHCC ValueSet Capacity Status",
        "description" : "Codes for the capacity status for a service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetHealthcareServiceType"
        },
        "name" : "SDOHCC ValueSet Healthcare Service Type",
        "description" : "Codes for the type of health care service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetLOINCSNOMEDCT"
        },
        "name" : "SDOHCC ValueSet LOINC SNOMEDCT",
        "description" : "This value set contains all of LOINC and SNOMED CT.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetObservationDataAbsentReason"
        },
        "name" : "SDOHCC ValueSet Observation DataAbsentReason",
        "description" : "Codes for the reason an observation does not have a value.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetObservationDerivedFromIdType"
        },
        "name" : "SDOHCC ValueSet Observation DerivedFrom IdType",
        "description" : "Codes for identifiers of target resources from which recorded sex or gender information can be derived.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetObservationMethod"
        },
        "name" : "SDOHCC ValueSet Observation Method",
        "description" : "Codes that represent methods by which an individual's race or ethnicity information can be elicited.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetObservationStatus"
        },
        "name" : "SDOHCC ValueSet Observation Status",
        "description" : "Codes for the status of a screening response observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetOMBEthnicityCategories"
        },
        "name" : "SDOHCC ValueSet OMB Ethnicity Categories",
        "description" : "Codes for the ethnicity categories - 'Hispanic or Latino' and 'Not Hispanic or Latino' - as defined by the [OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf). This value set was created (as opposed to using the US Core OMB Ethnicity Categories value set) to deliberately prevent inclusion of null flavors.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetOMBRaceCategories"
        },
        "name" : "SDOHCC ValueSet OMB Race Categories",
        "description" : "Codes for the five race categories - 'American Indian' or 'Alaska Native','Asian', 'Black or African American', 'Native Hawaiian or Other Pacific Islander', and 'White' - as defined by the [OMB Standards for Maintaining, Collecting, and Presenting Federal Data on Race and Ethnicity, Statistical Policy Directive No. 15, as revised, October 30, 1997](https://www.govinfo.gov/content/pkg/FR-1997-10-30/pdf/97-28653.pdf). This value set was created (as opposed to using the US Core OMB Race Categories value set) to deliberately prevent inclusion of null flavors.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetEnrollmentCategory"
        },
        "name" : "SDOHCC ValueSet Program Enrollment Category",
        "description" : "Codes for the program enrollment category of an observation.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetEnrollmentStatus"
        },
        "name" : "SDOHCC ValueSet Program Enrollment Status",
        "description" : "Codes for the program enrollment status for a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetPronounsValue"
        },
        "name" : "SDOHCC ValueSet Pronouns Value",
        "description" : "Codes for the personal pronouns of an individual.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetReferralTaskStatus"
        },
        "name" : "SDOHCC ValueSet Referral Task Status",
        "description" : "Codes for the status of a referral task.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetSDOHCategory"
        },
        "name" : "SDOHCC ValueSet SDOH Category",
        "description" : "Codes that represent Social Determinants of Health (SDOH) domains.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetSDOHQuestionnaireCategory"
        },
        "name" : "SDOHCC ValueSet SDOH Questionnaire Category",
        "description" : "Codes that represent categories of Social Determinants of Health (SDOH) questionnaires.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetServiceCategory"
        },
        "name" : "SDOHCC ValueSet Service Category",
        "description" : "Codes for the capacity status for a service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetTaskCode"
        },
        "name" : "SDOHCC ValueSet Task Code",
        "description" : "Codes for the general action a task involves.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetTaskPriority"
        },
        "name" : "SDOHCC ValueSet Task Priority",
        "description" : "Codes for the priority of a task for a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SDOHCC-ValueSetTaskStatus"
        },
        "name" : "SDOHCC ValueSet Task Status",
        "description" : "Codes for the status of a task for a patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-VitalSignsHeightExample"
        },
        "name" : "SDOHCC Vital Signs WIC Eligibility Example - Height",
        "description" : "An example of a height observation used to determine WIC eligibility.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-VitalSignsWeightExample"
        },
        "name" : "SDOHCC Vital Signs WIC Eligibility Example - Weight",
        "description" : "An example of a weight observation used to determine WIC eligibility.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/SDOHCC-ObservationRaceOMBMotherExample"
        },
        "name" : "SDOHCC-Observation Race OMB Mother Example",
        "description" : "An example of a race Observation that uses Observation.focus to make an Observation about the race of the subject’s mother (who is his caretaker).",
        "exampleCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/SDOHCC-StructureMapHungerVitalSign"
        },
        "name" : "SDOHCCHungerVitalSignMap",
        "description" : "A StructureMap instance that represents the resource that transforms a specific question and answer from the LOINC Hunger Vital Sign [HVS] questionnaire (LOINC code 88121-9) into a corresponding Observation (SDOHCC Observation response Hunger Vital Sign Q3 Example) and derived Condition (SDOHCC Condition Food Insecurity Example)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureMap"
          }
        ],
        "reference" : {
          "reference" : "StructureMap/SDOHCC-StructureMapPRAPARE"
        },
        "name" : "SDOHCCPRAPAREMap",
        "description" : "A StructureMap instance that represents the resource that transforms specific questions and answers from the PRAPARE questionnaire represented in LOINC (code 93025-5) into their corresponding Observations and derived Conditions (health concerns)",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/ServiceRequest-supporting-info"
        },
        "name" : "ServiceRequestSupportingInfo",
        "description" : "Allows searching by the 'supportingInfo' references on a ServiceRequest.  Primarily used to support _include of the supportingInfo resources when retrieving a ServiceRequest.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/Task-output-reference"
        },
        "name" : "TaskOutputReference",
        "description" : "Allows searching by the 'output' values of a Task with a type of Reference.  Primarily used to support _include of the outputs when retrieving a Task.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "IG Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "sdoh_challenges_gravity.html"
            }
          ],
          "nameUrl" : "sdoh_challenges_gravity.html",
          "title" : "SDOH and the Gravity Project",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "sdoh_clinical_care_scope.html"
            }
          ],
          "nameUrl" : "sdoh_clinical_care_scope.html",
          "title" : "SDOH Clinical Care Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "technical_background.html"
            }
          ],
          "nameUrl" : "technical_background.html",
          "title" : "Technical Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "glossary.html"
            }
          ],
          "nameUrl" : "glossary.html",
          "title" : "Glossary",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "credits.html"
            }
          ],
          "nameUrl" : "credits.html",
          "title" : "Credits",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "assessment_instrument_support.html"
            }
          ],
          "nameUrl" : "assessment_instrument_support.html",
          "title" : "Assessment Instrument Support",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "referral_workflow.html"
            }
          ],
          "nameUrl" : "referral_workflow.html",
          "title" : "Referral Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "checking_task_status.html"
            }
          ],
          "nameUrl" : "checking_task_status.html",
          "title" : "Checking Task Status",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "connecting_applications_with_api_data_sources.html"
            }
          ],
          "nameUrl" : "connecting_applications_with_api_data_sources.html",
          "title" : "Connecting Applications with API Data Sources",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "capacity.html"
            }
          ],
          "nameUrl" : "capacity.html",
          "title" : "Capacity Status",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "rffa.html"
            }
          ],
          "nameUrl" : "rffa.html",
          "title" : "Referral for Further Assessment",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "self_referral.html"
            }
          ],
          "nameUrl" : "self_referral.html",
          "title" : "Self-Referral",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "enrollment.html"
            }
          ],
          "nameUrl" : "enrollment.html",
          "title" : "Enrollment Status",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "gravity_terminology.html"
            }
          ],
          "nameUrl" : "gravity_terminology.html",
          "title" : "Gravity Project Value Sets",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "mustsupport_and_missing_data.html"
            }
          ],
          "nameUrl" : "mustsupport_and_missing_data.html",
          "title" : "Must Support and Missing Data",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "privacy_and_security.html"
            }
          ],
          "nameUrl" : "privacy_and_security.html",
          "title" : "Privacy and Security",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts Index",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "specifications_for_personal_characteristics.html"
            }
          ],
          "nameUrl" : "specifications_for_personal_characteristics.html",
          "title" : "Specifications for Personal Characteristics",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu2_ballot_changes.html"
            }
          ],
          "nameUrl" : "stu2_ballot_changes.html",
          "title" : "STU2 Ballot Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu2_publication_changes.html"
            }
          ],
          "nameUrl" : "stu2_publication_changes.html",
          "title" : "STU2 Publication Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu2_1_update_changes.html"
            }
          ],
          "nameUrl" : "stu2_1_update_changes.html",
          "title" : "STU2.1 Publication Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu2_2_update_changes.html"
            }
          ],
          "nameUrl" : "stu2_2_update_changes.html",
          "title" : "STU2.2 Publication Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu2_3_update_changes.html"
            }
          ],
          "nameUrl" : "stu2_3_update_changes.html",
          "title" : "STU2.3 Publication Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "stu3_ballot_changes.html"
            }
          ],
          "nameUrl" : "stu3_ballot_changes.html",
          "title" : "STU3 Ballot Changes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ImplementationGuide-hl7.fhir.us.sdoh-clinicalcare.html"
            }
          ],
          "nameUrl" : "ImplementationGuide-hl7.fhir.us.sdoh-clinicalcare.html",
          "title" : "SDOH Clinical Care ImplementationGuide Resource",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/assets"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
