# SDOHCC HealthcareService Social Care Program Example - SDOH Clinical Care v3.0.0-ballot

## Example HealthcareService: SDOHCC HealthcareService Social Care Program Example

Language: en

Profile: [SDOHCC Healthcare Service for Referral Management](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md)

> **SDOHCC Extension HealthcareService Capacity Status**
* capacityStatus: Has Capacity

**active**: true

**category**: SDOH

**type**: Assessment

**location**: [Location Family Counseling Services Deerland Clinic](Location-SDOHCC-LocationExample.md)

**name**: HACC

**telecom**: ph: (555) appoint(Work)

**program**: Home And Community Care (HACC)



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "SDOHCC-HealthcareServiceSocialCareProgram",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareServiceForReferralManagement"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "capacityStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                "code" : "capacity",
                "display" : "Has Capacity"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceCapacityStatus"
    }
  ],
  "active" : true,
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        },
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "housing-instability",
          "display" : "Housing instability"
        }
      ]
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/service-type",
          "code" : "252",
          "display" : "Assessment"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/SDOHCC-LocationExample"
    }
  ],
  "name" : "HACC",
  "telecom" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment",
          "valueBoolean" : true
        }
      ],
      "system" : "phone",
      "value" : "(555) appoint",
      "use" : "work"
    }
  ],
  "program" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/program",
          "code" : "21",
          "display" : "Home And Community Care (HACC)"
        }
      ]
    }
  ]
}

```
