# SDOHCC Group SDOH Patients For Payer Example - SDOH Clinical Care v3.0.0-ballot

## Example Group: SDOHCC Group SDOH Patients For Payer Example

Language: en

Profile: [SDOHCC Group](StructureDefinition-SDOHCC-Group.md)

**active**: true

**type**: Person

**actual**: true

**name**: CDE payer's SDOH condition patients

> **characteristic****code**:Current Condition Category From SDOH Category**value**:[SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md)**exclude**: false

> **characteristic****code**:Coverage By Payer Organization**value**:[Organization CDE Payer](Organization-SDOHCC-OrganizationPayerExample.md)**exclude**: false



## Resource Content

```json
{
  "resourceType" : "Group",
  "id" : "SDOHCC-GroupSDOHPatientsForPayerExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Group"
    ]
  },
  "language" : "en",
  "active" : true,
  "type" : "person",
  "actual" : true,
  "name" : "CDE payer's SDOH condition patients",
  "characteristic" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "sdoh-condition-category"
          }
        ]
      },
      "valueReference" : {
        "reference" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
      },
      "exclude" : false
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "payer-coverage"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Organization/SDOHCC-OrganizationPayerExample"
      },
      "exclude" : false
    }
  ]
}

```
