# SDOHCC Goal Food Security Example - SDOH Clinical Care v3.0.0-ballot

## Example Goal: SDOHCC Goal Food Security Example

Language: en

Profile: [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md)

**lifecycleStatus**: Active

**achievementStatus**: Improving

**category**: Food Insecurity

**description**: Food security

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

### Targets

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Measure** | **Detail[x]** | **Due[x]** |
| * | Food insecurity risk [HVS] | No risk | 2020-12-10 |

**statusDate**: 2020-10-21

**addresses**: [Condition Food insecurity](Condition-SDOHCC-ConditionFoodInsecurityExample.md)



## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "SDOHCC-GoalFoodSecurityExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal"
    ]
  },
  "language" : "en",
  "lifecycleStatus" : "active",
  "achievementStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/goal-achievement",
        "code" : "improving",
        "display" : "Improving"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "food-insecurity",
          "display" : "Food Insecurity"
        }
      ]
    }
  ],
  "description" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1078229009",
        "display" : "Food security"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "target" : [
    {
      "measure" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "88124-3",
            "display" : "Food insecurity risk [HVS]"
          }
        ]
      },
      "detailCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "LA19983-8",
            "display" : "No risk"
          }
        ]
      },
      "dueDate" : "2020-12-10"
    }
  ],
  "statusDate" : "2020-10-21",
  "addresses" : [
    {
      "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
    }
  ]
}

```
