# SDOHCC Consent Information Disclosure Example - SDOH Clinical Care v3.0.0-ballot

## Example Consent: SDOHCC Consent Information Disclosure Example

### Attachment

An example of a Consent for information disclosure related to SDOH information with a [PDF](ExampleConsent.pdf) attachment.

Language: en

Profile: [SDOHCC Consent](StructureDefinition-SDOHCC-Consent.md)

**status**: Active

**scope**: Privacy Consent

**category**: information disclosure

**patient**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**dateTime**: 2021-05-01

**organization**: [Organization CDE Payer](Organization-SDOHCC-OrganizationPayerExample.md)

**source**: application/pdf: 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

**policyRule**: HIPAA Authorization



## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "SDOHCC-ConsentInformationDisclosureExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Consent"
    ]
  },
  "language" : "en",
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "patient-privacy",
        "display" : "Privacy Consent"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "IDSCL",
          "display" : "information disclosure"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/pat-53234"
  },
  "dateTime" : "2021-05-01",
  "organization" : [
    {
      "reference" : "Organization/SDOHCC-OrganizationPayerExample"
    }
  ],
  "sourceAttachment" : {
    "contentType" : "application/pdf",
    "language" : "en",
    "data" : "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"
  },
  "policyRule" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentpolicycodes",
        "code" : "hipaa-auth",
        "display" : "HIPAA Authorization"
      }
    ]
  }
}

```
