# SDOHCC Condition Food Insecurity Example - SDOH Clinical Care v3.0.0-ballot

## Example Condition: SDOHCC Condition Food Insecurity Example

Language: en

Profile: [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md)

**clinicalStatus**: Active

**verificationStatus**: Unconfirmed

**category**: Health Concern, SDOH, Food Insecurity

**code**: Food insecurity

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**onset**: 2019-08-18 12:31:35+0000 --> (ongoing)

### Evidences

| | |
| :--- | :--- |
| - | **Detail** |
| * | [Observation Food insecurity risk [HVS]](Observation-SDOHCC-ObservationResponseHungerVitalSignQuestion3Example.md) |



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "SDOHCC-ConditionFoodInsecurityExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition"
    ]
  },
  "language" : "en",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "unconfirmed",
        "display" : "Unconfirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category",
          "code" : "health-concern",
          "display" : "Health Concern"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "version" : "7.0.0",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "food-insecurity",
          "display" : "Food Insecurity"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "733423003",
        "display" : "Food insecurity"
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "code" : "Z59.4",
        "display" : "Lack of adequate food"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "onsetPeriod" : {
    "start" : "2019-08-18T12:31:35.123Z"
  },
  "evidence" : [
    {
      "detail" : [
        {
          "reference" : "Observation/SDOHCC-ObservationResponseHungerVitalSignQuestion3Example"
        }
      ]
    }
  ]
}

```
