# SDOHCC CodeSystem Temporary Codes - SDOH Clinical Care v3.0.0-ballot

## CodeSystem: SDOHCC CodeSystem Temporary Codes 

 
A local code system defined within the context of the SDOH-CC IG. 

This Code system is referenced in the definition of the following value sets:

* [SDOHCCValueSetCapacityStatus](ValueSet-SDOHCC-ValueSetCapacityStatus.md)
* [SDOHCCValueSetProgramEnrollmentCategory](ValueSet-SDOHCC-ValueSetEnrollmentCategory.md)
* [SDOHCCValueSetProgramEnrollmentStatus](ValueSet-SDOHCC-ValueSetEnrollmentStatus.md)
* [SDOHCCValueSetObservationMethod](ValueSet-SDOHCC-ValueSetObservationMethod.md)
* [SDOHCCValueSetSDOHCategory](ValueSet-SDOHCC-ValueSetSDOHCategory.md)
* [SDOHCCValueSetSDOHQuestionnaireCategory](ValueSet-SDOHCC-ValueSetSDOHQuestionnaireCategory.md)
* [SDOHCCValueSetTaskCode](ValueSet-SDOHCC-ValueSetTaskCode.md)

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SDOHCC-CodeSystemTemporaryCodes",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCCodeSystemTemporaryCodes",
  "title" : "SDOHCC CodeSystem Temporary Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "A local code system defined within the context of the SDOH-CC IG.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "purpose" : "The purpose of this code system is to enable temporary codes to be assigned to concepts that are needed to document SDOH-related data elements defined by the Gravity Project community and concepts that are needed to facilitate the use of FHIR to exchange data as required in the use cases covered by this IG.  After the IG has been sufficiently tested through HL7 Connectathons and the coded concepts have been confirmed as fit for the intended purpose, and consensus on the use of the codes has been confirmed through the HL7 Ballot process, the temporary codes will be replaced with coded concepts established within nationally recognized, open code systems.  The replacement of temporary codes with permanent codes is intended to happen in a future version of the IG.",
  "copyright" : "(c) 2020 HL7.org",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 57,
  "concept" : [
    {
      "code" : "sdoh-category-unspecified",
      "display" : "SDOH Category Unspecified",
      "definition" : "Category for Social Determinant of Health artifacts that are not further specified with respect to category."
    },
    {
      "code" : "food-insecurity",
      "display" : "Food Insecurity",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Food Insecurity (which is defined as: Uncertain, limited, or unstable access to food that is: adequate in quantity and in nutritional quality; culturally acceptable; safe and acquired in socially acceptable ways.) This SDOH category covers records relevant to circumstances that range from Food Insecurity to Food Security."
    },
    {
      "code" : "housing-instability",
      "display" : "Housing Instability",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Housing Instability (which is defined as: Currently consistently housed, but experiencing any of the following circumstances in the past 12 months: being behind on rent or mortgage, multiple moves, or housing cost burden.) This SDOH category covers records relevant to circumstances that range from Housing Instability to Stably Housed."
    },
    {
      "code" : "homelessness",
      "display" : "Homelessness",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Homelessness (which is defined as including: 1) Sheltered Homelessness: because of economic difficulties, currently living in a shelter, motel, temporary or transitional living situation, scattered-site housing, or not having a consistent place to sleep at night; and 2) Unsheltered Homelessness: residing in a place not meant for human habitation, such as cars, parks, sidewalks, abandoned buildings, on the street.) This SDOH category covers records relevant to circumstances that range Homelessness to Housed."
    },
    {
      "code" : "inadequate-housing",
      "display" : "Inadequate Housing",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Inadequate Housing (which is defined as: Housing does not meet habitability standards.) This SDOH category covers records relevant to circumstances that range from Inadequate Housing to Adequate Housing."
    },
    {
      "code" : "transportation-insecurity",
      "display" : "Transportation Insecurity",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Transportation Insecurity (which is defined as: Uncertain, limited, or no access to safe, reliable, accessible, affordable, and socially acceptable transportation infrastructure and modalities necessary for maintaining one’s health, well-being, or livelihood.) This SDOH category covers records relevant to circumstances that range from Transportation Insecurity to Transportation Security."
    },
    {
      "code" : "financial-insecurity",
      "display" : "Financial Insecurity",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Financial Insecurity (which is defined as: A state of being wherein a person has difficulty fully meeting current and/or ongoing financial obligations and/or does not feel secure in their financial future.) This SDOH category covers records relevant to circumstances that range from Financial Insecurity to Financial Security."
    },
    {
      "code" : "material-hardship",
      "display" : "Material Hardship",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Material Hardship (which is defined as: The lack of specific socially perceived basic physical necessities.) This SDOH category covers records relevant to circumstances that range from 'Unable to obtain physical necessity X' to 'Able to obtain physical necessity X'."
    },
    {
      "code" : "educational-attainment",
      "display" : "Educational Attainment",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to the level of education attained (which, in this context, is defined by whether one has or has not met academic criteria for high school diploma or equivalent.) This SDOH category covers records relevant to circumstances that range from 'Lacks a high school diploma/certificate' to 'Has a high school diploma/certificate'."
    },
    {
      "code" : "employment-status",
      "display" : "Employment Status",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to the status of one's employment (which, in this context, is defined by whether one has or does not have a job and is looking for and available for work). This SDOH category covers records relevant to circumstances that range from 'In labor force' (Unemployed to Employed), or 'Not in labor force'."
    },
    {
      "code" : "veteran-status",
      "display" : "Veteran Status",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to veteran status (which, in this context, is defined by whether one has or has not served as active military with honorable release or discharge.) This SDOH category covers records relevant to circumstances that range from 'History of military service' to 'No history of military service'."
    },
    {
      "code" : "stress",
      "display" : "Stress",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Stress (which is defined as: When a person perceives the demands of environmental stimuli to be greater than their ability to meet, mitigate, or alter those demands.) This SDOH category covers records relevant to circumstances that range from Stress to 'No stress'."
    },
    {
      "code" : "social-connection",
      "display" : "Social Connection",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Social Connection (which is defined as: An umbrella term that encompasses the structural, functional, and quality aspects of how individuals connect to each other.) This SDOH category covers records relevant to circumstances that range from inadequate social connections to adequate/satisfying social connections."
    },
    {
      "code" : "intimate-partner-violence",
      "display" : "Intimate Partner Violence",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Intimate Partner Violence (IPV) (which is defined as: Physical violence, sexual violence, or psychological harm by a current or former partner or spouse. Often including a pattern of methods and tactics to gain and maintain power and control over the other person.) This SDOH category covers records relevant to circumstances that range from being a victim of IPV to not being a victim of IPV."
    },
    {
      "code" : "elder-abuse",
      "display" : "Elder Abuse",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Elder Abuse (which is defined as: An intentional act or failure to act by a caregiver or another person in a relationship involving an expectation of trust that causes or creates a risk of harm to an older adult and can be in the form of physical abuse, psychological abuse, sexual abuse, financial abuse, and/or neglect by someone in a caregiving role.) This SDOH category covers records relevant to circumstances that range from being a victim of elder abuse to not being a victim of elder abuse."
    },
    {
      "code" : "personal-health-literacy",
      "display" : "Personal Health Literacy",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Personal Health Literacy (which is defined by Healthy People 2030 as: The degree to which individuals have the ability to find, understand, and use information and services to inform health-related decisions and actions for themselves and others.) This SDOH category covers records relevant to circumstances that range from personal health literacy problems/diagnoses to positive findings/goals related to personal health literacy."
    },
    {
      "code" : "health-insurance-coverage-status",
      "display" : "Health Insurance Coverage Status",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to health insurance coverage (which is defined by whether one has, or does not have, healthcare coverage or insurance.) This SDOH category covers records relevant to circumstances that range from 'no health insurance coverage' to 'health insurance coverage'."
    },
    {
      "code" : "medical-cost-burden",
      "display" : "Medical Cost Burden",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to medical cost burden (which is defined as: A measure of financial pressure resulting from health spending stemming from inadequate resources to meet medical cost needs.) This SDOH category covers records relevant to circumstances that range from 'financial insecurity due to medical cost burden' to 'no burdensome medical costs/debt'."
    },
    {
      "code" : "digital-literacy",
      "display" : "Digital Literacy",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Digital Literacy (which, based off the United States Agency for International Development (USAID) definition is defined as: The degree to which individuals have the ability to access, manage, understand, integrate, communicate, evaluate, and create information safely and appropriately through digital devices and networked technologies for participation in economic, social, and political life). This SDOH category covers records relevant to circumstances that range from digital literacy problems/diagnoses to positive findings/goals related to digital literacy."
    },
    {
      "code" : "digital-access",
      "display" : "Digital Access",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Digital Access (which is defined as: Lacking adequate internet (reliable and of sufficient speed to participate in day-to-day and work life) or a digital device to access the internet (the device must be appropriate for the user’s functional abilities)). This SDOH category covers records relevant to circumstances that range from digital access problems/diagnoses to positive findings/goals related to digital access."
    },
    {
      "code" : "utility-insecurity",
      "display" : "Utility Insecurity",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Utility Insecurity (which includes Energy Insecurity and Water Insecurity and is defined as: Inability to adequately (safely, stably, affordably, and sustainably) meet basic household energy needs (e.g., heating, cooling, lighting, cooking, refrigeration, medical and electronic devices, etc.) and/or water needs (e.g., drinking, cooking or preparing food, bathing, laundry, etc.) due to energy and/or water service difficulties). This SDOH category covers records relevant to circumstances that range from Utility Insecurity to Utility Security."
    },
    {
      "code" : "language-access",
      "display" : "Language Access",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Language Access. This SDOH category covers records related to English language proficiency, preferred language for healthcare setting, and needing interpretation or translation to address language barriers and improve language access."
    },
    {
      "code" : "incarceration-status",
      "display" : "Incarceration Status",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Incarceration Status. This SDOH category covers records related to community supervision, current incarceration, problems related to prior incarceration, and time-boxed reentry periods."
    },
    {
      "code" : "protective-factor",
      "display" : "Protective Factor",
      "definition" : "Category for Social Determinant of Health artifacts that pertain to Protective Factors."
    },
    {
      "code" : "resulting-activity",
      "display" : "Resulting Activity",
      "definition" : "Code used for Task.output.type to represent the activity/action that is the result of a fulfilled task."
    },
    {
      "code" : "sdoh-condition-category",
      "display" : "Current Condition Category From SDOH Category",
      "definition" : "Code used for Group.characteristic to identify Group members with a current SDOH Condition (identified by a Condition with Condition.category from SDOH domain value set referenced by Group.characteristic.value)."
    },
    {
      "code" : "payer-coverage",
      "display" : "Coverage By Payer Organization",
      "definition" : "Code used for Group.characteristic to identify Group members currently covered by a specific payer organization."
    },
    {
      "code" : "general-information",
      "display" : "General Information",
      "definition" : "Designates that information with respect to an action to be performed 1) will be captured in Task.description in text form AND 2) has no computable expectation AND 3) any resulting response will be captured in Task.Output.GeneralInformationResponse.value as markdown."
    },
    {
      "code" : "make-contact",
      "display" : "Make Contact",
      "definition" : "Designates that the action performed is to make contact (e.g., schedule an appointment, call for results, etc.) with a designated entity (e.g., a healthcare provider, social program, etc.). Details about the reason for the contact may captured elsewhere"
    },
    {
      "code" : "review-material",
      "display" : "Review Material",
      "definition" : "Designates that the action performed is to review material (e.g., attached instructions). Details about the type of material to be reviewed, the reason for reviewing the material, etc. may be captured elsewhere."
    },
    {
      "code" : "risk-questionnaire",
      "display" : "Risk Questionnaire",
      "definition" : "A type of questionnaire that evaluates SDOH-related risk(s)."
    },
    {
      "code" : "feedback-questionnaire",
      "display" : "Feedback Questionnaire",
      "definition" : "A type of questionnaire that obtains feedback on a service that was offered or received."
    },
    {
      "code" : "application-questionnaire",
      "display" : "Application Questionnaire",
      "definition" : "A type of questionnaire that obtains information required on an application (e.g., for a social service program, insurance, benefits, etc.)."
    },
    {
      "code" : "personal-characteristics-questionnaire",
      "display" : "Personal Characteristics Questionnaire",
      "definition" : "A type of questionnaire that obtains information about an individual's personal characteristics (e.g., sexual orientation, gender identity, etc.)."
    },
    {
      "code" : "contact-entity",
      "display" : "Contact Entity",
      "definition" : "Identifies an entity (e.g., a practitioner, organization, or service) that needs to be contacted."
    },
    {
      "code" : "general-information-response",
      "display" : "General Information Response",
      "definition" : "When Task.code is 'general-information', 'general-information-response' for Task.output.type indicates that a free text response can be provided."
    },
    {
      "code" : "questionnaire-category",
      "display" : "Questionnaire Category",
      "definition" : "Identifies the category of questionnaire that should be completed."
    },
    {
      "code" : "questionnaire-pdf",
      "display" : "Questionnaire PDF",
      "definition" : "Identifies the questionnaire PDF to be completed."
    },
    {
      "code" : "questionnaire-url",
      "display" : "Questionnaire URL",
      "definition" : "Identifies the URL where a questionnaire to be completed can be accessed."
    },
    {
      "code" : "questionnaire-pdf-completed",
      "display" : "Questionnaire PDF Completed",
      "definition" : "Identifies the completed questionnaire PDF."
    },
    {
      "code" : "contacting-subject-prohibited",
      "display" : "Contacting Subject Prohibited",
      "definition" : "Identifies that the subject does not want to be contacted for any reason related to this request. There will be alternate arrangements made with respect to contact by the subject or someone acting on their behalf."
    },
    {
      "code" : "self-reported",
      "display" : "Self Reported",
      "definition" : "The subject reported the information about the subject."
    },
    {
      "code" : "reported-by-related-person",
      "display" : "Reported By Related Person",
      "definition" : "Someone related to the subject reported the information about the subject."
    },
    {
      "code" : "observed",
      "display" : "Observed",
      "definition" : "Direct observation of the subject was used to obtain information about the subject."
    },
    {
      "code" : "administrative",
      "display" : "Administrative",
      "definition" : "The information about the subject was collected by an organization for administrative reasons not necessarily directly related to obtaining healthcare or health insurance."
    },
    {
      "code" : "derived-specify",
      "display" : "Derived Specify",
      "definition" : "The information about the subject was derived from information or methods other than directly reported by an individual. Text or derivedFrom should be used to further specify the method."
    },
    {
      "code" : "other-specify",
      "display" : "Other Specify",
      "definition" : "The actual value is not a member of the set of permitted data values in the constrained value domain of a variable. Text should be used to further specify the value."
    },
    {
      "code" : "personal-characteristic",
      "display" : "Personal Characteristic",
      "definition" : "Category for artifacts that pertain to a personal characteristic (characteristics that are usually self-attested but may be attested to on behalf of the subject and are generally only verifiable by the source of attestation (e.g., sexual orientation, gender identity and personal pronouns), but may sometimes be verifiable by someone other than the source of attestation (e.g., recorded sex))."
    },
    {
      "code" : "chosen-contact",
      "display" : "Chosen Contact",
      "definition" : "Identifies the entity (e.g., a practitioner, organization, or service) that was contacted."
    },
    {
      "code" : "additional-content",
      "display" : "Additional Content",
      "definition" : "Identifies additional content relevant to the task."
    },
    {
      "code" : "program-enrollment",
      "display" : "Program Enrollment Status",
      "definition" : "Determination of an individual's enrollment in a social care program."
    },
    {
      "code" : "enrolled",
      "display" : "Enrolled",
      "definition" : "Identifies that an individual is enrolled in a social care program."
    },
    {
      "code" : "not-enrolled",
      "display" : "Not Enrolled",
      "definition" : "Identifies that an individual is not enrolled in a social care program."
    },
    {
      "code" : "not-enrolled-on-waitlist",
      "display" : "Not Enrolled - On Waitlist",
      "definition" : "Identifies that an individual is not enrolled in a social care program, but is on a waitlist to be enrolled."
    },
    {
      "code" : "no-capacity",
      "display" : "No Capacity",
      "definition" : "Identifies that a social care program does not have capacity to care for an individual."
    },
    {
      "code" : "capacity",
      "display" : "Has Capacity",
      "definition" : "Identifies that a social care program has capacity to care for an individual."
    },
    {
      "code" : "no-capacity-has-waitlist",
      "display" : "No Capacity - Has Waitlist",
      "definition" : "Identifies that a social care program does not have capacity to care for an individual, but has a waitlist."
    }
  ]
}

```
