# Gravity Project Value Sets - SDOH Clinical Care v3.0.0-ballot

## Gravity Project Value Sets

Gravity Project develops and maintains SDOH-related value sets that are published in the National Institutes of Health (NIH) [Value Set Authority Center (VSAC)](https://vsac.nlm.nih.gov/). Hyperlinks to the Gravity Project VSAC value sets can also be found [here](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets) on the Gravity Project Confluence site. This section describes how these value sets are used in the SDOHCC profiles and the process for developing the value sets in VSAC.

### Additional Bindings for SDOH Domain-specific Value Sets

The [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Service Request](StructureDefinition-SDOHCC-ServiceRequest.md), [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md), and [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md) profiles have additional bindings for `Observation.code`, `Observation.value`, `Condition.code`, `ServiceRequest.code`, `Procedure.code`, and `Goal.description` respectively. The additional bindings are to SDOH domain-specific value sets (e.g., for Food Insecurity, Inadequate Housing, etc.) which are determined by the value of the profile’s .category element (selected from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md)).

#### Additional Binding Example for the SDOHCC Condition Profile

For the [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) profile, `Condition.code` has a binding to [US Core Condition Code](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-condition-code.html) (required). However, if `Condition.category` is ‘food-insecurity’, `Condition.code` has an additional binding to [Food Insecurity Diagnoses](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.17/expansion) (a Gravity-authored value set in VSAC).

Excerpt from [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) :

### Gravity Project Value Set Development Process

#### Gravity Project Value Set Naming

Gravity-authored VSAC value sets include a term in their name that indicate the SDOHCC profile they are used with as follows:

| | |
| :--- | :--- |
| Diagnoses | [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) |
| Procedures | [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md) |
| Service Requests | [SDOHCC Service Request](StructureDefinition-SDOHCC-ServiceRequest.md) |
| Goals | [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md) |
| Assessments | [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) |

#### Steps for Gravity Project Value Set Creation in VSAC

The steps below outline Gravity’s general process for value set creation in VSAC. For each step, the examples show the process for `Condition.code` for the [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) profile.

1. Value sets are created that are specific for:

* SDOH domain (category) – e.g., Food insecurity, Transportation Insecurity.
* Profile – e.g., Condition (Diagnoses), Procedure
* Code system – e.g., ICD-10-CM, SNOMED CT, LOINC, CPT, HCPCS

The value sets created in Step 1 do not bind to SDOHCC profile elements. In step 2, they are grouped into value sets that bind to SDOHCC profile elements.

**Example 1**:

| | | | |
| :--- | :--- | :--- | :--- |
| Food Insecurity Diagnoses ICD10CM | Food Insecurity | N/A | ICD-10-CM |
| Food Insecurity Diagnosis SNOMED CT | Food Insecurity | N/A | SNOMED CT |
| Transportation Insecurity Diagnoses ICD10CM | Transportation Insecurity | N/A | ICD-10-CM |
| Transportation Insecurity Diagnoses SNOMED CT | Transportation Insecurity | N/A | SNOMED CT |
| Inadequate Housing Diagnoses ICD10CM | Inadequate Housing | N/A | ICD-10-CM |
| Inadequate Housing Diagnoses SNOMED CT | Inadequate Housing | N/A | SNOMED CT |
| Additional SDOH domain-specific value sets… |  |  |  |

2. Value sets created in Step 1 are grouped into value sets that are only specific for:

* SDOH domain (category) – e.g., Food insecurity, Transportation Insecurity
* Profile – e.g., Condition (Diagnoses), Procedure

These value sets bind to SDOHCC profile elements via an Additional Bindings table. For example, the value sets in the first column below are in the Additional Bindings table for `Condition.code` for SDOHCC Condition. (See image in Additional Bindings for SDOH Domain-specific Value Sets).

**Example 2**:

| | | | |
| :--- | :--- | :--- | :--- |
| Food Insecurity Diagnoses | Food Insecurity | SDOHCC Condition | Food Insecurity Diagnoses ICD10CMFood Insecurity Diagnosis SNOMED CT |
| Transportation Insecurity Diagnoses | Transportation Insecurity | SDOHCC Condition | Transportation Insecurity Diagnoses ICD10CMTransportation Insecurity Diagnoses SNOMED CT |
| Inadequate Housing Diagnoses | Inadequate Housing | SDOHCC Condition | Inadequate Housing Diagnoses ICD10CMInadequate Housing Diagnoses SNOMED CT |
| Additional SDOH domain-specific value sets… |  |  |  |

3. Value sets created in Step 2 are grouped into SDOH grouping value sets that are only specific for:

* Profile – e.g., Condition (Diagnoses), Procedure

These value sets are not used in the SDOHCC profiles. However, they are referenced in the Screening and Assessments section of the US Core Implementation Guide which provides the following guidance with respect to these Gravity SDOH grouping value sets: “**These grouped value sets are narrower subsets of the value sets allowed in the respective US Core Profiles. However, when recording SDOH data US Core Profiles, servers**SHOULD**use them.**”

**Example 3**:

| | | |
| :--- | :--- | :--- |
| Social Determinants of Health Conditions | US Core Condition | Digital Access DiagnosesDigital Literacy DiagnosesLess than high school education DiagnosesElder Abuse DiagnosesUnemployment DiagnosesFinancial Insecurity DiagnosesFood Insecurity DiagnosesHealth Insurance Coverage Status DiagnosesHomelessness DiagnosesHousing Instability DiagnosesInadequate Housing DiagnosesIncarceration Status DiagnosesIntimate Partner Violence DiagnosesLanguage Access DiagnosesMaterial Hardship DiagnosesMedical Cost Burden DiagnosesHealth Literacy DiagnosesSocial Connection DiagnosesStress DiagnosesTransportation Insecurity DiagnosesUtility Insecurity DiagnosesVeteran Status Diagnoses**Note**: Value sets for new SDOH domains will be added as they are created in VSAC. |

##### Table - Gravity VSAC Value Set Development Process for SDOHCC Condition

This table summarizes the Gravity VSAC value set development process. Gravity-authored VSAC value sets are shown in the first three columns. Value sets in green are bound to `Condition.code` for the [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) profile.

-------

1Gravity-authored SDOH value sets can be accessed by creating a free National Library of Medicine (NLM) account and then refining the search to “Steward: The Gravity Project”.

