# Assessment Instrument Support - SDOH Clinical Care v3.0.0-ballot

## Assessment Instrument Support

This section describes standardized social risk assessment instruments, their benefits, and how to standardize their capture, coding and output leveraging work from the [Regenstrief Institute](https://www.regenstrief.org/) and the [National Library of Medicine](https://www.nlm.nih.gov/) (NLM), [SDC Questionnaire](https://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaire.html), [SDC QuestionnaireResponse](https://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaireresponse.html), and [StructureMap](http://hl7.org/fhir/R4/structuremap.html) to automate the creation of [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) and [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) instances from [SDC QuestionnaireResponse](https://hl7.org/fhir/us/sdc/sdc-questionnaireresponse.html).

### Introduction to Social Care Assessment Instruments

Social risk assessment instruments are used to gather information about social risks that can impact an individual’s health and well-being. The information collected through social risk assessment instruments can be used by providers, public health organizations, and policymakers to develop interventions and programs aimed at addressing the root causes of health disparities and improving health outcomes for individuals and communities.

Assessment instruments fit into the SDOH CC [Conceptual Framework](sdoh_clinical_care_scope.md) which illustrates how to: 1) incorporate screening into the care process to assess health concerns and problems. 2) use this information to help the provider and patient establish goals and identify social risk-related interventions to address those goals. 3) use responses from standardized assessment instruments to drive public health analysis of aggregated data from patient populations.

This IG builds on existing FHIR frameworks to generate Observations (e.g., [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)) and Conditions (e.g., [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md)) from LOINC-encoded assessment instruments for incorporation into the patient’s health record.

### Advantages of Standardized Social Care Assessment Instruments

The list of assessment instruments from which questions have been selected and vetted by the Gravity Project as [face-valid](https://mmshub.cms.gov/measure-lifecycle/measure-testing/evaluation-criteria/scientific-acceptability/validity#:~:text=correlation%20or%20equity-,Face%20Validity,measure%20score%20is%20not%20feasible) can be found in the [Social Determinants of Health Screening Assessments](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.126/expansion/Latest) Value Set.

Advantages of using a standardized social risk assessment instrument include:

* **Interoperability (structural and semantic)**: Standardization (e.g., using the same tested and validated questions and coding) will help to ensure that data is consistent and comparable across studies and populations.
* **Ease of use**: Standardized social risk assessment instruments are generally user-friendly and easy to administer.
* **Cost-effectiveness**: Developing (including testing and validation) custom assessment instruments is time-consuming and expensive.
* **Shared maintenance**: As research and best practices evolve, standardized assessments are more likely to keep up and reflect best current practice.

### Representing Assessment Instrument Data Using Standardized Code Systems

Gravity-authored, SDOH domain-specific value sets are hosted in the National Institutes of Health (NIH) [Value Set Authority Center (VSAC)](https://vsac.nlm.nih.gov/) and used with the [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md), [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md) and [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md) profiles.

As Gravity develops content for SDOH domains, Gravity evaluates domain-specific questions from nationally recognized assessment instruments. For assessment instrument coding, Gravity uses LOINC. The LOINC-encoded assessment instruments, from which Gravity has chosen one or more (but not necessarily all) questions, are included in the [Social Determinants of Health Screening Assessments](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.126/expansion/Latest) grouping value set in VSAC.

Questions from LOINC-encoded assessment instruments that meet Gravity’s vetting criteria are included domain-specific value sets (e.g., [Food Insecurity Screening Assessments Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1196.3484/expansion/Latest) value set) that are used with the [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) profile. All domain-specific value sets for assessment instrument questions are included in the [Social Determinants of Health Screening Assessments Questions](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.207/expansion/Latest) grouping value set in VSAC.

### Representing Assessment Instrument Data in a FHIR Format

Implementers should have a plan to present assessment instrument data in a computable FHIR format. The FHIR QuestionnaireResponse and Observation resources can each be used to present data captured in an assessment instrument.

#### Representing Assessment Instrument Data with QuestionnaireResponse and Observation

[QuestionnaireResponse](https://hl7.org/fhir/R4B/questionnaireresponse.html) and [Observation] can present data from completed assessment instruments that has been captured in a structured, codified format (e.g., electronic forms). Best practice is to capture and share [QuestionnaireResponse](https://hl7.org/fhir/R4B/questionnaireresponse.html) and [Observation]. However, decisions as to whether to use one or both resources may be influenced by the use case and the format of the structured data coming from the data sources (e.g., hospitals, health information exchanges (HIEs), social care networks (SCNs), and qualified health information organizations (QHIOs)). Gravity uses the [SDC QuestionnaireResponse](https://hl7.org/fhir/us/sdc/sdc-questionnaireresponse.html) and [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) profiles.

##### Benefits of using QuestionnaireResponse to represent assessment instrument data

Benefits of using [QuestionnaireResponse](https://hl7.org/fhir/R4B/questionnaireresponse.html) to represent assessment instrument data include:

* QuestionnaireResponse is better suited to support use cases that require access to the format of the original assessment instrument.
* QuestionnaireResponse is always based on a FHIR [Questionnaire](https://hl7.org/fhir/R4B/questionnaire.html) and preserves the Questionnaire’s structure and complexity to provide a fully contextualized view of a completed Questionnaire. For example, QuestionnaireResponse allows the precise capture of the assessment instrument version, the exact text of the questions and answers, the order of presentation, multiple choice answer options, and whether questions were skipped.
* Question-answer pairs in QuestionnaireResponse can be automatically transformed to FHIR Observations using [StructureMap](assessment_instrument_support.md#using-structuremap-to-generate-observations-or-conditions-from-questionnaireresponse) and the [SDC Implementation Guide](http://hl7.org/fhir/uv/sdc/STU3/extraction.html#structuremap-based-extraction).

##### Benefits of using Observation to represent assessment instrument data

Benefits of using Observation to represent individual question-answer pairs from an assessment instrument include:

* Observation is supported by most EMR systems and is one of the most mature FHIR resources.
* Observation is better suited than QuestionnaireResponse to support use cases that require querying the assessment instrument data.
* A question-answer pair represented as an Observation can be retrieved and exchanged independently.
* Observation has data elements to represent information that is not explicitly represented in QuestionnaireResponse. For example: 
* `Observation.category` can be used to tag Observations by SDOH domain (e.g., Food Insecurity, Housing Instability)
* `Observation.interpretation` can be used to flag Observations that might represent a health-related social need (HRSN).
* Observation can also indicate relationships (e.g., `Observation.derivedFrom`) to other artifacts. For example, an Observation may be calculated or determined based on other Observations.
* If assessment instrument context is needed, Observations generated from a QuestionnaireResponse can use `Observation.derivedFrom` to reference the QuestionnaireResponse.
 

**Table 1**: Guidance on QuestionnaireResponse (QR) and Observation Screening Response (OSR) based on Usage Needs

| | | | |
| :--- | :--- | :--- | :--- |
| 1. Querying for discrete questions and answers
1. Computation of risk scores or inferencing rules for Conditions
1. Original assessment instrument format is important
 | Needed | Needed | * This is the most common scenario.
* Observations may not need to be created for all question-answer pairs. 
 |
| 1. Querying for discrete questions and answers
1. Computation of risk scores or inferencing rules for creating Conditions
1. Original assessment instrument format is not important
 | Not Needed | Needed | * Querying and computation are much easier with Observation than QuestionnaireResponse.
* It may be necessary to determine which question-answer pairs to represent as Observations (e.g., usefulness of representing a question-answer pair as an Observation may be determined by an implementer’s use case). 
 |
| 1. Original assessment instrument format is important
1. No need for queries, computations, etc.
 | Needed | Not Needed | * This is an unlikely usage need.
* It is highly likely that there will be a future need for queries or computations. Thus, it is advantageous to also create Observations, even if not currently needed. 
 |

#### Additional Guidance on Questionnaire and QuestionnaireResponse

Questionnaire is a template (not specific to an individual) that, like [QuestionnaireResponse](http://hl7.org/fhir/R4/questionnaireresponse.html), is a precise representation of an assessment instrument.

QuestionnaireResponse includes an individual’s responses and always references a Questionnaire via `QuestionnaireResponse.questionnaire`. This IG uses the [SDC QuestionnaireResponse](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaireresponse.html) profile which references the [SDC Base Questionnaire](http://hl7.org/fhir/uv/sdc/STU3/StructureDefinition-sdc-questionnaire.html#root).

Table 2 below provides guidance for Questionnaire.code and Questionnaire.item for several scenarios of ways in which implementers may compose assessment instruments.

**Table 2**: Guidance on Questionnaire elements based on the composition of the assessment instrument


#### Additional Guidance on SDOHCC Observation Screening Response Elements

This section provides guidance on `Observation.category` and `Observation.interpretation` in the context of their use in the [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) profile.

##### Categorizing Observations by SDOH domain(s) using Observation.category

`Observation.category` **SHALL** have two category codes (survey and sdoh) to indicate that a Q-A pair captured as an Observation represents an assessment (survey) related to a social determinant of health.

Optionally, `Observation.category` also has a binding to [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) which has values to categorize an Observation by SDOH domain(s) (e.g., Food Insecurity. Housing Instability, etc.).

When `Observation.category` for [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) is a value from SDOHCC ValueSet SDOH Category:

* It indicates that the Observation addresses a health-related social need (HRSN) in the specified SDOH domain (e.g., food-insecurity).
* It does not mean that the Observation confirms a HRSN in the specified SDOH domain.
* It may have one or more values from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) for `Observation.category`.
* Gravity recommends that the SDOH domain(s) from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) be based on the assessment instrument's question and its complete set of allowed answers (which may be from one or more SDOH domains).

Examples for using `Observation.category` to tag Observations by SDOH domain are provided below. The examples are based on the Accountable Health Communities Health-Related Social Needs Screening Tool (AHC HRSN Screening Tool) or the AHC HRSN Screening Tool Supplemental Questions.1

**Example 1**: When a question and its complete answer set address only one SDOH domain, an Observation using the question for `Observation.code` should have only one value for `Observation.category`.

| | | |
| :--- | :--- | :--- |
| Within the past 12 months, you worried that your food would run out before you got money to buy more | 88122-7 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |
| Often true | LA28397-0 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |
| Sometimes true | LA6729-3 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |
| Never true | LA28398-8 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |

* The above question and the set of answer choices provides information about a possible HRSN related to Food Insecurity.
* Although `Observation.value`: LA28398-8 (Never true) does not indicate a HRSN, the Observation still provides information about Food Insecurity.
* Therefore, regardless of the answer chosen, Gravity recommends using `Observation.category`: [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) for an Observation from the AHC HRSC Screening Tool with `Observation.code`: 88122-7.

**Example 2**: When a question and its complete answer set address more than one SDOH domain, an Observation using the question for `Observation.code` may have more than one SDOH domain value for `Observation.category`.

| | | |
| :--- | :--- | :--- |
| What is your living situation today? | 71802-3 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) |
| I have a steady place to live | LA31993-1 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) |
| I have a place to live today, but I am worried about losing it in the future | LA31994-9 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) |
| I do not have a steady place to live (I am temporarily staying with others, in a hotel, in a shelter, living outside on the street, on a beach, in a car, abandoned building, bus or train station, or in a park | LA31995-6 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) |

* The above question and the set of answer choices provides information about a possible HRSN related to Housing Instability or Homelessness.
* Although `Observation.value`: LA31993-1 (I have a steady place to live) does not indicate a HRSN, the Observation still provides information about Homelessness and Housing Instability.
* `Observation.value`: LA31994-9 (I have a place to live today, but I am worried about losing it in the future) provides information about Housing Instability but also shows that the individual is not experiencing Homelessness.
* Regardless of the answer chosen, Gravity recommends using [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness) AND [housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) for `Observation.category` for any Observation with `Observation.code`: 71802-3.

**Example 3**: Since Gravity Project terminology development for SDOH domains is an ongoing process, some domains may not yet be represented in the [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) value set. When a question and its complete answer set address an SDOH domain that is not represented in the `Observation.category` value set, use `Observation.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified). If desired, Observationcategory.text can be used to further specify the domain.

| | | | |
| :--- | :--- | :--- | :--- |
| Because of a physical, mental, or emotional condition, do you have difficulty doing errands alone such as visiting a doctor's office or shopping? | 69861-3 | [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) | Disability Status |
| Yes | LA33-6 | [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) | Disability Status |
| No | LA32-8 | [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) | Disability Status |

* The question and answer set above address Disability Status.
* As of June 2024, Gravity Project has not yet started on Disability Status as a domain. Therefore, ‘disability-status’ is not in the value set for `Observation.category`.
* In this case, Gravity recommends using `Observation.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) for any Observation with `Observation.code`: 69861-3 and “category.text: Disability Status” can be used to further specify the domain.

##### Flagging Observations for a possible HRSN need using Observation.interpretation

`Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) (Positive) can be used to flag Observations for which the Q-A pair might represent a HRSN.

Additional guidance related to `Observation.interpretation` for [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) :

* The meaning of `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) should be evaluated in conjunction with “`Observation.category`: SDOH domain”. If the author of an assessment instrument provides guidance that a specific Q-A pair might represent a HRSN, `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) can be used to flag the need for follow-up by a provider or qualified health professional (QHP) to further evaluate for a HRSN in the SDOH domain(s) specified by `Observation.category`.
* Gravity does not advise using `Observation.interpretation`: [NEG](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html) (Negative). Assessment instruments are generally designed so that certain answers indicate a possible HRSN. Assessment instrument authors generally do not state that certain Q-A pairs rule out a HRSN.
* When an answer (`Observation.value`) does not indicate a possible HRSN, `Observation.interpretation` should be omitted. Examples for using `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) and understanding its meaning in conjunction with `Observation.category` are provided below. The examples are based on the AHC HRSN Screening Tool which provides guidance that specific answers might indicate an unmet health-related social need.

**Example 4**: When `Observation.category` identifies only one SDOH domain, `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) can be used to flag that the Observation should be followed-up by a provider or QHP to confirm a HRSN or risk in that SDOH domain (e.g., Food Insecurity).

| | | | |
| :--- | :--- | :--- | :--- |
| Within the past 12 months, you worried that your food would run out before you got money to buy more | 88122-7 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | |
| Often true | LA28397-0 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) |
| Sometimes true | LA6729-3 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) |
| Never true | LA28398-8 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |

**Example 5**: When `Observation.category` identifies more than one SDOH domain, `Observation.interpretation`: [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) can be used to flag the Observation as positive for a possible HRSN in at least one of the selected SDOH categories. However, in this case, determining which SDOH category is positive for the identified HRSN requires further evaluation of the answer (`Observation.value`).

In the example below, `Observation.category` has two SDOH codes because the question and its complete set of answers address Housing Instability and Homelessness. However, by [definition](https://confluence.hl7.org/display/GRAV/Terminology+Workstream), Housing Instability and Homelessness cannot exist concurrently. In this case, `Observation.value`: LA31995-6 indicates that the Observation is positive for a possible Housing Instability HRSN and `Observation.value`: LA31994-9 indicates that the Observation is positive for a possible Homelessness HRSN.

| | | | |
| :--- | :--- | :--- | :--- |
| What is your living situation today? | 71802-3 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) | |
| I have a steady place to live | LA31993-1 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) |  |
| I have a place to live today, but I am worried about losing it in the future | LA31994-9 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) | [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) |
| I do not have a steady place to live (I am temporarily staying with others, in a hotel, in a shelter, living outside on the street, on a beach, in a car, abandoned building, bus or train station, or in a park | LA31995-6 | [homelessness](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-homelessness),[housing-instability](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-housing-instability) | [POS](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html#v3-ObservationInterpretation-POS) |

**Example 6**: Gravity does not advise using `Observation.interpretation`: [NEG](http://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html) (Negative) unless a provider or QHP has evaluated the individual and ruled out the HRSN. Regardless of SDOH `Observation.category`, when an answer (`Observation.value`) is provided that does not indicate a HRSN, `Observation.interpretation` should be omitted.

| | | | |
| :--- | :--- | :--- | :--- |
| Within the past 12 months, you worried that your food would run out before you got money to buy more | 88122-7 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | |
| Often true | LA28397-0 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |
| Sometimes true | LA6729-3 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |
| Never true | LA28398-8 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | OMIT |

**Example 7**: When a question is presented to an individual and none of the answers are selected, use `Observation.dataAbsentReason`: [unknown](https://hl7.org/fhir/R4/codesystem-data-absent-reason.html#data-absent-reason-unknown) (or a subtype), and `Observation.interpretation` should be omitted.

| | | | |
| :--- | :--- | :--- | :--- |
| Within the past 12 months, you worried that your food would run out before you got money to buy more | 88122-7 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | |
| Often true | LA28397-0 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |
| Sometimes true | LA6729-3 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |
| Never true | LA28398-8 | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) |  |
| No Answer | [unknown](https://hl7.org/fhir/R4/codesystem-data-absent-reason.html#data-absent-reason-unknown)(or subtype) | [food-insecurity](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-food-insecurity) | OMIT |

#### Using Observation Screening Response to Group Observations

In addition to representing Observation instances, [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) can be used as an Observation Grouping to reference (via `Observation.member`) the Observation Screening Response instances that result from an individual completing an assessment instrument.

If a QuestionnaireResponse has been created for the assessment instrument, Observation Grouping, while not prohibited, is generally redundant since the member Observations can directly reference QuestionnaireResponse (via derivedFrom) for assessment instrument context.

Observation Grouping is most useful when a QuestionnaireResponse has not been created. For an Observation Grouping example, see [SDOHCC Observation Response NHANES Grouping Example](Observation-SDOHCC-ObservationResponseNHANESGroupingExample.md).

For several of the common ways in which implementors may compose assessment instruments, Table 3 provides guidance for `Observation.code` and `Observation.member` for an Observation Grouping.

**Table 3**: Guidance on Observation Grouping based on the composition of the assessment instrument

| | | |
| :--- | :--- | :--- |
| **Assessment Instrument Composition****(what it comprises)** | **Example** | **Recommendations for Observation Screening Response Grouping** |
| **Standardized Assessment Instrument:**This is a single (LOINC-encoded) assessment instrument in its entirety.This assessment instrument is LOINC-encoded, and all questions and answers are LOINC-encoded. | AHC HRSN Screening Tool (Core Questions) | 1. `Observation.code` is the LOINC code (panel code) for the assessment instrument.
1. `Observation.member` references all Observations generated from the assessment instrument.
1. All member Observations have LOINC codes for `Observation.code` and `Observation.value` (where applicable).
 |
| **Non-Standardized Assessment Instrument with Standardized Questions:**This assessment instrument combines questions from one or more Standardized Assessment Instruments.This assessment instrument is not LOINC-encoded but all its questions and answers are LOINC-encoded. | AHC HRSN Screening Tool (Core Questions) + selected questions from AHC HRSN Supplemental Questions | 1. `Observation.code` is a non-LOINC (e.g., local) code since the assessment instrument is not represented in LOINC.
1. `Observation.member` references all Observations generated from the assessment instrument. All member Observations have LOINC codes for `Observation.code` and `Observation.value` (where applicable).
 |
| **Non-Standardized Assessment Instrument with Standardized and Non-standardized Questions**: This assessment instrument combines questions from a Standardized Assessment Instrument with some non-LOINC encoded questions.This assessment instrument is not LOINC-encoded. Some questions and answers are LOINC-encoded. Some questions and answers are not LOINC-encoded. | AHC HRSN Screening Tool (Core Questions) + selected non-LOINC encoded (e.g., local) questions | 1. `Observation.code` is a non-LOINC (e.g., local) code since the assessment instrument is not represented in LOINC.
1. `Observation.member` references all Observations generated from the assessment instrument. Some member Observations have a LOINC code for `Observation.code` and `Observation.value`.
 |

### Using StructureMap to Generate Observations or Conditions from QuestionnaireResponse

This IG has adopted the map-based approach using the FHIR [StructureMap](http://hl7.org/fhir/R4/structuremap.html) resource to define and share rules for generating Observations Conditions (unconfirmed health concerns) from QuestionnaireResponse.

Ideally, in the future, a StructureMap instance could be provided by a Questionnaire steward for a standardized assessment instrument to ensure consistency in the Observations and Conditions (i.e., unconfirmed health concerns) generated from that assessment instrument. A repository of vetted, centrally maintained StructureMaps could significantly help to promote semantic and structural interoperability for standardized assessment instruments as well as reduce provider and implementer burden.

#### Using StructureMap to Generate Observations

This IG supports using SDC StructureMap to generate [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) instances from QuestionnaireResponse. When using StructureMap to generate Observations from QuestionnaireResponse, rules to align Q-A pairs from a QuestionnaireResponse with `Observation.code` and `Observation.value` are generally straightforward. Additional rules, such as rules for assigning `Observation.category` or `Observation.interpretation` to a Q-A pair, may be more complex and would ideally be determined with input from assessment instrument authors.

#### Using StructureMap to Generate Conditions

This IG also supports using SDC StructureMap to generate Conditions (unconfirmed health concerns) for some Q-A pairs from QuestionnaireResponse. Applying rules to Q-A pairs, or combinations of Q-A pairs, to generate Conditions may be complex.

Prior to using SDC StructureMap to generate Conditions from QuestionnaireResponse, implementers should define a clear process for 1) whether this will be done, 2) the rules for generating a Condition from a Q-A pair (or pairs) and 3) verification by a provider or qualified health professional.

**Note**: Regardless of whether Conditions (unconfirmed health concerns) are generated based on guidance provided by assessment instrument authors, coding resources (e.g., [Gravity Project’s Resource for the AHC HRSN Screening Tool](https://confluence.hl7.org/download/attachments/193661411/Gravity_AHC_HRSN_Documentation_Resource_V1.1.pdf?version=3&modificationDate=1698780911961&api=v2)) or ‘vetted’ StructureMaps, documentation of HRSNs based on assessment instruments should be verified by a care team member via personal interaction with the individual being screened.

#### Additional Detailed Technical Guidance for StructureMap

The StructureMap resource examples in this IG are generated using the [FHIR Mapping Language](http://hl7.org/fhir/R4/mapping-language.html). This language is then used to generate the StructureMap instances. Authoring the maps in a textual language is much simpler than attempting to craft the XML or JSON StructureMap instances directly. The mapping language also works regardless of the syntax used for the QuestionnaireResponse, i.e., it works the same for JSON, XML and RDF instances.

Instructions and tutorials on how to use the FHIR Mapping Language to convert and transform resources are found [here](https://confluence.hl7.org/display/FHIR/Using+the+FHIR+Mapping+Language). This page also includes references to existing open-source implementations that are capable of compiling mapping language instances into FHIR StructureMaps as well as being able to ‘execute’ maps - i.e., convert a QuestionnaireResponse into a transaction Bundle of other resources. Implementers are encouraged to leverage one of these existing community-developed implementations rather than creating their own. This will save work and minimize the likelihood of introducing implementation-specific errors into the transformation process.

Therefore, the overall process for supporting this transformation process is as follows:

1. Identify the Questionnaire that will be used to gather SDOH-related information.
1. Determine what Observation and Condition resources will need to be created to be searchable within the FHIR record.
1. Using the examples provided in this guide as a foundation, create a mapping language file that performs the necessary transformation.
1. Compile the mapping file into a StructureMap instance (e.g., using the FHIR Java validator tool).
1. Execute the map against a QuestionnaireResponse.
1. Execute the resulting transaction Bundle to create the relevant Observations and Conditions on the desired server.
1. Test the map through the completion of the Questionnaire and validate the resulting Observations and Conditions.

Note that the creation of the mapping file and compiled StructureMap only needs to be performed once per Questionnaire.

For more information on StructureMap (e.g., [Designing Questionnaires to support data extraction](http://hl7.org/fhir/uv/sdc/STU3/extraction.html#designing-questionnaires-to-support-data-extraction)) and the StructureMap-based extraction mechanism (considerations, error handling and other details) please refer to the [Structured Data Capture Implementation Guide (SDC IG)](http://hl7.org/fhir/uv/sdc/STU3/extraction.html#structuremap-based-extraction).

### Process for Implementing Assessment Instruments

In summary, the process followed by this IG for implementing assessment instruments vetted by Gravity is summarized below. The process can also be applied to other assessment instruments.

* **Use a LOINC-encoded assessment instrument**: [LOINC Components](https://loinc.org/kb/faq/structure/) and [LOINC Answer](https://loinc.org/kb/users-guide/standardized-assessment-measures/) Lists standardize the coding and facilitate leveraging the open-source NLM [LHC-Forms Widget](https://lhcforms.nlm.nih.gov/lhcforms).
* **Convert the LOINC-encoded assessment instrument to an[SDC Questionnaire](https://hl7.org/fhir/us/sdc/sdc-questionnaire.html)**: The open-source NLM [LHC-Forms Widget](https://lhcforms.nlm.nih.gov/lhcforms) supports this step by rendering input forms based on FHIR [Questionnaire](https://hl7.org/fhir/R4B/questionnaire.html) for web-based applications and can be used to build and edit FHIR Questionnaires. For some assessment instruments, this step may include establishing calculation logic to define the result of some questions as a function of answers to other questions (e.g., where one or more question determines an answer to another “question” (not directly answered by the patient) as in Hunger Vital Sign Question 3).
* **Instantiate the[SDC Questionnaire](https://hl7.org/fhir/us/sdc/sdc-questionnaire.html)**: Using an appropriate application (e.g., the open-source NLM [FHIR SDC SMART App](https://lhcforms.nlm.nih.gov/sdc) create an [SDC QuestionnaireResponse](https://hl7.org/fhir/us/sdc/sdc-questionnaireresponse.html)
* **Develop translation logic to use[StructureMap](http://hl7.org/fhir/R4/structuremap.html)** (this logic should generally be provided by the assessment instrument steward) and a validation tool to generate the following resource instances from the [SDC QuestionnaireResponse](https://hl7.org/fhir/us/sdc/sdc-questionnaireresponse.html): 
* [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) - to represent a question-answer pair(s) from the assessment instrument. Any Observations that are produced SHALL include a derivation link (derivedFrom) to the QuestionnaireResponse. Some systems may opt to represent all question-answer pairs as Observations while others may not find this useful and may feel it creates ‘noise’ in the EHR. Key questions for deciding which question-answer pairs should be represented as Observations include but are not limited to: 
* Is it a score or other key measure which may determine whether a problem is recorded in the patient’s record?
* Is it something a provider would likely search for or for which a provider might want to follow trends?
* Is it needed as part of the calculation of a measure?
 
* [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) - to represent any health concerns identified by the assessment instrument These are Conditions (unconfirmed health concerns) that should be verified by a care team member via personal interaction with the individual being screened.
* [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) Grouping - to group any Observations associated with the assessment instrument. Of note, for Observations that can reference a QuestionnaireResponse (as in this process), this is generally redundant but not prohibited.
 

### Assessment Instrument Examples

This IG provides examples of the FHIR artifacts mentioned above for the following assessment instruments.

#### Example: Hunger Vital Sign (HVS)

This IG includes a complete example of the [Hunger Vital Sign (HVS)](https://loinc.org/88121-9/)2 assessment instrument including:

* a [SDC HVS Questionnaire](Questionnaire-SDOHCC-QuestionnaireHungerVitalSign.md)
* a [SDC HVS QuestionnaireResponse](QuestionnaireResponse-SDOHCC-QuestionnaireResponseHungerVitalSignExample.md)
* a [StructureMap](http://hl7.org/fhir/R4/structuremap.html) that takes the [QuestionnaireResponse](https://hl7.org/fhir/R4B/questionnaireresponse.html) and creates the appropriate [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) and [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) instances
* a [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) instance used to record Question 3 on the assessment instrument (computed based on the answers to Questions 1 and 2)
* a [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) instance that could be used to record the health concern based on the assessment instrument results

#### Example: Protocol for Responding to and Assessing Patients’ Assets, Risks, and Experiences (PRAPARE)

This IG includes a partial example of the [PRAPARE](https://loinc.org/93025-5/)3 assessment instrument including:

* a [SDC PRAPARE Questionnaire](Questionnaire-SDOHCC-QuestionnairePRAPARE.md)
* a [SDC PRAPARE Questionnaire Response](QuestionnaireResponse-SDOHCC-QuestionnaireResponsePRAPAREExample.md)
* a [StructureMap](http://hl7.org/fhir/R4/structuremap.html) that takes the [QuestionnaireResponse](https://hl7.org/fhir/R4B/questionnaireresponse.html) and creates the appropriate [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) and [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) instances
* multiple [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md) instances used to record some of the question and answers on the assessment instrument (not all questions are provided in these examples) 
* [Employment Status](Observation-SDOHCC-ObservationResponsePRAPAREEmploymentStatusExample.md)
* [Housing Status](Observation-SDOHCC-ObservationResponsePRAPAREHousingStatusExample.md)
* [Child Care Need](Observation-SDOHCC-ObservationResponsePRAPAREChildCareNeedExample.md)
* [Clothing Need](Observation-SDOHCC-ObservationResponsePRAPAREClothingNeedExample.md)
 
* two [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md) instances to record the health concerns based on the results of the assessment instrument 
* [Unemployed](Condition-SDOHCC-ConditionUnemployedExample.md)
* [Homeless](Condition-SDOHCC-ConditionHomelessExample.md)
 

-------

1 [Accountable Health Communities Health-Related Social Needs Screening Tool Citation and Notification Information](https://www.cms.gov/priorities/innovation/media/document/ahcm-screening-tool-citation)

2 Hunger Vital Sign™ Hager, E. R., Quigg, A. M., Black, M. M., Coleman, S. M., Heeren, T., Rose-Jacobs, R., Cook, J. T., Ettinger de Cuba, S. A., Casey, P. H., Chilton, M., Cutts, D. B., Meyers A. F., Frank, D. A. (2010). [Development and Validity of a 2-Item Screen to Identify Families at Risk for Food Insecurity](https://childrenshealthwatch.org/wp-content/uploads/EH_Pediatrics_2010.pdf). Pediatrics, 126(1), 26-32. doi:10.1542/peds.2009-3146.

3 Protocol for Responding to and Assessing Patients’ Assets, Risks and Experiences (PRAPARE®) and its resources are proprietary information of the National Association of Community Health Centers (NACHC). For more information, visit [https://www.nachc.org/resource/prapare/](https://www.nachc.org/resource/prapare/). The example is included with permission.

