# SDOHCC ValueSet SDOH Category - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet SDOH Category 

 
Codes that represent Social Determinants of Health (SDOH) domains. 

 **References** 

* [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md)
* [SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md)
* [SDOHCC Healthcare Service for Referral Management](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md)
* [SDOHCC Observation Assessment](StructureDefinition-SDOHCC-ObservationAssessment.md)
* [SDOHCC Observation Program Enrollment Status](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md)
* [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)
* [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md)
* [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetSDOHCategory",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetSDOHCategory",
  "title" : "SDOHCC ValueSet SDOH Category",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-12-14T04:01:34+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes that represent Social Determinants of Health (SDOH) domains.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "concept" : [
          {
            "code" : "sdoh-category-unspecified",
            "display" : "SDOH Category Unspecified"
          },
          {
            "code" : "food-insecurity",
            "display" : "Food Insecurity"
          },
          {
            "code" : "housing-instability",
            "display" : "Housing Instability"
          },
          {
            "code" : "homelessness",
            "display" : "Homelessness"
          },
          {
            "code" : "inadequate-housing",
            "display" : "Inadequate Housing"
          },
          {
            "code" : "transportation-insecurity",
            "display" : "Transportation Insecurity"
          },
          {
            "code" : "financial-insecurity",
            "display" : "Financial Insecurity"
          },
          {
            "code" : "material-hardship",
            "display" : "Material Hardship"
          },
          {
            "code" : "educational-attainment",
            "display" : "Educational Attainment"
          },
          {
            "code" : "employment-status",
            "display" : "Employment Status"
          },
          {
            "code" : "veteran-status",
            "display" : "Veteran Status"
          },
          {
            "code" : "stress",
            "display" : "Stress"
          },
          {
            "code" : "social-connection",
            "display" : "Social Connection"
          },
          {
            "code" : "intimate-partner-violence",
            "display" : "Intimate Partner Violence"
          },
          {
            "code" : "elder-abuse",
            "display" : "Elder Abuse"
          },
          {
            "code" : "personal-health-literacy",
            "display" : "Personal Health Literacy"
          },
          {
            "code" : "health-insurance-coverage-status",
            "display" : "Health Insurance Coverage Status"
          },
          {
            "code" : "medical-cost-burden",
            "display" : "Medical Cost Burden"
          },
          {
            "code" : "digital-literacy",
            "display" : "Digital Literacy"
          },
          {
            "code" : "digital-access",
            "display" : "Digital Access"
          },
          {
            "code" : "utility-insecurity",
            "display" : "Utility Insecurity"
          },
          {
            "code" : "incarceration-status",
            "display" : "Incarceration Status"
          },
          {
            "code" : "language-access",
            "display" : "Language Access"
          },
          {
            "code" : "protective-factor",
            "display" : "Protective Factor"
          }
        ]
      }
    ]
  }
}

```
