# SDOHCC ValueSet Observation DerivedFrom IdType - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet Observation DerivedFrom IdType 

 
Codes for identifiers of target resources from which recorded sex or gender information can be derived. 

 **References** 

* [SDOHCC Observation Recorded Sex Gender](StructureDefinition-SDOHCC-ObservationRecordedSexGender.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetObservationDerivedFromIdType",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationDerivedFromIdType",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetObservationDerivedFromIdType",
  "title" : "SDOHCC ValueSet Observation DerivedFrom IdType",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for identifiers of target resources from which recorded sex or gender information can be derived.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
        "version" : "5.0.0",
        "concept" : [
          {
            "code" : "BCT",
            "display" : "Birth Certificate"
          },
          {
            "code" : "DL",
            "display" : "Driver's license number"
          },
          {
            "code" : "PPN",
            "display" : "Passport number"
          },
          {
            "code" : "SB",
            "display" : "Social Beneficiary Identifier"
          },
          {
            "code" : "MCT",
            "display" : "Marriage Certificate"
          },
          {
            "code" : "MI",
            "display" : "Military ID number"
          },
          {
            "code" : "SR",
            "display" : "State registry ID"
          },
          {
            "code" : "WP",
            "display" : "Work Permit"
          }
        ]
      }
    ]
  }
}

```
