# SDOHCC ValueSet Observation DataAbsentReason - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet Observation DataAbsentReason 

 
Codes for the reason an observation does not have a value. 

 **References** 

* [SDOHCC Observation Ethnicity OMB](StructureDefinition-SDOHCC-ObservationEthnicityOMB.md)
* [SDOHCC Observation Race OMB](StructureDefinition-SDOHCC-ObservationRaceOMB.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetObservationDataAbsentReason",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationDataAbsentReason",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetObservationDataAbsentReason",
  "title" : "SDOHCC ValueSet Observation DataAbsentReason",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the reason an observation does not have a value.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
        "version" : "1.0.0",
        "concept" : [
          {
            "code" : "unknown",
            "display" : "Unknown"
          },
          {
            "code" : "asked-unknown",
            "display" : "Asked But Unknown"
          },
          {
            "code" : "temp-unknown",
            "display" : "Temporarily Unknown"
          },
          {
            "code" : "not-asked",
            "display" : "Not asked"
          },
          {
            "code" : "asked-declined",
            "display" : "Asked But Declined"
          },
          {
            "code" : "masked",
            "display" : "Masked"
          }
        ]
      }
    ]
  }
}

```
