# SDOHCC ValueSet Healthcare Service Type - SDOH Clinical Care v3.0.0-ballot

## ValueSet: SDOHCC ValueSet Healthcare Service Type 

 
Codes for the type of health care service. 

 **References** 

* [SDOHCC Healthcare Service](StructureDefinition-SDOHCC-HealthcareService.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SDOHCC-ValueSetHealthcareServiceType",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetHealthcareServiceType",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCValueSetHealthcareServiceType",
  "title" : "SDOHCC ValueSet Healthcare Service Type",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Codes for the type of health care service.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/service-type",
        "version" : "1.1.1",
        "concept" : [
          {
            "code" : "252",
            "display" : "Assessment"
          },
          {
            "code" : "238",
            "display" : "Adult Day Programs"
          },
          {
            "code" : "289",
            "display" : "Clothing"
          },
          {
            "code" : "317",
            "display" : "Detoxification"
          },
          {
            "code" : "103",
            "display" : "Early childhood intervention"
          },
          {
            "code" : "337",
            "display" : "Family Law"
          },
          {
            "code" : "152",
            "display" : "Food safety"
          },
          {
            "code" : "391",
            "display" : "Nursing Home"
          },
          {
            "code" : "61",
            "display" : "Occupational therapy"
          },
          {
            "code" : "156",
            "display" : "Respite care"
          },
          {
            "code" : "224",
            "display" : "Support groups"
          }
        ]
      }
    ]
  }
}

```
