# SDOHCC Task Referral Management Order Fulfillment Completed Example - SDOH Clinical Care v3.0.0-ballot

## Example Task: SDOHCC Task Referral Management Order Fulfillment Completed Example

Language: en

Profile: [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)

**status**: Completed

**intent**: order

**code**: Fulfill the focal request

**focus**: [ServiceRequest Assistance with application for food pantry program](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md)

**for**: [COLIN ABBAS](Patient-pat-53234.md)

**authoredOn**: 2020-09-11 21:56:54+0000

**requester**: [Dr Jan Water Family Medicine Physician](PractitionerRole-SDOHCC-PractitionerRoleDrJanWaterExample.md)

**owner**: [ABC Coordination Platform](Organization-SDOHCC-OrganizationCoordinationPlatformExample.md)

### Outputs

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Value[x]** |
| * | Resulting Activity | [Procedure Assistance with application for food pantry program](Procedure-SDOHCC-ProcedureFoodPantryApplicationAssistanceExample.md) |



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill",
        "display" : "Fulfill the focal request"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample"
  },
  "for" : {
    "reference" : "Patient/pat-53234",
    "display" : "COLIN ABBAS"
  },
  "authoredOn" : "2020-09-11T21:56:54.671Z",
  "requester" : {
    "reference" : "PractitionerRole/SDOHCC-PractitionerRoleDrJanWaterExample",
    "display" : "Dr Jan Water Family Medicine Physician"
  },
  "owner" : {
    "reference" : "Organization/SDOHCC-OrganizationCoordinationPlatformExample",
    "display" : "ABC Coordination Platform"
  },
  "output" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "resulting-activity",
            "display" : "Resulting Activity"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Procedure/SDOHCC-ProcedureFoodPantryApplicationAssistanceExample"
      }
    }
  ]
}

```
