# SDOHCC Task Content Rich Referral WIC Example - SDOH Clinical Care v3.0.0-ballot

## Example Task: SDOHCC Task Content Rich Referral WIC Example

Language: en

Profile: [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)

**status**: Accepted

**intent**: order

**code**: Fulfill the focal request

**focus**: [ServiceRequest Assistance with application for food pantry program](ServiceRequest-SDOHCC-ServiceRequestActiveWICReferralExample.md)

**for**: [BABY ABBAS](Patient-SDOHCC-PatientBabyAbbas.md)

**authoredOn**: 2025-09-11 21:56:54+0000

**requester**: [Dr Jan Water Family Medicine Physician](PractitionerRole-SDOHCC-PractitionerRoleDrJanWaterExample.md)

**owner**: [Special Supplemental Nutrition Program for Women, Infants and Children (WIC) Office](Organization-SDOHCC-OrganizationWICCommunityOrganizationExample.md)

> **input****type**:Additional Content**value**:[Lead Level Lab Result](Observation-SDOHCC-LabObservationLeadLevelExample.md)

> **input****type**:Additional Content**value**:[Childhood Immunizations Record](Immunization-SDOHCC-ImmunizationChildhoodImmunizationsExample.md)

> **input****type**:Additional Content**value**:[WIC Eligibility Vital Signs Observation - Height](Observation-SDOHCC-VitalSignsHeightExample.md)

> **input****type**:Additional Content**value**:[WIC Eligibility Vital Signs Observation - Weight](Observation-SDOHCC-VitalSignsWeightExample.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "SDOHCC-TaskContentRichReferralWICExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
    ]
  },
  "language" : "en",
  "status" : "accepted",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill",
        "display" : "Fulfill the focal request"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveWICReferralExample"
  },
  "for" : {
    "reference" : "Patient/SDOHCC-PatientBabyAbbas",
    "display" : "BABY ABBAS"
  },
  "authoredOn" : "2025-09-11T21:56:54.671Z",
  "requester" : {
    "reference" : "PractitionerRole/SDOHCC-PractitionerRoleDrJanWaterExample",
    "display" : "Dr Jan Water Family Medicine Physician"
  },
  "owner" : {
    "reference" : "Organization/SDOHCC-OrganizationWICCommunityOrganizationExample",
    "display" : "Special Supplemental Nutrition Program for Women, Infants and Children (WIC) Office"
  },
  "input" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "additional-content"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/SDOHCC-LabObservationLeadLevelExample",
        "display" : "Lead Level Lab Result"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "additional-content"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Immunization/SDOHCC-ImmunizationChildhoodImmunizationsExample",
        "display" : "Childhood Immunizations Record"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "additional-content"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/SDOHCC-VitalSignsHeightExample",
        "display" : "WIC Eligibility Vital Signs Observation - Height"
      }
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
            "code" : "additional-content"
          }
        ]
      },
      "valueReference" : {
        "reference" : "Observation/SDOHCC-VitalSignsWeightExample",
        "display" : "WIC Eligibility Vital Signs Observation - Weight"
      }
    }
  ]
}

```
