# SDOHCC Task For Referral Management - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Task For Referral Management 

 
Profile for tasks requesting fulfillment of an SDOHCC ServiceRequest (i.e. referral for service) and subsequently tracking and managing the fulfillment of that referral. 

### Purpose

This profile is used to pass an [SDOHCC Service Request](StructureDefinition-SDOHCC-ServiceRequest.md) (the `Task.focus` field) authored by a Practitioner or Organization (.requester field) targeting a Patient, Related Person or Group (`Task.for` field) to a service-providing organization. These fields are required. The `Task.output` is used to return a collection of procedure codes or references to procedures that were performed in fulfillment of the referral.

If the Task is posted to the service delivery system and the ServiceRequest is on a different system, the reference should be absolute. The Task can be updated by either the service requester or the recipient.

### Usage

#### Checking Task Status

See [Checking Task Status](checking_task_status.md).

#### Status Management

The status values allow for a complete flow of the Task in both the requesting and performing systems.

The allowed state transitions are defined graphically in the state diagram below, and are described in the table below.

**Figure 1: Referral Task State Diagram**

| | | | |
| :--- | :--- | :--- | :--- |
| `draft` | Draft | The task is not yet ready to be acted upon | Requester |
| `requested` | Requested | The task is ready to be acted upon and action is sought | Requester |
| `accepted` | Accepted | The potential performer has agreed to execute the task but has not yet started work | Referral Target |
| `rejected` | Rejected | The potential performer has decided not to execute it prior to performing any action. | Referral Target |
| `cancelled` | Cancelled | The task was not completed | Requester or Referral Target |
| `in-progress` | In Progress | The task has been started but is not yet complete | Referral Target |
| `on-hold` | On Hold | The task has been started but work has been paused. | Referral Target |
| `failed` | Failed | The task was attempted but could not be completed due to some error. | Referral Target |
| `completed` | Completed | The task has been completed. | Referral Target |
| `entered-in-error` | Entered in Error | The task should never have existed and is retained only because of the possibility it may have been used | Requester |

#### Content-Rich Referral

If a referral requester wants to include additional information relevant that could be relevant for an individual's provision of care or assessment by the referral recipient, the requester can attach these resources to the initial Task resource through `Task.input`. This profile slices the `Task.input` element to allow the referral requester to reference any resource to allow for flexibility in the information that is sent to the referral recipient.

For example, a referral requester want to send a request to a CBO to assist with the enrollment of an individual into a program to support with food insecurity. The requester may want to include in the request the completed assessment(s) that led to the action of submitting a referral. The requester will reference those assessments (`QuestionnaireResponse`, `SDOHCC Observation Screening Response`, etc.) in `Task.input`.

**Usages:**

* Refer to this Profile: [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md) and [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* Examples for this Profile: [Task/SDOHCC-TaskContentRichReferralWICExample](Task-SDOHCC-TaskContentRichReferralWICExample.md), [Task/SDOHCC-TaskReferralForFurtherAssessmentExample](Task-SDOHCC-TaskReferralForFurtherAssessmentExample.md), [Task/SDOHCC-TaskReferralManagementOrderFulfillmentAcceptedExample](Task-SDOHCC-TaskReferralManagementOrderFulfillmentAcceptedExample.md), [Task/SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample](Task-SDOHCC-TaskReferralManagementOrderFulfillmentCompletedExample.md)...Show 2 more,[Task/SDOHCC-TaskReferralManagementOrderSubtaskAcceptedExample](Task-SDOHCC-TaskReferralManagementOrderSubtaskAcceptedExample.md)and[Task/SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample](Task-SDOHCC-TaskReferralManagementOrderSubtaskCompletedExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-TaskForReferralManagement)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-TaskForReferralManagement.csv), [Excel](../StructureDefinition-SDOHCC-TaskForReferralManagement.xlsx), [Schematron](../StructureDefinition-SDOHCC-TaskForReferralManagement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-TaskForReferralManagement",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCTaskForReferralManagement",
  "title" : "SDOHCC Task For Referral Management",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for tasks requesting fulfillment of an SDOHCC ServiceRequest (i.e. referral for service) and subsequently tracking and managing the fulfillment of that referral.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "short" : "A request to fulfill an SDOH service request",
        "comment" : "For Tasks used in requesting fulfillment of an SDOHCC ServiceRequest (i.e. referral for service) and subsequently tracking and managing the fulfillment of that referral."
      },
      {
        "id" : "Task.partOf",
        "path" : "Task.partOf",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Task.partOf:SupportedPartOf",
        "path" : "Task.partOf",
        "sliceName" : "SupportedPartOf",
        "requirements" : "Allows an organization (e.g., a Coordination Platform) to create a Task, based on an SDOHCC Task from a referral source, to pass on to another organization (e.g., a  Community Based Organization).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-TaskForReferralManagement"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "comment" : "Note that FHIR strings SHALL NOT exceed 1MB in size. For further details on Task.status see [Checking Task Status](checking_task_status.html).",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetReferralTaskStatus"
        }
      },
      {
        "id" : "Task.statusReason",
        "path" : "Task.statusReason",
        "comment" : "This applies to the current status.  Look at the history of the task to see reasons for past statuses. If the Task.status is rejected, cancelled, on-hold, or failed, then Task.statusReason.text should be included.",
        "mustSupport" : true
      },
      {
        "id" : "Task.statusReason.text",
        "path" : "Task.statusReason.text",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.intent",
        "path" : "Task.intent",
        "short" : "order",
        "definition" : "Indicates the \"level\" of actionability associated with the Task.",
        "comment" : "A request to fulfill task is always an order.",
        "fixedCode" : "order"
      },
      {
        "id" : "Task.priority",
        "path" : "Task.priority",
        "comment" : "Task.priority should be used to distinguish urgent tasks (e.g., needs shelter immediately) from routine tasks.",
        "mustSupport" : true
      },
      {
        "id" : "Task.code",
        "path" : "Task.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/CodeSystem/task-code",
              "code" : "fulfill"
            }
          ]
        }
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.for",
        "path" : "Task.for",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.authoredOn",
        "path" : "Task.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Task.requester",
        "path" : "Task.requester",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-practitionerrole",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|7.0.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "requirements" : "This element is Must Support. However, it is not mandatory in order to allow a task to be created without an owner so that one of a potential group of performers can elect to \"own\" the task (e.g., an 'open' request for fulfillment is set and anyone capable of filling the order can claim it.)",
        "mustSupport" : true
      },
      {
        "id" : "Task.input",
        "path" : "Task.input",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Task.input:AdditionalContent",
        "path" : "Task.input",
        "sliceName" : "AdditionalContent",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.input:AdditionalContent.type",
        "path" : "Task.input.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "additional-content"
            }
          ]
        }
      },
      {
        "id" : "Task.input:AdditionalContent.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ]
      },
      {
        "id" : "Task.output",
        "path" : "Task.output",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "type"
            },
            {
              "type" : "type",
              "path" : "value"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Task.output:PerformedActivityReference",
        "path" : "Task.output",
        "sliceName" : "PerformedActivityReference",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.output:PerformedActivityReference.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "resulting-activity"
            }
          ]
        }
      },
      {
        "id" : "Task.output:PerformedActivityReference.value[x]",
        "path" : "Task.output.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Task.output:PerformedActivityReference.value[x]:valueReference",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueReference",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.output:PerformedActivityCode",
        "path" : "Task.output",
        "sliceName" : "PerformedActivityCode",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.output:PerformedActivityCode.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "resulting-activity"
            }
          ]
        }
      },
      {
        "id" : "Task.output:PerformedActivityCode.value[x]",
        "path" : "Task.output.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Task.output:PerformedActivityCode.value[x]:valueCodeableConcept",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-procedure-code|7.0.0"
        }
      },
      {
        "id" : "Task.output:AdditionalContent",
        "path" : "Task.output",
        "sliceName" : "AdditionalContent",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Task.output:AdditionalContent.type",
        "path" : "Task.output.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
              "code" : "additional-content"
            }
          ]
        }
      },
      {
        "id" : "Task.output:AdditionalContent.value[x]",
        "path" : "Task.output.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Task.output:AdditionalContent.value[x]:valueReference",
        "path" : "Task.output.value[x]",
        "sliceName" : "valueReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationProgramEnrollmentStatus",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition",
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse",
              "http://hl7.org/fhir/StructureDefinition/CarePlan"
            ]
          }
        ]
      }
    ]
  }
}

```
