# SDOHCC Observation Recorded Sex Gender - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Observation Recorded Sex Gender 

 
Profile for observations about "recorded sex and gender" which, in the past, were often used interchangeably. In this context, sex is a biological construct and pertains to a person’s genetics, hormones, and anatomy. For further details on this profile see[Specifications for Personal Characteristics](specifications_for_personal_characteristics.md). 

**Usages:**

* Examples for this Profile: [Observation/SDOHCC-ObservationRecordedSexGenderExample](Observation-SDOHCC-ObservationRecordedSexGenderExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ObservationRecordedSexGender)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ObservationRecordedSexGender.csv), [Excel](../StructureDefinition-SDOHCC-ObservationRecordedSexGender.xlsx), [Schematron](../StructureDefinition-SDOHCC-ObservationRecordedSexGender.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ObservationRecordedSexGender",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRecordedSexGender",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCObservationRecordedSexGender",
  "title" : "SDOHCC Observation Recorded Sex Gender",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for observations about \"recorded sex and gender\" which, in the past, were often used interchangeably. In this context, sex is a biological construct and pertains to a person’s genetics, hormones, and anatomy. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationPersonalCharacteristic",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Observation about an individual's recorded sex or gender",
        "definition" : "For observations about \"recorded sex and gender\" which, in the past, have often been used interchangeably. In this context, sex is a biological construct and pertains to a person’s genetics, hormones, and anatomy.",
        "comment" : "For observations about the recorded sex and gender of an individual."
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "99502-7"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "description" : "Codes for recorded sex and gender",
          "valueSet" : "http://loinc.org/vs/LL6134-2"
        }
      },
      {
        "id" : "Observation.value[x].extension:DataAbsentReasonMasked",
        "path" : "Observation.value[x].extension",
        "sliceName" : "DataAbsentReasonMasked",
        "requirements" : "“Masked” is never used for data capture, but \"masked\" is used to suppress information when data is exchanged. For this reason, other flavors of null are included in the value set for Observation.value, but “masked” can be captured here.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/data-absent-reason|4.0.1"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x].extension:DataAbsentReasonMasked.value[x]",
        "path" : "Observation.value[x].extension.value[x]",
        "definition" : "The information is not available due to security, privacy or related reasons.",
        "fixedCode" : "masked",
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x].coding",
        "path" : "Observation.value[x].coding",
        "mustSupport" : true
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "example",
          "description" : "Methods for personal characteristic observations.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationMethod"
        }
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "requirements" : "DocumentReference can be used to indicate the type of recorded sex or gender. For example, a birth certificate could indicate that this is \"birth sex\".",
        "min" : 1,
        "max" : "1",
        "condition" : ["SDOH-Obs-4"]
      },
      {
        "id" : "Observation.derivedFrom.identifier",
        "path" : "Observation.derivedFrom.identifier",
        "mustSupport" : true
      },
      {
        "id" : "Observation.derivedFrom.identifier.type",
        "path" : "Observation.derivedFrom.identifier.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Codes for the type of record from which recorded sex or gender information is derived.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationDerivedFromIdType"
        }
      },
      {
        "id" : "Observation.derivedFrom.identifier.type.coding",
        "path" : "Observation.derivedFrom.identifier.type.coding",
        "mustSupport" : true
      },
      {
        "id" : "Observation.derivedFrom.identifier.type.text",
        "path" : "Observation.derivedFrom.identifier.type.text",
        "mustSupport" : true
      }
    ]
  }
}

```
