# SDOHCC Observation Race OMB - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Observation Race OMB 

 
Profile for race observations that use Office of Management and Budget (OMB) race category codes and CDC race codes. For further details on this profile see[Specifications for Personal Characteristics](specifications_for_personal_characteristics.md). 

**Usages:**

* Examples for this Profile: [Observation/SDOHCC-ObservationRaceOMBExample](Observation-SDOHCC-ObservationRaceOMBExample.md), [Observation/SDOHCC-ObservationRaceOMBMotherExample](Observation-SDOHCC-ObservationRaceOMBMotherExample.md) and [Observation/SDOHCC-ObservationRaceOMBPractitionerExample](Observation-SDOHCC-ObservationRaceOMBPractitionerExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ObservationRaceOMB)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ObservationRaceOMB.csv), [Excel](../StructureDefinition-SDOHCC-ObservationRaceOMB.xlsx), [Schematron](../StructureDefinition-SDOHCC-ObservationRaceOMB.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ObservationRaceOMB",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCObservationRaceOMB",
  "title" : "SDOHCC Observation Race OMB",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for race observations that use Office of Management and Budget (OMB) race category codes and CDC race codes. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationPersonalCharacteristic",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Race observation",
        "definition" : "For race observations that use Office of Management and Budget (OMB) race category codes and CDC race codes.",
        "comment" : "For observations about the race of an individual.",
        "constraint" : [
          {
            "key" : "SDOH-Race-1",
            "severity" : "error",
            "human" : "Must have either a dataAbsentReason or at least one of the defined race components but not both",
            "expression" : "dataAbsentReason.exists() xor component.where(code.coding.exists(system='http://loinc.org' and code='72826-1')).exists()",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationRaceOMB"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72826-1"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "max" : "0"
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "condition" : ["SDOH-Race-1"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationDataAbsentReason"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Methods for personal characteristic observations.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationMethod"
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "type",
              "path" : "value"
            },
            {
              "type" : "value",
              "path" : "value"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.",
        "comment" : "For a discussion on the ways Observations can be assembled in groups together see [Notes](observation.html#notes) below. NOTE: The same LOINC code is used for all three components of this draft profile. If the profile is adopted as part of the US Core standard, new LOINC codes (possibly a panel) will be needed to represent the components (e.g., a new LOINC code for detailed race and for text description of race).",
        "requirements" : "Component observations share the same attributes in the Observation resource as the primary observation and are always treated a part of a single observation (they are not separable).",
        "condition" : ["SDOH-Race-1"]
      },
      {
        "id" : "Observation.component:RaceDescription",
        "path" : "Observation.component",
        "sliceName" : "RaceDescription",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:RaceDescription.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72826-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:RaceDescription.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:RaceDescription.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:RaceDescription.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:RaceDescription.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Race",
        "path" : "Observation.component",
        "sliceName" : "Race",
        "min" : 0,
        "max" : "5",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Race.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72826-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Race.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Race category codes",
        "definition" : "Office of Management and Budget (OMB) codes for race categories.",
        "requirements" : "An observation exists to have a value, though it might not if it is in error, or if it represents a group of observations. Note: The binding to [Race Category Excluding Nulls](https://cts.nlm.nih.gov/fhir/res/ValueSet/2.16.840.1.113883.3.2074.1.1.3) is used in lieu of [US Core OMB Race Categories](http://hl7.org/fhir/us/core/ValueSet/omb-race-category) because the US Core value set includes null flavors.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for the five OMB race categories",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.2074.1.1.3|20240606"
        }
      },
      {
        "id" : "Observation.component:Race.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Race.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Race.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedRace",
        "path" : "Observation.component",
        "sliceName" : "DetailedRace",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:DetailedRace.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72826-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:DetailedRace.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Detailed race codes",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "CDC race codes that further specify the 5 OMB race category codes",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/detailed-race|7.0.0"
        }
      },
      {
        "id" : "Observation.component:DetailedRace.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedRace.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedRace.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      }
    ]
  }
}

```
