# SDOHCC Observation Ethnicity OMB - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Observation Ethnicity OMB 

 
Profile for ethnicity observations that use Office of Management and Budget (OMB) ethnicity category codes and CDC ethnicity codes. For further details on this profile see[Specifications for Personal Characteristics](specifications_for_personal_characteristics.md). 

**Usages:**

* Examples for this Profile: [Observation/SDOHCC-ObservationEthnicityOMBExample](Observation-SDOHCC-ObservationEthnicityOMBExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ObservationEthnicityOMB)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ObservationEthnicityOMB.csv), [Excel](../StructureDefinition-SDOHCC-ObservationEthnicityOMB.xlsx), [Schematron](../StructureDefinition-SDOHCC-ObservationEthnicityOMB.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ObservationEthnicityOMB",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationEthnicityOMB",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCObservationEthnicityOMB",
  "title" : "SDOHCC Observation Ethnicity OMB",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for ethnicity observations that use Office of Management and Budget (OMB) ethnicity category codes and CDC ethnicity codes. For further details on this profile see [Specifications for Personal Characteristics](specifications_for_personal_characteristics.html).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationPersonalCharacteristic",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Ethnicity observation",
        "definition" : "For ethnicity observations that use Office of Management and Budget (OMB) ethnicity category codes and CDC ethnicity codes.",
        "comment" : "Used for observations about the ethnicity of an individual.",
        "constraint" : [
          {
            "key" : "SDOH-Ethnicity-1",
            "severity" : "error",
            "human" : "Must have either a dataAbsentReason or at least one of the defined ethnicity components but not both",
            "expression" : "dataAbsentReason.exists() xor component.where(code.coding.exists(system='http://loinc.org' and code='69490-1')).exists()",
            "xpath" : "true()",
            "source" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationEthnicityOMB"
          }
        ]
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69490-1"
            }
          ]
        }
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "max" : "0"
      },
      {
        "id" : "Observation.dataAbsentReason",
        "path" : "Observation.dataAbsentReason",
        "condition" : ["SDOH-Ethnicity-1"],
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationDataAbsentReason"
        }
      },
      {
        "id" : "Observation.method",
        "path" : "Observation.method",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "Methods for personal characteristic observations.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetObservationMethod"
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "type",
              "path" : "value"
            },
            {
              "type" : "value",
              "path" : "value"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.",
        "comment" : "For a discussion on the ways Observations can be assembled in groups together see [Notes](observation.html#notes) below. NOTE: The same LOINC code is used for all three components of this draft profile. If the profile is adopted as part of the US Core standard, new LOINC codes (possibly a panel) will be needed to represent the components (e.g., a new LOINC code for detailed ethnicity and for text description of ethnicity).",
        "requirements" : "Component observations share the same attributes in the Observation resource as the primary observation and are always treated a part of a single observation (they are not separable).",
        "condition" : ["SDOH-Ethnicity-1"]
      },
      {
        "id" : "Observation.component:EthnicityDescription",
        "path" : "Observation.component",
        "sliceName" : "EthnicityDescription",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:EthnicityDescription.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69490-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:EthnicityDescription.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:EthnicityDescription.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:EthnicityDescription.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:EthnicityDescription.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Ethnicity",
        "path" : "Observation.component",
        "sliceName" : "Ethnicity",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Ethnicity.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69490-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Ethnicity.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Hispanic or Latino | Non Hispanic or Latino",
        "requirements" : "An observation exists to have a value, though it might not if it is in error, or if it represents a group of observations. Note: The binding to [SDOHCC-ValueSetOMBEthnicityCategories](ValueSet-SDOHCC-ValueSetOMBEthnicityCategories.html) is used in lieu of [US Core OMB Ethnicity Categories](http://hl7.org/fhir/us/core/ValueSet/omb-ethnicity-category) because, in versions of US Core beyond 3.1.1, the US Core value set include nulls flavors while the SDOH CC value set does not.",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for the two OMB ethnicity categories",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetOMBEthnicityCategories"
        }
      },
      {
        "id" : "Observation.component:Ethnicity.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Ethnicity.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:Ethnicity.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedEthnicity",
        "path" : "Observation.component",
        "sliceName" : "DetailedEthnicity",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Observation.component:DetailedEthnicity.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69490-1"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:DetailedEthnicity.value[x]",
        "path" : "Observation.component.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "CDC ethnicity codes that further specify the 2 OMB ethnicity category codes",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.877|20240606"
        }
      },
      {
        "id" : "Observation.component:DetailedEthnicity.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedEthnicity.interpretation",
        "path" : "Observation.component.interpretation",
        "max" : "0"
      },
      {
        "id" : "Observation.component:DetailedEthnicity.referenceRange",
        "path" : "Observation.component.referenceRange",
        "max" : "0"
      }
    ]
  }
}

```
