# SDOHCC Healthcare Service - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Healthcare Service 

 
Profile that describes the means by which a healthcare service can be contacted. 

### Purpose

SDOHCC Healthcare Service is intended to provide the Healthcare Service address and the contact information for making an appointment. When a subject of care is referred to a Healthcare Service, [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md) (via `Task.input`) can reference SDOHCC Healthcare Service which can provide the Healthcare Service address (via HealthcareService.location) and contact information for making an appointment (via HealthcareService.telecom and [SDOHCC Healthcare Service Telecom Appointment](StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.md)).

**Usages:**

* Derived from this Profile: [SDOHCC Healthcare Service for Referral Management](StructureDefinition-SDOHCC-HealthcareServiceForReferralManagement.md)
* Refer to this Profile: [SDOHCC Observation Program Enrollment Status](StructureDefinition-SDOHCC-ObservationProgramEnrollmentStatus.md) and [SDOHCC Task For Patient](StructureDefinition-SDOHCC-TaskForPatient.md)
* Examples for this Profile: [Family Counseling Services](HealthcareService-SDOHCC-HealthcareServiceTelecomAppointmentExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-HealthcareService)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-HealthcareService.csv), [Excel](../StructureDefinition-SDOHCC-HealthcareService.xlsx), [Schematron](../StructureDefinition-SDOHCC-HealthcareService.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-HealthcareService",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-HealthcareService",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCHealthcareService",
  "title" : "SDOHCC Healthcare Service",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile that describes the means by which a healthcare service can be contacted.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "HealthcareService",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/HealthcareService",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HealthcareService",
        "path" : "HealthcareService"
      },
      {
        "id" : "HealthcareService.active",
        "path" : "HealthcareService.active",
        "min" : 1,
        "fixedBoolean" : true,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.type",
        "path" : "HealthcareService.type",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetHealthcareServiceType"
        }
      },
      {
        "id" : "HealthcareService.location",
        "path" : "HealthcareService.location",
        "requirements" : "The location must support Location.address so that the patient knows potential addresses when booking an appointment.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Location"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.telecom",
        "path" : "HealthcareService.telecom",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "exists",
              "path" : "extension('http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment')"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : false
      },
      {
        "id" : "HealthcareService.telecom:AppointmentContact",
        "path" : "HealthcareService.telecom",
        "sliceName" : "AppointmentContact",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.telecom:AppointmentContact.extension",
        "path" : "HealthcareService.telecom.extension",
        "min" : 1
      },
      {
        "id" : "HealthcareService.telecom:AppointmentContact.extension:ForAppointment",
        "path" : "HealthcareService.telecom.extension",
        "sliceName" : "ForAppointment",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.telecom:AppointmentContact.system",
        "path" : "HealthcareService.telecom.system",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.telecom:AppointmentContact.value",
        "path" : "HealthcareService.telecom.value",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.program",
        "path" : "HealthcareService.program",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.312"
        }
      },
      {
        "id" : "HealthcareService.communication",
        "path" : "HealthcareService.communication",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.appointmentRequired",
        "path" : "HealthcareService.appointmentRequired",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availableTime",
        "path" : "HealthcareService.availableTime",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.notAvailable",
        "path" : "HealthcareService.notAvailable",
        "mustSupport" : true
      },
      {
        "id" : "HealthcareService.availabilityExceptions",
        "path" : "HealthcareService.availabilityExceptions",
        "mustSupport" : true
      }
    ]
  }
}

```
