# SDOHCC Goal - SDOH Clinical Care v3.0.0-ballot

## Resource Profile: SDOHCC Goal 

 
Profile for goals that address Social Determinants of Health (SDOH). 

### Purpose

[SDOHCC Goal](StructureDefinition-SDOHCC-Goal.md) is generally intended to represent a goal established to address an identified social risk or need (e.g., [SDOHCC Condition](StructureDefinition-SDOHCC-Condition.md), [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md), [SDOHCC Observation Assessment](StructureDefinition-SDOHCC-ObservationAssessment.md)). An [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md) and [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md) can pertain to an SDOHCC Goal. See the [Data Modeling Framework](sdoh_clinical_care_scope.md#data-modeling-framework) for more detail on the relationships between SDOHCC Goal and the other profiles in this IG.

### Usage

`Goal.description` has a binding to [US Core Goal Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-goal-description.html) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). `Goal.description` also has additional bindings to SDOH domain-specific value sets (e.g., for Food Insecurity) which are determined by the value selected for `Goal.category`. When `Goal.category` is a value from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity), `Goal.description` **SHALL** be selected from the corresponding domain-specific value set found in Additional Bindings (i.e. [Food Insecurity Goals](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.16/expansion/Latest)). If more than one value is selected from [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md) (e.g., food-insecurity **and** financial-insecurity) for `Goal.category`, then `Goal.description` **SHALL** be selected from at least one of the corresponding domain-specific value sets found in Additional Bindings (e.g. [Food Insecurity Goals](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1247.16/expansion/Latest)).

Of note, Gravity Project is continuously developing terminology for new SDOH domains. Sometimes, a new SDOH domain may already be represented by a category code in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md), but a domain-specific value set may not yet be available in VSAC. In this case, the Additional Binding for the new SDOH domain/category is the default binding for the profile element. Additionally, sometimes a domain-specific value set for a new domain is available in VSAC but does not yet include all standardized codes identified during the domain’s terminology development cycle. In this case, the value set’s “Description” tab in VSAC will state, “In progress”. Additional information related to Gravity value sets is provided on the [Social Risk Terminology Value Sets](https://confluence.hl7.org/display/GRAV/Social+Risk+Terminology+Value+Sets) page on the Gravity Project Confluence site.

Additionally, some SDOH domains may not yet be represented in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Goal.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used so that the Goal instance can still be categorized as SDOH-related. If desired, `Goal.category.text` can also be used to further specify the domain. For example, at the time of publication of this IG, “disability-status” is not yet included in [SDOHCC ValueSet SDOH Category](ValueSet-SDOHCC-ValueSetSDOHCategory.md). In this case, `Goal.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified) can be used along with `Goal.category.text`: Disability Status. For `Goal.category`: [sdoh-category-unspecified](CodeSystem-SDOHCC-CodeSystemTemporaryCodes.md#SDOHCC-CodeSystemTemporaryCodes-sdoh-category-unspecified), there will not be domain-specific value sets and Additional Bindings for `Goal.description` will designate the default binding to [US Core Goal Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-goal-description.html) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)).

For more information on the correlation between `Goal.category` and the domain-specific value sets in Additional Bindings for `Goal.description`, see [Gravity Project Value Sets](gravity_terminology.md#gravity-project-value-sets).

**Usages:**

* Refer to this Profile: [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md), [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md) and [SDOHCC Task For Referral Management](StructureDefinition-SDOHCC-TaskForReferralManagement.md)
* Examples for this Profile: [Goal/SDOHCC-GoalFoodSecurityExample](Goal-SDOHCC-GoalFoodSecurityExample.md)
* CapabilityStatements using this Profile: [SDOHCC Coordination Platform](CapabilityStatement-SDOHCC-CoordinationPlatform.md), [SDOHCC Patient Application](CapabilityStatement-SDOHCC-PatientApp.md), [SDOHCC Referral Recipient](CapabilityStatement-SDOHCC-ReferralRecipient.md), [SDOHCC Referral Recipient - Light](CapabilityStatement-SDOHCC-ReferralRecipientLight.md) and [SDOHCC Referral Source](CapabilityStatement-SDOHCC-ReferralSource.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-Goal)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-Goal.csv), [Excel](../StructureDefinition-SDOHCC-Goal.xlsx), [Schematron](../StructureDefinition-SDOHCC-Goal.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-Goal",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile",
      "valueCanonical" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|3.1.1"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCGoal",
  "title" : "SDOHCC Goal",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for goals that address Social Determinants of Health (SDOH).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Goal",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|7.0.0",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Goal",
        "path" : "Goal",
        "short" : "Describes the intended SDOH-related objective(s) for a patient.",
        "definition" : "For representation of SDOH goals.",
        "comment" : "Many of the SDOHCC profiles reference one another. One flow supported by this IG is that QuestionnaireResponses result in Observations that can be used as evidence for Conditions that can lead to Goals, ServiceRequests and Procedures. However, alternatives paths are also possible."
      },
      {
        "id" : "Goal.achievementStatus",
        "path" : "Goal.achievementStatus",
        "mustSupport" : true
      },
      {
        "id" : "Goal.category",
        "path" : "Goal.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Goal.category:SDOHCC",
        "path" : "Goal.category",
        "sliceName" : "SDOHCC",
        "short" : "e.g., food-insecurity | transportation-insecurity",
        "definition" : "An SDOH category assigned to the goal.",
        "requirements" : "Codes from this value set can be used to assign one or more SDOH categories (e.g., food-insecurity, transportation-insecurity, etc.) to a goal. It is recommended that SDOH category codes be used to facilitate searching for SDOH-related goals.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "Codes for high-level SDOH categories.",
          "valueSet" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ValueSet/SDOHCC-ValueSetSDOHCategory"
        }
      },
      {
        "id" : "Goal.description",
        "path" : "Goal.description",
        "comment" : "If no code is available, use CodeableConcept.text.\r\n\r",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.233"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-access"
                        }
                      ],
                      "text" : "digital-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "digital-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.225"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "digital-literacy"
                        }
                      ],
                      "text" : "digital-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "educational-attainment"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.55|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "educational-attainment"
                        }
                      ],
                      "text" : "educational-attainment"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "elder-abuse"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.65"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "elder-abuse"
                        }
                      ],
                      "text" : "elder-abuse"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "employment-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.70|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "employment-status"
                        }
                      ],
                      "text" : "employment-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "financial-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.30|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "financial-insecurity"
                        }
                      ],
                      "text" : "financial-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "food-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.16|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "food-insecurity"
                        }
                      ],
                      "text" : "food-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "health-insurance-coverage-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.121|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "health-insurance-coverage-status"
                        }
                      ],
                      "text" : "health-insurance-coverage-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "homelessness"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.159|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "homelessness"
                        }
                      ],
                      "text" : "homelessness"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "housing-instability"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.161|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "housing-instability"
                        }
                      ],
                      "text" : "housing-instability"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "inadequate-housing"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.50|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "inadequate-housing"
                        }
                      ],
                      "text" : "inadequate-housing"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "incarceration-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.257"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "incarceration-status"
                        }
                      ],
                      "text" : "incarceration-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "intimate-partner-violence"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.100|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "intimate-partner-violence"
                        }
                      ],
                      "text" : "intimate-partner-violence"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "language-access"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.266"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "language-access"
                        }
                      ],
                      "text" : "language-access"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "material-hardship"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.37|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "material-hardship"
                        }
                      ],
                      "text" : "material-hardship"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "medical-cost-burden"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.120|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "medical-cost-burden"
                        }
                      ],
                      "text" : "medical-cost-burden"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "personal-health-literacy"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.117|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "personal-health-literacy"
                        }
                      ],
                      "text" : "personal-health-literacy"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "social-connection"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.89|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "social-connection"
                        }
                      ],
                      "text" : "social-connection"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "stress"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.86|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "stress"
                        }
                      ],
                      "text" : "stress"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "transportation-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.163|20240604"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "transportation-insecurity"
                        }
                      ],
                      "text" : "transportation-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "utility-insecurity"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.245"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "utility-insecurity"
                        }
                      ],
                      "text" : "utility-insecurity"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "veteran-status"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1247.214"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "veteran-status"
                        }
                      ],
                      "text" : "veteran-status"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            },
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "sdoh-category-unspecified"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description|7.0.0"
                },
                {
                  "url" : "usage",
                  "valueUsageContext" : {
                    "code" : {
                      "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Goal",
                      "code" : "Goal.category"
                    },
                    "valueCodeableConcept" : {
                      "coding" : [
                        {
                          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
                          "code" : "sdoh-category-unspecified"
                        }
                      ],
                      "text" : "sdoh-category-unspecified"
                    }
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "extensible",
          "description" : "Codes providing the details of a particular goal.  In many systems, only the text element will be used.",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description|7.0.0"
        }
      },
      {
        "id" : "Goal.subject",
        "path" : "Goal.subject",
        "definition" : "Identifies the patient for whom the goal is being established.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
            ]
          }
        ]
      },
      {
        "id" : "Goal.target.measure",
        "path" : "Goal.target.measure",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "GoalTargetMeasure"
            }
          ],
          "strength" : "preferred",
          "description" : "Codes to identify the value being tracked, e.g. body weight, blood pressure, or hemoglobin A1c level.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Goal.statusDate",
        "path" : "Goal.statusDate",
        "comment" : "To see the date for past statuses, query history.\r\n\r\nThe Goal Resource does not clearly specify whether Goal.statusDate applies to Goal.achievementStatus or to Goal.lifecycleStatus. For consistent use in the SDOH context, it is recommended that Goal.statusDate be synchronized with Goal.achievementStatus."
      },
      {
        "id" : "Goal.addresses",
        "path" : "Goal.addresses",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/RiskAssessment"
            ]
          }
        ]
      },
      {
        "id" : "Goal.addresses:SupportedAddresses",
        "path" : "Goal.addresses",
        "sliceName" : "SupportedAddresses",
        "requirements" : "When a goal addresses SDOH screening response observations generated from a survey/questionnaire, SDOH assessment observations, or SDOH conditions, Goal.addresses should reference instances that comply with the SDOHCC Observation Screening Response, SDOHCC Condition, or SDOHCC Observation Assessment profiles. However, references to other instance types are also possible.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Condition",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Goal.outcomeCode",
        "path" : "Goal.outcomeCode",
        "comment" : "Note that this should not duplicate the goal status.\r\n\r\nInformation represented by Goal.outcomeCode may overlap significantly with information represented by Goal.outcomeReference. Multiple approaches to representing the same information may negatively impact interoperability. Therefore, where there is significant overlap in information provided by Goal.outcomeCode and Goal.outcomeReference, it is recommended that Goal.outcomeReference should be used to provide details of goal outcomes.\r\n\r",
        "binding" : {
          "strength" : "preferred",
          "description" : "The result of the goal; e.g., \"Food security\", \"Has access to a car \".",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-goal-description|7.0.0"
        }
      },
      {
        "id" : "Goal.outcomeReference",
        "path" : "Goal.outcomeReference",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "comment" : "The goal outcome is independent of the outcome of the related activities.  For example, if the Goal is to achieve a target body weight of 150 lb and a care plan activity is defined to diet, then the care plan’s activity outcome could be calories consumed whereas goal outcome is an observation for the actual body weight measured.\r\n\r\nAdditionally, see comments for Goal.outcomeCode."
      },
      {
        "id" : "Goal.outcomeReference:SupportedOutcomeReference",
        "path" : "Goal.outcomeReference",
        "sliceName" : "SupportedOutcomeReference",
        "requirements" : "When a goal outcome can be represented by SDOH screening response observations or SDOH assessment observations, Goal.outcome should reference instances that comply with the SDOHCC Observation Screening Response or SDOHCC Observation Assessment profiles. However, references to other instance types are also possible.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse",
              "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationAssessment"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
