# SDOHCC Extension HealthcareService Telecom Appointment - SDOH Clinical Care v3.0.0-ballot

## Extension: SDOHCC Extension HealthcareService Telecom Appointment 

Extension for flagging a HealthcareService.telecom as one the patient can use to make an appointment.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [SDOHCC Healthcare Service](StructureDefinition-SDOHCC-HealthcareService.md)
* Examples for this Extension: [HACC](HealthcareService-SDOHCC-HealthcareServiceSocialCareProgram.md) and [Family Counseling Services](HealthcareService-SDOHCC-HealthcareServiceTelecomAppointmentExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.sdoh-clinicalcare|current/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.csv), [Excel](../StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.xlsx), [Schematron](../StructureDefinition-SDOHCC-ExtensionHealthcareServiceTelecomAppointment.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SDOHCC-ExtensionHealthcareServiceTelecomAppointment",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment",
  "version" : "3.0.0-ballot",
  "name" : "SDOHCCExtensionHealthcareServiceTelecomAppointment",
  "title" : "SDOHCC Extension HealthcareService Telecom Appointment",
  "status" : "active",
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "Extension for flagging a HealthcareService.telecom as one the patient can use to make an appointment.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "HealthcareService.telecom"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Telecom is for making appointments",
        "definition" : "For flagging a HealthcareService.telecom as one the patient can use to make an appointment.",
        "max" : "1"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ExtensionHealthcareServiceTelecomAppointment"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : true
      }
    ]
  }
}

```
