# SDOHCC ServiceRequest Subreferral Summer Food Program Example - SDOH Clinical Care v3.0.0-ballot

## Example ServiceRequest: SDOHCC ServiceRequest Subreferral Summer Food Program Example

Language: en

Profile: [SDOHCC ServiceRequest](StructureDefinition-SDOHCC-ServiceRequest.md)

**basedOn**: [ServiceRequest Assistance with application for food pantry program](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md)

**status**: Completed

**intent**: Original Order

**category**: Social service procedure, Food Insecurity

**code**: Assistance with application for Summer Food Service Program

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**reasonReference**: [Condition Food insecurity](Condition-SDOHCC-ConditionFoodInsecurityExample.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "SDOHCC-ServiceRequestSubreferralSummerFoodProgramExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ServiceRequest"
    ]
  },
  "language" : "en",
  "basedOn" : [
    {
      "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample"
    }
  ],
  "status" : "completed",
  "intent" : "original-order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "410606002",
          "display" : "Social service procedure"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "food-insecurity",
          "display" : "Food Insecurity"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "467681000124101",
        "display" : "Assistance with application for Summer Food Service Program"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "reasonReference" : [
    {
      "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
    }
  ]
}

```
