# TaskOutputReference - SDOH Clinical Care v3.0.0-ballot

## SearchParameter: TaskOutputReference 

 
The value of any outputs of type 'Reference' 



## Resource Content

```json
{
  "resourceType" : "SearchParameter",
  "id" : "Task-output-reference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pc"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/sdoh-clinicalcare/ImplementationGuide/hl7.fhir.us.sdoh-clinicalcare"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/sdoh-clinicalcare/SearchParameter/Task-output-reference",
  "version" : "3.0.0-ballot",
  "name" : "TaskOutputReference",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-13T17:11:59+00:00",
  "publisher" : "HL7 International / Patient Care",
  "contact" : [
    {
      "name" : "HL7 International / Patient Care",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/patientcare"
        },
        {
          "system" : "email",
          "value" : "patientcare@lists.hl7.org"
        }
      ]
    }
  ],
  "description" : "The value of any outputs of type 'Reference'",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US",
          "display" : "United States of America"
        }
      ]
    }
  ],
  "code" : "output",
  "base" : ["Task"],
  "type" : "reference",
  "expression" : "Task.output.value.ofType(Reference)",
  "xpathUsage" : "normal",
  "multipleOr" : true,
  "multipleAnd" : true
}

```
