# SDOHCC Procedure Food Pantry Application Assistance Example - SDOH Clinical Care v3.0.0-ballot

## Example Procedure: SDOHCC Procedure Food Pantry Application Assistance Example

Language: en

Profile: [SDOHCC Procedure](StructureDefinition-SDOHCC-Procedure.md)

**basedOn**: [ServiceRequest Assistance with application for food pantry program](ServiceRequest-SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample.md)

**status**: Completed

**category**: Social service procedure

**code**: Assistance with application for food pantry program

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**performed**: 2020-09-16

**reasonReference**: [Condition Food insecurity](Condition-SDOHCC-ConditionFoodInsecurityExample.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "SDOHCC-ProcedureFoodPantryApplicationAssistanceExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-Procedure"
    ]
  },
  "language" : "en",
  "basedOn" : [
    {
      "reference" : "ServiceRequest/SDOHCC-ServiceRequestActiveFoodPantryApplicationAssistExample"
    }
  ],
  "status" : "completed",
  "category" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "410606002",
        "display" : "Social service procedure"
      },
      {
        "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
        "code" : "food-insecurity",
        "display" : "Food Insecurity"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "467771000124109",
        "display" : "Assistance with application for food pantry program"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "performedDateTime" : "2020-09-16",
  "reasonReference" : [
    {
      "reference" : "Condition/SDOHCC-ConditionFoodInsecurityExample"
    }
  ]
}

```
