# Patient Colin Abbas Example - SDOH Clinical Care v3.0.0-ballot

## Example Patient: Patient Colin Abbas Example

Language: en

Profile: [US Core Patient Profileversion: null7.0.0)](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-patient.html)

COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Alt. Name: | COLIN V. BAXTER |
| Contact Detail | * ph: 555-555-5555(Home)
* 49 Meadow St Mounds OK 74047 US 
* 183 Mountain View St Mounds OK 74048 US 
 |
| US Core Ethnicity Extension: | * ombCategory: [Race & Ethnicity - CDC: 2135-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2135-2) (Hispanic or Latino)
* detailed: [Race & Ethnicity - CDC: 2184-0](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2184-0) (Dominican)
* detailed: [Race & Ethnicity - CDC: 2148-5](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2148-5) (Mexican)
* text: Hispanic or Latino
 |
| [US Core Birth Sex Extension](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-birthsex.html) | M |
| US Core Race Extension: | * ombCategory: [Race & Ethnicity - CDC: 2106-3](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2106-3) (White)
* ombCategory: [Race & Ethnicity - CDC: 1002-5](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-1002-5) (American Indian or Alaska Native)
* ombCategory: [Race & Ethnicity - CDC: 2028-9](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2028-9) (Asian)
* detailed: [Race & Ethnicity - CDC: 1586-7](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-1586-7) (Shoshone)
* detailed: [Race & Ethnicity - CDC: 2036-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2036-2) (Filipino)
* text: Mixed
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat-53234",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|7.0.0"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2106-3",
            "display" : "White"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1002-5",
            "display" : "American Indian or Alaska Native"
          }
        },
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2028-9",
            "display" : "Asian"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "1586-7",
            "display" : "Shoshone"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2036-2",
            "display" : "Filipino"
          }
        },
        {
          "url" : "text",
          "valueString" : "Mixed"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
    },
    {
      "extension" : [
        {
          "url" : "ombCategory",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2135-2",
            "display" : "Hispanic or Latino"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2184-0",
            "display" : "Dominican"
          }
        },
        {
          "url" : "detailed",
          "valueCoding" : {
            "system" : "urn:oid:2.16.840.1.113883.6.238",
            "code" : "2148-5",
            "display" : "Mexican"
          }
        },
        {
          "url" : "text",
          "valueString" : "Hispanic or Latino"
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
    },
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex",
      "valueCode" : "M"
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "version" : "5.0.0",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://hospital.smarthealthit.org",
      "value" : "1032702"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "ABBAS",
      "given" : ["COLIN", "V."],
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "family" : "BAXTER",
      "given" : ["COLIN", "V."],
      "suffix" : ["PharmD"],
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "birthDate" : "1987-02-20",
  "address" : [
    {
      "line" : ["49 Meadow St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "line" : ["183 Mountain View St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74048",
      "country" : "US",
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ]
}

```
