# SDOHCC Observation Response PRAPARE Child Care Need Example - SDOH Clinical Care v3.0.0-ballot

## Example Observation: SDOHCC Observation Response PRAPARE Child Care Need Example

Language: en

Profile: [SDOHCC Observation Screening Response](StructureDefinition-SDOHCC-ObservationScreeningResponse.md)

**status**: Final

**category**: Survey, SDOH, Material Hardship

**code**: Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]

**subject**: [COLIN V. ABBAS Male, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))](Patient-pat-53234.md)

**effective**: 2021-04-26 13:56:33+0000

**issued**: 2021-04-26 13:56:33+0000

**performer**: [COLIN ABBAS](Patient-pat-53234.md)

**value**: Child care

**derivedFrom**: [Response to Questionnaire '->SDOHCC Questionnaire PRAPARE' about '->COLIN ABBAS'](QuestionnaireResponse-SDOHCC-QuestionnaireResponsePRAPAREExample.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "SDOHCC-ObservationResponsePRAPAREChildCareNeedExample",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/sdoh-clinicalcare/StructureDefinition/SDOHCC-ObservationScreeningResponse"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "survey",
          "display" : "Survey"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-category",
          "code" : "sdoh",
          "display" : "SDOH"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/sdoh-clinicalcare/CodeSystem/SDOHCC-CodeSystemTemporaryCodes",
          "code" : "material-hardship",
          "display" : "Material Hardship"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93031-3",
        "display" : "Have you or any family members you live with been unable to get any of the following when it was really needed in past 1 year [PRAPARE]"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat-53234"
  },
  "effectiveDateTime" : "2021-04-26T13:56:33.747Z",
  "issued" : "2021-04-26T13:56:33.747Z",
  "performer" : [
    {
      "reference" : "Patient/pat-53234",
      "display" : "COLIN ABBAS"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "LA30127-7",
        "display" : "Child care"
      }
    ]
  },
  "derivedFrom" : [
    {
      "reference" : "QuestionnaireResponse/SDOHCC-QuestionnaireResponsePRAPAREExample"
    }
  ]
}

```
